/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragSequenceEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventFilter;
import edu.umd.cs.piccolo.util.PDimension;

public class PDragEventHandler
extends PDragSequenceEventHandler {
    private PNode draggedNode;
    private boolean moveToFrontOnPress = false;

    public PDragEventHandler() {
        this.setEventFilter(new PInputEventFilter(16));
    }

    protected PNode getDraggedNode() {
        return this.draggedNode;
    }

    protected void setDraggedNode(PNode draggedNode) {
        this.draggedNode = draggedNode;
    }

    @Override
    protected boolean shouldStartDragInteraction(PInputEvent event) {
        if (super.shouldStartDragInteraction(event)) {
            return event.getPickedNode() != event.getTopCamera();
        }
        return false;
    }

    @Override
    protected void startDrag(PInputEvent event) {
        super.startDrag(event);
        this.draggedNode = event.getPickedNode();
        if (this.moveToFrontOnPress) {
            this.draggedNode.moveToFront();
        }
    }

    @Override
    protected void drag(PInputEvent event) {
        super.drag(event);
        PDimension d = event.getDeltaRelativeTo(this.draggedNode);
        this.draggedNode.localToParent(d);
        this.draggedNode.offset(d.getWidth(), d.getHeight());
    }

    @Override
    protected void endDrag(PInputEvent event) {
        super.endDrag(event);
        this.draggedNode = null;
    }

    public boolean getMoveToFrontOnPress() {
        return this.moveToFrontOnPress;
    }

    public void setMoveToFrontOnPress(boolean moveToFrontOnPress) {
        this.moveToFrontOnPress = moveToFrontOnPress;
    }

    @Override
    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("draggedNode=" + this.draggedNode == null ? "null" : this.draggedNode.toString());
        if (this.moveToFrontOnPress) {
            result.append(",moveToFrontOnPress");
        }
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

