/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.util.PAffineTransform;
import java.awt.geom.AffineTransform;

public class PTransformActivity
extends PInterpolatingActivity {
    private static PAffineTransform STATIC_TRANSFORM = new PAffineTransform();
    private double[] source = new double[6];
    private double[] destination = new double[6];
    private Target target;

    public PTransformActivity(long duration, long stepRate, Target aTarget) {
        this(duration, stepRate, aTarget, null);
    }

    public PTransformActivity(long duration, long stepRate, Target aTarget, AffineTransform aDestination) {
        this(duration, stepRate, 1, 1, aTarget, aDestination);
    }

    public PTransformActivity(long duration, long stepRate, int loopCount, int mode, Target aTarget, AffineTransform aDestination) {
        super(duration, stepRate, loopCount, mode);
        this.target = aTarget;
        if (aDestination != null) {
            aDestination.getMatrix(this.destination);
        }
    }

    @Override
    protected boolean isAnimation() {
        return true;
    }

    public double[] getDestinationTransform() {
        return this.destination;
    }

    public void setDestinationTransform(double[] newDestination) {
        this.destination = newDestination;
    }

    @Override
    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.target.getSourceMatrix(this.source);
        }
        super.activityStarted();
    }

    @Override
    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        STATIC_TRANSFORM.setTransform(this.source[0] + (double)zeroToOne * (this.destination[0] - this.source[0]), this.source[1] + (double)zeroToOne * (this.destination[1] - this.source[1]), this.source[2] + (double)zeroToOne * (this.destination[2] - this.source[2]), this.source[3] + (double)zeroToOne * (this.destination[3] - this.source[3]), this.source[4] + (double)zeroToOne * (this.destination[4] - this.source[4]), this.source[5] + (double)zeroToOne * (this.destination[5] - this.source[5]));
        this.target.setTransform(STATIC_TRANSFORM);
    }

    @Override
    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("source=" + (this.source == null ? "null" : this.source.toString()));
        result.append(",destination=" + (this.destination == null ? "null" : this.destination.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }

    public static interface Target {
        public void setTransform(AffineTransform var1);

        public void getSourceMatrix(double[] var1);
    }
}

