/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import java.awt.Color;

public class PColorActivity
extends PInterpolatingActivity {
    private Color source;
    private Color destination;
    private Target target;

    public PColorActivity(long duration, long stepRate, Target aTarget) {
        this(duration, stepRate, aTarget, null);
    }

    public PColorActivity(long duration, long stepRate, Target aTarget, Color aDestination) {
        this(duration, stepRate, 1, 1, aTarget, aDestination);
    }

    public PColorActivity(long duration, long stepRate, int loopCount, int mode, Target aTarget, Color aDestination) {
        super(duration, stepRate, loopCount, mode);
        this.target = aTarget;
        this.destination = aDestination;
    }

    @Override
    protected boolean isAnimation() {
        return true;
    }

    public Color getDestinationColor() {
        return this.destination;
    }

    public void setDestinationColor(Color newDestination) {
        this.destination = newDestination;
    }

    @Override
    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.source = this.target.getColor();
        }
        super.activityStarted();
    }

    @Override
    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        float red = (float)this.source.getRed() + zeroToOne * (float)(this.destination.getRed() - this.source.getRed());
        float green = (float)this.source.getGreen() + zeroToOne * (float)(this.destination.getGreen() - this.source.getGreen());
        float blue = (float)this.source.getBlue() + zeroToOne * (float)(this.destination.getBlue() - this.source.getBlue());
        float alpha = (float)this.source.getAlpha() + zeroToOne * (float)(this.destination.getAlpha() - this.source.getAlpha());
        this.target.setColor(new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f));
    }

    @Override
    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("source=" + (this.source == null ? "null" : this.source.toString()));
        result.append(",destination=" + (this.destination == null ? "null" : this.destination.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }

    public static interface Target {
        public void setColor(Color var1);

        public Color getColor();
    }
}

