/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class PActivityScheduler {
    private PRoot root;
    private List activities;
    private Timer activityTimer;
    private boolean activitiesChanged;
    private boolean animating;
    private ArrayList processingActivities;

    public PActivityScheduler(PRoot rootNode) {
        this.root = rootNode;
        this.activities = new ArrayList();
        this.processingActivities = new ArrayList();
    }

    public PRoot getRoot() {
        return this.root;
    }

    public void addActivity(PActivity activity) {
        this.addActivity(activity, false);
    }

    public void addActivity(PActivity activity, boolean processLast) {
        if (this.activities.contains(activity)) {
            return;
        }
        this.activitiesChanged = true;
        if (processLast) {
            this.activities.add(0, activity);
        } else {
            this.activities.add(activity);
        }
        activity.setActivityScheduler(this);
        if (!this.getActivityTimer().isRunning()) {
            this.startActivityTimer();
        }
    }

    public void removeActivity(PActivity activity) {
        if (!this.activities.contains(activity)) {
            return;
        }
        this.activitiesChanged = true;
        this.activities.remove(activity);
        if (this.activities.size() == 0) {
            this.stopActivityTimer();
        }
    }

    public void removeAllActivities() {
        this.activitiesChanged = true;
        this.activities.clear();
        this.stopActivityTimer();
    }

    public List getActivitiesReference() {
        return this.activities;
    }

    public void processActivities(long currentTime) {
        int size = this.activities.size();
        if (size > 0) {
            this.processingActivities.clear();
            this.processingActivities.addAll(this.activities);
            int i = size - 1;
            while (i >= 0) {
                PActivity each = (PActivity)this.processingActivities.get(i);
                each.processStep(currentTime);
                --i;
            }
        }
    }

    public boolean getAnimating() {
        if (this.activitiesChanged) {
            this.animating = false;
            int i = 0;
            while (i < this.activities.size()) {
                PActivity each = (PActivity)this.activities.get(i);
                this.animating |= each.isAnimation();
                ++i;
            }
            this.activitiesChanged = false;
        }
        return this.animating;
    }

    protected void startActivityTimer() {
        this.getActivityTimer().start();
    }

    protected void stopActivityTimer() {
        this.getActivityTimer().stop();
    }

    protected Timer getActivityTimer() {
        if (this.activityTimer == null) {
            this.activityTimer = this.root.createTimer(PUtil.ACTIVITY_SCHEDULER_FRAME_DELAY, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PActivityScheduler.this.root.processInputs();
                }
            });
        }
        return this.activityTimer;
    }
}

