/*
 * Decompiled with CFR 0.152.
 */
package pnexport;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;

public class PNMLSaver {
    private String fileName;

    public PNMLSaver(String fileName) {
        this.fileName = fileName;
    }

    public void save(ArrayList<IPetriNet> nets) {
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(this.fileName));
            String s = this.generateHeader();
            for (int i = 0; i < nets.size(); ++i) {
                s = s + this.generateNet(nets.get(i));
            }
            s = s + this.generateFooter();
            dos.writeBytes(s);
            dos.close();
        }
        catch (Exception e) {
            System.out.println("error onSaveFile: " + e.toString());
        }
    }

    private String generateHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n<pnml xmlns=\"http://www.pnml.org/version-2009/grammar/pnml\">\n";
    }

    private String generateNet(IPetriNet net) {
        int i;
        String s = "  <net id=\"" + net.getId() + "\" type=\"http://www.pnml.org/version-2009/grammar/pnmlcoremodel\">\n";
        s = s + "    <name>\n";
        s = s + "      <text>" + net.getName() + "</text>\n";
        s = s + "    </name>\n";
        s = s + "    <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
        s = s + "      <type>" + net.getType() + "</type>\n";
        s = s + "    </toolspecific>\n";
        s = s + "    <page id=\"page0\">\n";
        for (i = 0; i < net.getPlaces().size(); ++i) {
            s = s + this.generatePlace(net.getPlaces().get(i), net);
        }
        for (i = 0; i < net.getTransitions().size(); ++i) {
            s = s + this.generateTransition(net.getTransitions().get(i), net);
        }
        for (i = 0; i < net.getArcs().size(); ++i) {
            s = s + this.generateArcs(net.getArcs().get(i));
        }
        String mw = null;
        if (net.getAdditionalData() instanceof Properties) {
            if (((Properties)net.getAdditionalData()).get("mwAutomaton") instanceof String) {
                mw = (String)((Properties)net.getAdditionalData()).get("mwAutomaton");
            } else if (((Properties)net.getAdditionalData()).get("mwAutomaton") instanceof Node) {
                mw = this.elementToString((Node)((Properties)net.getAdditionalData()).get("mwAutomaton"));
            }
        }
        if (mw != null) {
            s = s + "  <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = s + mw;
            s = s + "  </toolspecific>\n";
        }
        s = s + "  </page>\n";
        s = s + "  </net>\n";
        return s;
    }

    private String generatePlace(IPlace p, IPetriNet pn) {
        ArrayList a;
        String s = "    <place id=\"" + p.getId() + "\">\n";
        s = s + "      <name>\n";
        s = s + "        <graphics>\n";
        s = s + "          <offset x=\"" + (int)(p.getNameX() - p.getX()) + "\" y=\"" + (int)(p.getNameY() - p.getY()) + "\" />\n";
        s = s + "        </graphics>\n";
        s = s + "        <text>" + p.getName() + "</text>\n";
        s = s + "      </name>\n";
        s = s + "      <graphics>\n";
        s = s + "        <position x=\"" + (int)p.getX() + "\" y=\"" + (int)p.getY() + "\" />\n";
        int red = ((Color)((Properties)p.getAdditionalData()).get("Color")).getRed();
        int green = ((Color)((Properties)p.getAdditionalData()).get("Color")).getGreen();
        int blue = ((Color)((Properties)p.getAdditionalData()).get("Color")).getBlue();
        s = s + "        <fill color=\"rgb(" + red + "," + green + "," + blue + ")\" />\n";
        s = s + "      </graphics>\n";
        s = s + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
        s = s + "        <initialMarking>\n";
        s = s + "          <graphics>\n";
        s = s + "            <offset x=\"0\" y=\"0\" />\n";
        s = s + "          </graphics>\n";
        s = s + "          <text>" + p.getTokens() + "</text>\n";
        s = s + "        </initialMarking>\n";
        if (pn.getType().equals("EvPN") && p.getType() != null) {
            if (p.getType().equals("p")) {
                s = s + "        <evpnPlace type=\"p\" />\n";
            }
            if (p.getType().equals("pf")) {
                s = s + "        <evpnPlace type=\"pf\" >\n";
                s = s + "          <exp>" + ((Properties)p.getAdditionalData()).getProperty("EvPN Pf") + "</exp>\n";
                s = s + "        </evpnPlace>\n";
            }
            if (p.getType().equals("pe")) {
                s = s + "        <evpnPlace type=\"pe\" >\n";
                s = s + "          <exp>" + ((Properties)p.getAdditionalData()).getProperty("EvPN Pe") + "</exp>\n";
                s = s + "        </evpnPlace>\n";
            }
        }
        if (pn.getType().equals("TB") && p.getAdditionalData() instanceof Properties && ((Properties)p.getAdditionalData()).containsKey("TB Tokens") && ((Properties)p.getAdditionalData()).get("TB Tokens") instanceof ArrayList && (a = (ArrayList)((Properties)p.getAdditionalData()).get("TB Tokens")).size() > 0) {
            s = s + "        <tbPlace>\n";
            for (int i = 0; i < a.size(); ++i) {
                s = s + "        <token minValue=\"" + Math.round(((double[])a.get(i))[0]) + "\" maxValue=\"" + Math.round(((double[])a.get(i))[1]) + "\" />\n";
            }
            s = s + "        </tbPlace>\n";
        }
        s = s + "      </toolspecific>\n";
        s = s + "    </place>\n";
        return s;
    }

    private String generateTransition(ITransition t, IPetriNet pn) {
        String s = "    <transition id=\"" + t.getId() + "\">\n";
        s = s + "      <name>\n";
        s = s + "        <graphics>\n";
        s = s + "          <offset x=\"" + (int)(t.getNameX() - t.getX()) + "\" y=\"" + (int)(t.getNameY() - t.getY()) + "\" />\n";
        s = s + "        </graphics>\n";
        s = s + "        <text>" + t.getName() + "</text>\n";
        s = s + "      </name>\n";
        s = s + "      <graphics>\n";
        s = s + "        <position x=\"" + (int)t.getX() + "\" y=\"" + (int)t.getY() + "\" />\n";
        int red = ((Color)((Properties)t.getAdditionalData()).get("Color")).getRed();
        int green = ((Color)((Properties)t.getAdditionalData()).get("Color")).getGreen();
        int blue = ((Color)((Properties)t.getAdditionalData()).get("Color")).getBlue();
        s = s + "        <fill color=\"rgb(" + red + "," + green + "," + blue + ")\" />\n";
        s = s + "      </graphics>\n";
        if (pn.getType().equals("TB") && t.getAdditionalData() instanceof Properties && ((Properties)t.getAdditionalData()).containsKey("TB Function") && ((Properties)t.getAdditionalData()).get("TB Function") != null) {
            s = s + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
            s = s + "        <tbTransition>\n";
            s = s + "          <tbFunction>" + (String)((Properties)t.getAdditionalData()).get("TB Function") + "</tbFunction>\n";
            s = s + "        </tbTransition>\n";
            s = s + "      </toolspecific>\n";
        }
        s = s + "    </transition>\n";
        return s;
    }

    private String generateArcs(IArc a) {
        String s = "    <arc id=\"" + a.getId() + "\" source=\"" + a.getStartingVertex().getId() + "\" target=\"" + a.getEndingVertex().getId() + "\">\n";
        if (a.getKnots().size() > 0) {
            s = s + "      <graphics>\n";
            for (int i = 0; i < a.getKnots().size(); ++i) {
                s = s + "        <position x=\"" + (int)a.getKnots().get(i)[0] + "\" y=\"" + (int)a.getKnots().get(i)[1] + "\" />\n";
            }
            s = s + "      </graphics>\n";
        }
        s = s + "      <toolspecific tool=\"PNtool\" version=\"2.1\">\n";
        s = s + "        <inscription>\n";
        s = s + "          <graphics>\n";
        s = s + "            <offset x=\"" + (int)a.getCountX() + "\" y=\"" + (int)a.getCountY() + "\" />\n";
        s = s + "          </graphics>\n";
        s = s + "          <text>" + a.getCount() + "</text>\n";
        s = s + "        </inscription>\n";
        if (a.getAdditionalData() instanceof Properties) {
            if (((Properties)a.getAdditionalData()).get("EvPN d") instanceof Boolean && ((Boolean)((Properties)a.getAdditionalData()).get("EvPN d")).booleanValue()) {
                s = s + "        <evpnArc type=\"d\" />\n";
            }
            if (((Properties)a.getAdditionalData()).get("EvPN w") instanceof Integer) {
                if ((Integer)((Properties)a.getAdditionalData()).get("EvPN w") == -1) {
                    s = s + "        <evpnArc type=\"omega\">\n";
                } else {
                    s = s + "        <evpnArc type=\"c\">\n";
                    s = s + "          <capacity>" + (Integer)((Properties)a.getAdditionalData()).get("EvPN w") + "</capacity>\n";
                }
                if (((Properties)a.getAdditionalData()).get("EvPN Function") instanceof String) {
                    s = s + "          <relPlace>" + (String)((Properties)a.getAdditionalData()).get("EvPN Function") + "</relPlace>\n";
                }
                s = s + "        </evpnArc>\n";
            }
        }
        s = s + "      </toolspecific>\n";
        s = s + "    </arc>\n";
        return s;
    }

    private String generateFooter() {
        return "</pnml>\n";
    }

    private String elementToString(Node node) {
        try {
            DOMSource source = new DOMSource(node);
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

