/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.util.ArrayList;
import javax.swing.JComponent;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pnexport.PNMLSaver;

public class ModuleImpl
implements IModule {
    private ArrayList<IPetriNet> petriNets = new ArrayList();
    private ArrayList<IResponseListener> responseListeners = new ArrayList();
    private PNMLSaver saver;
    private String dirPath = "";
    private String filePath = "";

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PN module that saves Petri Nets</h1>This module is hidden, but it is essential for PNTool2.1.<BR><BR>Author: Peter Antal</html>";
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNets.add(pn);
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
        String rgx1 = "set path ";
        String rgx2 = "set fname ";
        if (command.startsWith(rgx1)) {
            this.dirPath = command.substring(rgx1.length());
        }
        if (command.startsWith(rgx2)) {
            this.filePath = command.substring(rgx2.length());
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this.petriNets.size(); ++i) {
            String s = this.filePath;
            if (s.length() == 0) {
                s = this.dirPath + "/" + this.petriNets.get(i).getId() + ".pnml";
            }
            this.saver = new PNMLSaver(s);
            this.saver.save(this.petriNets);
        }
    }

    @Override
    public void close() {
        this.petriNets.clear();
    }

    @Override
    public String getName() {
        return "PNML Saver";
    }

    @Override
    public JComponent getControlPanel() {
        return null;
    }

    @Override
    public String getHTMLHelpSK() {
        return null;
    }

    @Override
    public String getHTMLHelpENG() {
        return null;
    }

    @Override
    public String getTarget() {
        return null;
    }

    @Override
    public String getName(String prefix) {
        return null;
    }
}

