/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.runtime;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class ProcAddressTable {
    public static final String PROCADDRESS_VAR_PREFIX = "_addressof_";
    protected static boolean DEBUG;
    protected static String DEBUG_PREFIX;
    protected static int debugNum;
    private final FunctionAddressResolver resolver;

    public ProcAddressTable() {
        this(new One2OneResolver());
    }

    public ProcAddressTable(FunctionAddressResolver resolver) {
        this.resolver = resolver;
    }

    public void reset(DynamicLookupHelper lookup) throws RuntimeException {
        if (null == lookup) {
            throw new RuntimeException("Passed null DynamicLookupHelper");
        }
        PrintStream dout = ProcAddressTable.getDebugOutStream();
        if (DEBUG) {
            dout.println(this.getClass().getName() + ".reset()");
        }
        Field[] fields = this.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            if (!this.isAddressField(fieldName)) continue;
            String funcName = this.fieldToFunctionName(fieldName);
            this.setEntry(fields[i], funcName, lookup);
        }
        if (DEBUG) {
            dout.flush();
            if (DEBUG_PREFIX != null) {
                dout.close();
            }
        }
    }

    public void initEntry(String name, DynamicLookupHelper lookup) {
        Field field = this.fieldForFunction(name);
        this.setEntry(field, name, lookup);
    }

    protected void setEntry(Field addressField, String funcName, DynamicLookupHelper lookup) {
        try {
            assert (addressField.getType() == Long.TYPE);
            long newProcAddress = this.resolver.resolve(funcName, lookup);
            addressField.setLong(this, newProcAddress);
            if (DEBUG) {
                ProcAddressTable.getDebugOutStream().println("  " + addressField.getName() + " -> 0x" + Long.toHexString(newProcAddress));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get proc address for method \"" + funcName + "\": Couldn't set value of field \"" + addressField, e);
        }
    }

    protected String fieldToFunctionName(String addressFieldName) {
        return addressFieldName.substring(PROCADDRESS_VAR_PREFIX.length());
    }

    protected Field fieldForFunction(String name) {
        try {
            return this.getClass().getField(PROCADDRESS_VAR_PREFIX + name);
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalArgumentException(this.getClass().getName() + " has no entry for the function '" + name + "'.", ex);
        }
    }

    protected boolean isAddressField(String fieldName) {
        return fieldName.startsWith(PROCADDRESS_VAR_PREFIX);
    }

    protected static PrintStream getDebugOutStream() {
        PrintStream out = null;
        if (DEBUG) {
            if (DEBUG_PREFIX != null) {
                try {
                    out = new PrintStream(new BufferedOutputStream(new FileOutputStream(DEBUG_PREFIX + File.separatorChar + "procaddresstable-" + ++debugNum + ".txt")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    out = System.err;
                }
            } else {
                out = System.err;
            }
        }
        return out;
    }

    public Map toMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Field[] fields = this.getClass().getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                String addressFieldName = fields[i].getName();
                if (!this.isAddressField(addressFieldName)) continue;
                map.put(this.fieldToFunctionName(addressFieldName), fields[i].get(this));
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        return map;
    }

    public boolean isFunctionAvailable(String functionName) {
        try {
            return this.getAddressFor(functionName) != 0L;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public long getAddressFor(String functionName) {
        Field addressField = this.fieldForFunction(functionName);
        try {
            return addressField.getLong(this);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Set getNullPointerFunctions() {
        Map table = this.toMap();
        LinkedHashSet nullPointers = new LinkedHashSet();
        for (Map.Entry entry : table.entrySet()) {
            long address = (Long)entry.getValue();
            if (address != 0L) continue;
            nullPointers.add(entry.getKey());
        }
        return nullPointers;
    }

    public String toString() {
        return this.getClass().getName() + "" + this.toMap();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = DEBUG = System.getProperty("jogamp.debug.ProcAddressHelper") != null;
                if (DEBUG) {
                    DEBUG_PREFIX = System.getProperty("jogamp.debug.ProcAddressHelper.prefix");
                }
                return null;
            }
        });
    }

    private static class One2OneResolver
    implements FunctionAddressResolver {
        private One2OneResolver() {
        }

        public long resolve(String name, DynamicLookupHelper lookup) {
            return lookup.dynamicLookupFunction(name);
        }
    }
}

