/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntObjectHashMap
implements Cloneable,
Iterable {
    private final float loadFactor;
    private Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;
    private Object keyNotFoundValue = null;
    private static final boolean isPrimitive;
    private static final Constructor entryConstructor;
    private static final Method equalsMethod;

    public IntObjectHashMap() {
        this(16, 0.75f);
    }

    public IntObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntObjectHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private IntObjectHashMap(float loadFactor, int table_size, int size, int mask, int capacity, int threshold, Object keyNotFoundValue) {
        this.loadFactor = loadFactor;
        this.table = new Entry[table_size];
        this.size = size;
        this.mask = mask;
        this.capacity = capacity;
        this.threshold = threshold;
        this.keyNotFoundValue = keyNotFoundValue;
    }

    public Object clone() {
        IntObjectHashMap n = new IntObjectHashMap(this.loadFactor, this.table.length, this.size, this.mask, this.capacity, this.threshold, this.keyNotFoundValue);
        for (int i = this.table.length - 1; i >= 0; --i) {
            ArrayList<Entry> entries = new ArrayList<Entry>();
            Entry se = this.table[i];
            while (null != se) {
                entries.add(se);
                se = se.next;
            }
            Entry de_next = null;
            for (int j = entries.size() - 1; j >= 0; --j) {
                se = (Entry)entries.get(j);
                if (isPrimitive) {
                    de_next = new Entry(se.key, se.value, de_next);
                    continue;
                }
                Object v = ReflectionUtil.callMethod(se.value, IntObjectHashMap.getCloneMethod(se.value), new Object[0]);
                de_next = (Entry)ReflectionUtil.createInstance(entryConstructor, se.key, v, de_next);
            }
            n.table[i] = de_next;
        }
        return n;
    }

    public boolean containsValue(Object value) {
        Entry[] t = this.table;
        int i = t.length;
        while (i-- > 0) {
            Entry e = t[i];
            while (e != null) {
                Boolean b;
                if (isPrimitive ? e.value == value : (b = (Boolean)ReflectionUtil.callMethod(value, equalsMethod, e.value)) != false) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        Entry[] t = this.table;
        int index = key & this.mask;
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(int key) {
        Entry[] t = this.table;
        int index = key & this.mask;
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return this.keyNotFoundValue;
    }

    public Object put(int key, Object value) {
        Entry[] t = this.table;
        int index = key & this.mask;
        Entry e = t[index];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        t[index] = new Entry(key, value, t[index]);
        if (this.size++ >= this.threshold) {
            int newCapacity = 2 * this.capacity;
            Entry[] newTable = new Entry[newCapacity];
            int bucketmask = newCapacity - 1;
            for (int j = 0; j < t.length; ++j) {
                Entry next;
                Entry e2 = t[j];
                if (e2 == null) continue;
                t[j] = null;
                do {
                    next = e2.next;
                    index = e2.key & bucketmask;
                    e2.next = newTable[index];
                    newTable[index] = e2;
                } while ((e2 = next) != null);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.mask = this.capacity - 1;
        }
        return this.keyNotFoundValue;
    }

    public void putAll(IntObjectHashMap source) {
        for (Entry e : source) {
            this.put(e.key, e.value);
        }
    }

    public Object remove(int key) {
        Entry prev;
        Entry[] t = this.table;
        int index = key & this.mask;
        Entry e = prev = t[index];
        while (e != null) {
            Entry next = e.next;
            if (e.key == key) {
                --this.size;
                if (prev == e) {
                    t[index] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return this.keyNotFoundValue;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
    }

    public Iterator<Entry> iterator() {
        return new EntryIterator(this.table);
    }

    public Object setKeyNotFoundValue(Object newKeyNotFoundValue) {
        Object t = this.keyNotFoundValue;
        this.keyNotFoundValue = newKeyNotFoundValue;
        return t;
    }

    public Object getKeyNotFoundValue() {
        return this.keyNotFoundValue;
    }

    public String toString() {
        String str = "{";
        Iterator<Entry> itr = this.iterator();
        while (itr.hasNext()) {
            str = str + itr.next();
            if (!itr.hasNext()) continue;
            str = str + ", ";
        }
        str = str + "}";
        return str;
    }

    private static Method getCloneMethod(Object obj) {
        Class<?> clazz = obj.getClass();
        Method m = null;
        try {
            m = clazz.getDeclaredMethod("clone", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new JogampRuntimeException("Class " + clazz + " doesn't support clone()", ex);
        }
        return m;
    }

    static {
        Class<Object> valueClazz = Object.class;
        Class<Integer> keyClazz = Integer.TYPE;
        isPrimitive = valueClazz.isPrimitive();
        Constructor c = null;
        Method m = null;
        if (!isPrimitive) {
            c = ReflectionUtil.getConstructor(Entry.class, keyClazz, valueClazz, Entry.class);
            try {
                m = valueClazz.getDeclaredMethod("equals", Object.class);
            }
            catch (NoSuchMethodException ex) {
                throw new JogampRuntimeException("Class " + valueClazz + " doesn't support equals(Object)");
            }
        }
        entryConstructor = c;
        equalsMethod = m;
    }

    public static final class Entry {
        public final int key;
        public Object value;
        private Entry next;

        Entry(int k, Object v, Entry n) {
            this.key = k;
            this.value = v;
            this.next = n;
        }

        public int getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public String toString() {
            return "[" + this.key + ":" + this.value + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntryIterator
    implements Iterator<Entry> {
        private final Entry[] entries;
        private int index;
        private Entry next;

        private EntryIterator(Entry[] entries) {
            this.entries = entries;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry next() {
            Entry current = this.next;
            if (current != null && current.next != null) {
                this.next = current.next;
            } else {
                while (this.index < this.entries.length) {
                    Entry e;
                    if ((e = this.entries[this.index++]) == null) continue;
                    this.next = e;
                    return current;
                }
                this.next = null;
            }
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

