/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.gluegen.runtime.NativeLibLoader;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Platform {
    public static final boolean JAVA_SE;
    public static final boolean LITTLE_ENDIAN;
    public static final String OS;
    public static final String OS_VERSION;
    public static final String ARCH;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VERSION;
    public static final String NEWLINE;
    private static final boolean is32Bit;
    private static final int pointerSizeInBits;

    private Platform() {
    }

    private static boolean initArch() throws RuntimeException {
        if (32 == pointerSizeInBits || 64 == pointerSizeInBits) {
            return 32 == pointerSizeInBits;
        }
        String os_lc = OS.toLowerCase();
        String arch_lc = ARCH.toLowerCase();
        if (os_lc.startsWith("windows") && arch_lc.equals("x86") || os_lc.startsWith("windows") && arch_lc.equals("arm") || os_lc.startsWith("linux") && arch_lc.equals("i386") || os_lc.startsWith("linux") && arch_lc.equals("x86") || os_lc.startsWith("mac os") && arch_lc.equals("ppc") || os_lc.startsWith("mac os") && arch_lc.equals("i386") || os_lc.startsWith("darwin") && arch_lc.equals("ppc") || os_lc.startsWith("darwin") && arch_lc.equals("i386") || os_lc.startsWith("sunos") && arch_lc.equals("sparc") || os_lc.startsWith("sunos") && arch_lc.equals("x86") || os_lc.startsWith("freebsd") && arch_lc.equals("i386") || os_lc.startsWith("hp-ux") && arch_lc.equals("pa_risc2.0")) {
            return true;
        }
        if (os_lc.startsWith("windows") && arch_lc.equals("amd64") || os_lc.startsWith("linux") && arch_lc.equals("amd64") || os_lc.startsWith("linux") && arch_lc.equals("x86_64") || os_lc.startsWith("linux") && arch_lc.equals("ia64") || os_lc.startsWith("mac os") && arch_lc.equals("x86_64") || os_lc.startsWith("darwin") && arch_lc.equals("x86_64") || os_lc.startsWith("sunos") && arch_lc.equals("sparcv9") || os_lc.startsWith("sunos") && arch_lc.equals("amd64")) {
            return false;
        }
        throw new RuntimeException("Please port CPU detection (32/64 bit) to your platform (" + os_lc + "/" + arch_lc + ")");
    }

    private static boolean initIsJavaSE() {
        String java_runtime_name = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.runtime.name");
            }
        });
        if (java_runtime_name.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean initByteOrder() {
        ByteBuffer tst_b = Buffers.newDirectByteBuffer(4);
        IntBuffer tst_i = tst_b.asIntBuffer();
        ShortBuffer tst_s = tst_b.asShortBuffer();
        tst_i.put(0, 168496141);
        return 3085 == tst_s.get(0);
    }

    private static native int getPointerSizeInBitsImpl();

    public static boolean isJavaSE() {
        return JAVA_SE;
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOS() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static String getArch() {
        return ARCH;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static boolean is32Bit() {
        return is32Bit;
    }

    public static boolean is64Bit() {
        return !is32Bit;
    }

    public static int getPointerSizeInBits() {
        return pointerSizeInBits;
    }

    public static int getPointerSizeInBytes() {
        return pointerSizeInBits / 8;
    }

    static {
        OS = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        ARCH = System.getProperty("os.arch");
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        NEWLINE = System.getProperty("line.separator");
        JAVA_SE = Platform.initIsJavaSE();
        LITTLE_ENDIAN = Platform.initByteOrder();
        boolean libsLoaded = true;
        try {
            NativeLibLoader.loadGlueGenRT();
        }
        catch (UnsatisfiedLinkError err) {
            libsLoaded = false;
        }
        pointerSizeInBits = libsLoaded ? Platform.getPointerSizeInBitsImpl() : -1;
        is32Bit = Platform.initArch();
    }
}

