/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.AbstractBuffer;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.gluegen.runtime.NativeLibLoader;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSizeBuffer
extends AbstractBuffer<NativeSizeBuffer> {
    protected NativeSizeBuffer(ByteBuffer bb) {
        super(bb, NativeSizeBuffer.elementSize());
    }

    public static NativeSizeBuffer allocate(int size) {
        return new NativeSizeBuffer(ByteBuffer.wrap(new byte[NativeSizeBuffer.elementSize() * size]));
    }

    public static NativeSizeBuffer allocate(long[] array) {
        return (NativeSizeBuffer)NativeSizeBuffer.allocate(array.length).put(array, 0, array.length).rewind();
    }

    public static NativeSizeBuffer allocateDirect(int size) {
        return new NativeSizeBuffer(Buffers.newDirectByteBuffer(NativeSizeBuffer.elementSize() * size));
    }

    public static NativeSizeBuffer allocateDirect(long[] array) {
        return (NativeSizeBuffer)NativeSizeBuffer.allocateDirect(array.length).put(array, 0, array.length).rewind();
    }

    public static NativeSizeBuffer wrap(ByteBuffer buffer) {
        return new NativeSizeBuffer(buffer);
    }

    public static int elementSize() {
        return Platform.is32Bit() ? 4 : 8;
    }

    @Override
    public NativeSizeBuffer put(int index, long value) {
        this.putImpl(index, value);
        return this;
    }

    private void putImpl(long value) {
        if (Platform.is32Bit()) {
            this.bb.putInt((int)value);
        } else {
            this.bb.putLong(value);
        }
    }

    private void putImpl(int index, long value) {
        if (Platform.is32Bit()) {
            this.bb.putInt(index * NativeSizeBuffer.elementSize(), (int)value);
        } else {
            this.bb.putLong(index * NativeSizeBuffer.elementSize(), value);
        }
    }

    @Override
    public NativeSizeBuffer put(NativeBuffer buffer) {
        if (this.remaining() < buffer.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (buffer.hasRemaining()) {
            this.put(buffer.get());
        }
        return this;
    }

    @Override
    public NativeSizeBuffer put(long value) {
        this.putImpl(value);
        return this;
    }

    public NativeSizeBuffer put(long[] src, int offset, int length) {
        if (src.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            this.putImpl(src[offset++]);
            --length;
        }
        return this;
    }

    @Override
    public long get() {
        return this.getImpl();
    }

    @Override
    public long get(int index) {
        return this.getImpl(index);
    }

    private long getImpl() {
        if (Platform.is32Bit()) {
            return this.bb.getInt();
        }
        return this.bb.getLong();
    }

    private long getImpl(int index) {
        if (Platform.is32Bit()) {
            return this.bb.getInt(index * NativeSizeBuffer.elementSize());
        }
        return this.bb.getLong(index * NativeSizeBuffer.elementSize());
    }

    public NativeSizeBuffer get(long[] dest, int offset, int length) {
        if (dest.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        while (length > 0) {
            dest[offset++] = this.getImpl();
            --length;
        }
        return this;
    }

    static {
        NativeLibLoader.loadGlueGenRT();
    }
}

