/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeSizeBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buffers {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int numElements) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(numElements));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] values, int offset, int lenght) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] values, int offset) {
        return Buffers.newDirectByteBuffer(values, offset, values.length - offset);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] values) {
        return Buffers.newDirectByteBuffer(values, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] values, int offset, int lenght) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] values, int offset) {
        return Buffers.newDirectDoubleBuffer(values, offset, values.length - offset);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] values) {
        return Buffers.newDirectDoubleBuffer(values, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] values, int offset, int lenght) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] values, int offset) {
        return Buffers.newDirectFloatBuffer(values, offset, values.length - offset);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] values) {
        return Buffers.newDirectFloatBuffer(values, 0);
    }

    public static IntBuffer newDirectIntBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] values, int offset, int lenght) {
        return (IntBuffer)Buffers.newDirectIntBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] values, int offset) {
        return Buffers.newDirectIntBuffer(values, offset, values.length - offset);
    }

    public static IntBuffer newDirectIntBuffer(int[] values) {
        return Buffers.newDirectIntBuffer(values, 0);
    }

    public static LongBuffer newDirectLongBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] values, int offset, int lenght) {
        return (LongBuffer)Buffers.newDirectLongBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] values, int offset) {
        return Buffers.newDirectLongBuffer(values, offset, values.length - offset);
    }

    public static LongBuffer newDirectLongBuffer(long[] values) {
        return Buffers.newDirectLongBuffer(values, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] values, int offset, int lenght) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] values, int offset) {
        return Buffers.newDirectShortBuffer(values, offset, values.length - offset);
    }

    public static ShortBuffer newDirectShortBuffer(short[] values) {
        return Buffers.newDirectShortBuffer(values, 0);
    }

    public static CharBuffer newDirectCharBuffer(int numElements) {
        return Buffers.newDirectByteBuffer(numElements * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] values, int offset, int lenght) {
        return (CharBuffer)Buffers.newDirectCharBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] values, int offset) {
        return Buffers.newDirectCharBuffer(values, offset, values.length - offset);
    }

    public static CharBuffer newDirectCharBuffer(char[] values) {
        return Buffers.newDirectCharBuffer(values, 0);
    }

    public static <B extends Buffer> B slice(B buffer) {
        if (buffer instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)buffer;
            return (B)bb.slice().order(bb.order());
        }
        if (buffer instanceof IntBuffer) {
            return (B)((IntBuffer)buffer).slice();
        }
        if (buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)buffer).slice();
        }
        if (buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)buffer).slice();
        }
        if (buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)buffer).slice();
        }
        if (buffer instanceof LongBuffer) {
            return (B)((LongBuffer)buffer).slice();
        }
        if (buffer instanceof CharBuffer) {
            return (B)((CharBuffer)buffer).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + buffer.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B buffer, int offset, int size) {
        int pos = buffer.position();
        int limit = buffer.limit();
        B slice = null;
        try {
            buffer.position(offset).limit(offset + size);
            slice = Buffers.slice(buffer);
        }
        finally {
            buffer.position(pos).limit(limit);
        }
        return slice;
    }

    public static ByteBuffer nativeOrder(ByteBuffer buf) {
        return buf.order(ByteOrder.nativeOrder());
    }

    public static int sizeOfBufferElem(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return 1;
        }
        if (buffer instanceof IntBuffer) {
            return 4;
        }
        if (buffer instanceof ShortBuffer) {
            return 2;
        }
        if (buffer instanceof FloatBuffer) {
            return 4;
        }
        if (buffer instanceof DoubleBuffer) {
            return 8;
        }
        if (buffer instanceof LongBuffer) {
            return 8;
        }
        if (buffer instanceof CharBuffer) {
            return 2;
        }
        throw new RuntimeException("Unexpected buffer type " + buffer.getClass().getName());
    }

    public static boolean isDirect(Object buf) {
        if (buf == null) {
            return true;
        }
        if (buf instanceof Buffer) {
            return ((Buffer)buf).isDirect();
        }
        if (buf instanceof NativeSizeBuffer) {
            return ((NativeSizeBuffer)buf).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + buf.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return pos;
            }
            if (buf instanceof FloatBuffer) {
                return pos * 4;
            }
            if (buf instanceof IntBuffer) {
                return pos * 4;
            }
            if (buf instanceof ShortBuffer) {
                return pos * 2;
            }
            if (buf instanceof DoubleBuffer) {
                return pos * 8;
            }
            if (buf instanceof LongBuffer) {
                return pos * 8;
            }
            if (buf instanceof CharBuffer) {
                return pos * 2;
            }
        } else if (buf instanceof NativeSizeBuffer) {
            NativeSizeBuffer nsbuffer = (NativeSizeBuffer)buf;
            return nsbuffer.position() * NativeSizeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static Object getArray(Object buf) {
        if (buf == null) {
            return null;
        }
        if (buf instanceof Buffer) {
            return ((Buffer)buf).array();
        }
        if (buf instanceof NativeSizeBuffer) {
            return ((NativeSizeBuffer)buf).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + buf.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object buf) {
        if (buf == null) {
            return 0;
        }
        if (buf instanceof Buffer) {
            int pos = ((Buffer)buf).position();
            if (buf instanceof ByteBuffer) {
                return ((ByteBuffer)buf).arrayOffset() + pos;
            }
            if (buf instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof IntBuffer) {
                return 4 * (((IntBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof LongBuffer) {
                return 8 * (((LongBuffer)buf).arrayOffset() + pos);
            }
            if (buf instanceof CharBuffer) {
                return 2 * (((CharBuffer)buf).arrayOffset() + pos);
            }
        } else if (buf instanceof NativeSizeBuffer) {
            NativeSizeBuffer nsbuffer = (NativeSizeBuffer)buf;
            return NativeSizeBuffer.elementSize() * (nsbuffer.arrayOffset() + nsbuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + buf.getClass().getName());
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer orig) {
        ByteBuffer dest = Buffers.newDirectByteBuffer(orig.remaining());
        dest.put(orig);
        dest.rewind();
        return dest;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer orig) {
        return Buffers.copyFloatBufferAsByteBuffer(orig).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer orig) {
        return Buffers.copyIntBufferAsByteBuffer(orig).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer orig) {
        return Buffers.copyShortBufferAsByteBuffer(orig).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer orig) {
        ByteBuffer dest = Buffers.newDirectByteBuffer(orig.remaining() * 4);
        dest.asFloatBuffer().put(orig);
        dest.rewind();
        return dest;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer orig) {
        ByteBuffer dest = Buffers.newDirectByteBuffer(orig.remaining() * 4);
        dest.asIntBuffer().put(orig);
        dest.rewind();
        return dest;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer orig) {
        ByteBuffer dest = Buffers.newDirectByteBuffer(orig.remaining() * 2);
        dest.asShortBuffer().put(orig);
        dest.rewind();
        return dest;
    }

    public static float[] getFloatArray(double[] source, int soffset, float[] dest, int doffset, int len) {
        if (0 > len) {
            len = source.length - soffset;
        }
        if (len > source.length - soffset) {
            throw new IllegalArgumentException("payload (" + len + ") greater than remaining source bytes [len " + source.length + ", offset " + soffset + "]");
        }
        if (null == dest) {
            dest = new float[len];
            doffset = 0;
        }
        if (len > dest.length - doffset) {
            throw new IllegalArgumentException("payload (" + len + ") greater than remaining dest bytes [len " + dest.length + ", offset " + doffset + "]");
        }
        for (int i = 0; i < len; ++i) {
            dest[doffset + i] = (float)source[soffset + i];
        }
        return dest;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer source, FloatBuffer dest) {
        if (null == dest) {
            dest = Buffers.newDirectFloatBuffer(source.remaining());
        }
        if (dest.remaining() < source.remaining()) {
            throw new IllegalArgumentException("payload (" + source.remaining() + ") is greater than remaining dest bytes: " + dest.remaining());
        }
        while (source.hasRemaining()) {
            dest.put((float)source.get());
        }
        return dest;
    }

    public static double[] getDoubleArray(float[] source, int soffset, double[] dest, int doffset, int len) {
        if (0 > len) {
            len = source.length - soffset;
        }
        if (len > source.length - soffset) {
            throw new IllegalArgumentException("payload (" + len + ") greater than remaining source bytes [len " + source.length + ", offset " + soffset + "]");
        }
        if (null == dest) {
            dest = new double[len];
            doffset = 0;
        }
        if (len > dest.length - doffset) {
            throw new IllegalArgumentException("payload (" + len + ") greater than remaining dest bytes [len " + dest.length + ", offset " + doffset + "]");
        }
        for (int i = 0; i < len; ++i) {
            dest[doffset + i] = source[soffset + i];
        }
        return dest;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer source, DoubleBuffer dest) {
        if (null == dest) {
            dest = Buffers.newDirectDoubleBuffer(source.remaining());
        }
        if (dest.remaining() < source.remaining()) {
            throw new IllegalArgumentException("payload (" + source.remaining() + ") is greater than remaining dest bytes: " + dest.remaining());
        }
        while (source.hasRemaining()) {
            dest.put(source.get());
        }
        return dest;
    }

    public static <B extends Buffer> B put(B dest, Buffer src) {
        if (dest instanceof ByteBuffer && src instanceof ByteBuffer) {
            return (B)((ByteBuffer)dest).put((ByteBuffer)src);
        }
        if (dest instanceof ShortBuffer && src instanceof ShortBuffer) {
            return (B)((ShortBuffer)dest).put((ShortBuffer)src);
        }
        if (dest instanceof IntBuffer && src instanceof IntBuffer) {
            return (B)((IntBuffer)dest).put((IntBuffer)src);
        }
        if (dest instanceof FloatBuffer && src instanceof FloatBuffer) {
            return (B)((FloatBuffer)dest).put((FloatBuffer)src);
        }
        if (dest instanceof LongBuffer && src instanceof LongBuffer) {
            return (B)((LongBuffer)dest).put((LongBuffer)src);
        }
        if (dest instanceof DoubleBuffer && src instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)dest).put((DoubleBuffer)src);
        }
        if (dest instanceof CharBuffer && src instanceof CharBuffer) {
            return (B)((CharBuffer)dest).put((CharBuffer)src);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + dest.getClass().getName() + ", src = " + src.getClass().getName());
    }

    public static <B extends Buffer> B putb(B dest, byte v) {
        if (dest instanceof ByteBuffer) {
            return (B)((ByteBuffer)dest).put(v);
        }
        if (dest instanceof ShortBuffer) {
            return (B)((ShortBuffer)dest).put(v);
        }
        if (dest instanceof IntBuffer) {
            return (B)((IntBuffer)dest).put(v);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + dest);
    }

    public static <B extends Buffer> B puts(B dest, short v) {
        if (dest instanceof ShortBuffer) {
            return (B)((ShortBuffer)dest).put(v);
        }
        if (dest instanceof IntBuffer) {
            return (B)((IntBuffer)dest).put(v);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + dest);
    }

    public static <B extends Buffer> B puti(B dest, int v) {
        if (dest instanceof IntBuffer) {
            return (B)((IntBuffer)dest).put(v);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + dest);
    }

    public static <B extends Buffer> B putf(B dest, float v) {
        if (dest instanceof FloatBuffer) {
            return (B)((FloatBuffer)dest).put(v);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + dest);
    }

    public static <B extends Buffer> B putd(B dest, double v) {
        if (dest instanceof FloatBuffer) {
            return (B)((FloatBuffer)dest).put((float)v);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + dest);
    }

    public static void rangeCheck(byte[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(char[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(short[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(int[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(long[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(float[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(double[] array, int offset, int minElementsRemaining) {
        if (array == null) {
            return;
        }
        if (array.length < offset + minElementsRemaining) {
            throw new ArrayIndexOutOfBoundsException("Required " + minElementsRemaining + " elements in array, only had " + (array.length - offset));
        }
    }

    public static void rangeCheck(Buffer buffer, int minElementsRemaining) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < minElementsRemaining) {
            throw new IndexOutOfBoundsException("Required " + minElementsRemaining + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object buffer, int minBytesRemaining) {
        if (buffer == null) {
            return;
        }
        int bytesRemaining = 0;
        if (buffer instanceof Buffer) {
            int elementsRemaining = ((Buffer)buffer).remaining();
            if (buffer instanceof ByteBuffer) {
                bytesRemaining = elementsRemaining;
            } else if (buffer instanceof FloatBuffer) {
                bytesRemaining = elementsRemaining * 4;
            } else if (buffer instanceof IntBuffer) {
                bytesRemaining = elementsRemaining * 4;
            } else if (buffer instanceof ShortBuffer) {
                bytesRemaining = elementsRemaining * 2;
            } else if (buffer instanceof DoubleBuffer) {
                bytesRemaining = elementsRemaining * 8;
            } else if (buffer instanceof LongBuffer) {
                bytesRemaining = elementsRemaining * 8;
            } else if (buffer instanceof CharBuffer) {
                bytesRemaining = elementsRemaining * 2;
            }
        } else if (buffer instanceof NativeSizeBuffer) {
            NativeSizeBuffer nsbuffer = (NativeSizeBuffer)buffer;
            bytesRemaining = nsbuffer.remaining() * NativeSizeBuffer.elementSize();
        }
        if (bytesRemaining < minBytesRemaining) {
            throw new IndexOutOfBoundsException("Required " + minBytesRemaining + " remaining bytes in buffer, only had " + bytesRemaining);
        }
    }
}

