/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import jogamp.common.Debug;

public class JNILibLoaderBase {
    public static final boolean DEBUG = Debug.debug("JNILibLoader");
    private static final Set<String> loaded = new HashSet<String>();
    private static LoaderAction loaderAction = new DefaultAction();

    public static boolean isLoaded(String libName) {
        return loaded.contains(libName);
    }

    public static void addLoaded(String libName) {
        loaded.add(libName);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase Loaded Native Library: " + libName);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction action) {
        loaderAction = action;
    }

    protected static synchronized boolean loadLibrary(String libname, boolean ignoreError) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(libname, ignoreError);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String libname, String[] preload, boolean preloadIgnoreError) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(libname, preload, preloadIgnoreError);
        }
    }

    private static class DefaultAction
    implements LoaderAction {
        private static final Method customLoadLibraryMethod;
        private static final AccessControlContext localACC;
        private static final String osAndArch;
        private static final String ext;
        private static final String prefix;

        private DefaultAction() {
        }

        public boolean loadLibrary(String libname, boolean ignoreError) {
            boolean res;
            block5: {
                res = true;
                if (!JNILibLoaderBase.isLoaded(libname)) {
                    try {
                        this.loadLibraryImpl(libname);
                        JNILibLoaderBase.addLoaded(libname);
                        if (DEBUG) {
                            System.err.println(this.getClass() + " loaded " + libname);
                        }
                    }
                    catch (UnsatisfiedLinkError e) {
                        res = false;
                        if (DEBUG) {
                            e.printStackTrace();
                        }
                        if (ignoreError || e.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw e;
                    }
                }
            }
            return res;
        }

        public void loadLibrary(String libname, String[] preload, boolean preloadIgnoreError) {
            if (!JNILibLoaderBase.isLoaded(libname)) {
                if (null != preload) {
                    for (int i = 0; i < preload.length; ++i) {
                        this.loadLibrary(preload[i], preloadIgnoreError);
                    }
                }
                this.loadLibrary(libname, false);
            }
        }

        private void loadLibraryImpl(String libraryName) {
            if (null != customLoadLibraryMethod && !libraryName.equals("jawt")) {
                this.loadCustom(libraryName);
            } else {
                try {
                    if (this.loadFromClasspath(libraryName)) {
                        return;
                    }
                }
                catch (IOException ex) {
                    throw new RuntimeException("can not load " + libraryName + " from classpath", ex);
                }
                this.loadFromLibpath(libraryName);
            }
        }

        private void loadCustom(String libraryName) {
            try {
                customLoadLibraryMethod.invoke(null, libraryName);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + libraryName).initCause(e);
            }
        }

        private void loadFromLibpath(String libraryName) {
            System.loadLibrary(libraryName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loadFromClasspath(String libraryName) throws IOException {
            String path = '/' + osAndArch + '/' + prefix + libraryName + '.' + ext;
            InputStream in = this.getClass().getResourceAsStream(path);
            if (in != null) {
                File copy = File.createTempFile(prefix + libraryName, '.' + ext);
                copy.deleteOnExit();
                FileOutputStream out = null;
                try {
                    int read;
                    out = new FileOutputStream(copy);
                    byte[] buffer = new byte[8192];
                    while ((read = in.read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, read);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    finally {
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                    }
                }
                System.load(copy.getPath());
                return true;
            }
            return false;
        }

        static {
            String launcherClassName;
            localACC = AccessController.getContext();
            Method loadLibraryMethod = null;
            Class<?> launcherClass = null;
            if (Debug.getBooleanProperty("sun.jnlp.applet.launcher", false, localACC)) {
                try {
                    launcherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    loadLibraryMethod = launcherClass.getDeclaredMethod("loadLibrary", String.class);
                }
                catch (ClassNotFoundException ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                    launcherClass = null;
                }
            }
            if (null == launcherClass && null != (launcherClassName = Debug.getProperty("jnlp.launcher.class", false, localACC))) {
                try {
                    launcherClass = Class.forName(launcherClassName);
                    loadLibraryMethod = launcherClass.getDeclaredMethod("loadLibrary", String.class);
                }
                catch (ClassNotFoundException ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (DEBUG) {
                        ex.printStackTrace();
                    }
                    launcherClass = null;
                }
            }
            customLoadLibraryMethod = loadLibraryMethod;
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("windows")) {
                os = "windows";
                ext = "dll";
                prefix = "";
            } else if (os.contains("mac os")) {
                os = "macosx";
                ext = "jnilib";
                prefix = "lib";
            } else {
                os = "linux";
                ext = "so";
                prefix = "lib";
            }
            String arch = System.getProperty("os.arch").toLowerCase();
            arch = os.equals("macosx") ? "universal" : (arch.contains("64") ? "amd64" : "i586");
            osAndArch = os + "-" + arch;
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2);

        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

