/*
 * Decompiled with CFR 0.152.
 */
package pn.export;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;

public class CPNSaver {
    private static final String KEY_PROPCOLOR = "Color";
    private static final double DEFAULT_PNTOOL_CANVAS_WIDTH = 770.0;
    private static final double DEFAULT_PNTOOL_CANVAS_HEIGHT = 480.0;
    private IPetriNet petriNet;

    public CPNSaver(IPetriNet petriNet) {
        this.petriNet = petriNet;
    }

    public void save(String filePath) throws FileNotFoundException, IOException {
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(filePath));
        String s = this.generateHeader();
        s = s + this.generateNet(this.petriNet);
        for (IPlace place : this.petriNet.getPlaces()) {
            s = s + this.generatePlace(place);
        }
        for (ITransition transition : this.petriNet.getTransitions()) {
            s = s + this.generateTransition(transition);
        }
        for (IArc arc : this.petriNet.getArcs()) {
            s = s + this.generateArc(arc);
        }
        s = s + this.generateFooter();
        dos.writeBytes(s);
        dos.close();
    }

    private String generateHeader() {
        return "<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<!DOCTYPE workspaceElements PUBLIC \"-//CPN//DTD CPNXML 1.0//EN\" \"http://cpntools.org/DTD/6/cpn.dtd\">\n\n<workspaceElements>\n<generator tool=\"CPN Tools\"\n           version=\"3.2.2\"\n           format=\"6\"/>\n";
    }

    private String generateNet(IPetriNet net) {
        return "<cpnet>\n  <globbox>\n    <block id=\"ID1412310166\">\n      <id>Standard priorities</id>\n      <ml id=\"ID1412310255\">val P_HIGH = 100;\n        <layout>val P_HIGH = 100;</layout>\n      </ml>\n      <ml id=\"ID1412310292\">val P_NORMAL = 1000;\n        <layout>val P_NORMAL = 1000;</layout>\n      </ml>\n      <ml id=\"ID1412310322\">val P_LOW = 10000;\n        <layout>val P_LOW = 10000;</layout>\n      </ml>\n    </block>\n    <block id=\"ID1\">\n      <id>Standard declarations</id>\n      <color id=\"ID85042\">\n        <id>UNIT</id>\n        <unit/>\n        <layout>colset UNIT = unit;</layout>\n      </color>\n      <color id=\"ID3\">\n        <id>INT</id>\n        <int/>\n      </color>\n      <color id=\"ID4\">\n        <id>BOOL</id>\n        <bool/>\n      </color>\n      <color id=\"ID5\">\n        <id>STRING</id>\n        <string/>\n      </color>\n    </block>\n  </globbox>\n    <page id=\"" + net.getId() + "\">\n" + "     <pageattr name=\"" + net.getName() + "\"/>\n";
    }

    private String generatePlace(IPlace p) {
        double placePosX = this.computeXcoordinate(p.getX());
        double placePosY = this.computeYcoordinate(p.getY());
        double markingPosX = placePosX;
        double markingPosY = placePosY + 25.0;
        String color = this.chooseColor((Color)((Properties)p.getAdditionalData()).get(KEY_PROPCOLOR));
        String tokens = p.getTokens() == 0 ? "/>" : ">" + p.getTokens() + "`()</text>";
        return "  <place id=\"" + p.getId() + "\">\n" + "    <posattr x=\"" + placePosX + "\"\n" + "             y=\"" + placePosY + "\"/>\n" + "    <fillattr colour=\"" + color + "\"\n" + "              pattern=\"\"\n" + "              filled=\"false\"/>\n" + "    <lineattr colour=\"Black\"\n" + "              thick=\"1\"\n" + "              type=\"Solid\"/>\n" + "    <textattr colour=\"Black\"\n" + "              bold=\"false\"/>\n" + "    <text>" + p.getName() + "</text>\n" + "    <ellipse w=\"60\"\n" + "             h=\"40\"/>\n" + "    <token x=\"-10.000000\"\n" + "           y=\"0.000000\"/>\n" + "    <marking x=\"0.000000\"\n" + "             y=\"0.000000\"\n" + "             hidden=\"false\">\n" + "    <snap snap_id=\"0\"\n" + "          anchor.horizontal=\"0\"\n" + "          anchor.vertical=\"0\"/>\n" + "    </marking>\n" + "    <type id=\"" + "T_" + p.getId() + "\">\n" + "          <posattr x=\"-66.000000\"\n" + "                   y=\"119.000000\"/>\n" + "          <fillattr colour=\"White\"\n" + "                    pattern=\"Solid\"\n" + "                    filled=\"false\"/>\n" + "          <lineattr colour=\"Black\"\n" + "                    thick=\"0\"\n" + "                    type=\"Solid\"/>\n" + "          <textattr colour=\"Black\"\n" + "                    bold=\"false\"/>\n" + "          <text tool=\"CPN Tools\"\n" + "                version=\"3.2.2\"/>\n" + "    </type>\n" + "    <initmark id=\"" + "I_" + p.getId() + "\">\n" + "     <posattr x=\"" + markingPosX + "\"\n" + "              y=\"" + markingPosY + "\"/>\n" + "     <fillattr colour=\"White\"\n" + "               pattern=\"Solid\"\n" + "               filled=\"false\"/>\n" + "     <lineattr colour=\"Black\"\n" + "               thick=\"0\"\n" + "               type=\"Solid\"/>\n" + "     <textattr colour=\"Black\"\n" + "               bold=\"false\"/>\n" + "     <text tool=\"CPN Tools\"\n" + "           version=\"3.2.2\"" + tokens + "\n" + "    </initmark>\n" + "    </place>\n";
    }

    private String generateTransition(ITransition t) {
        String color = this.chooseColor((Color)((Properties)t.getAdditionalData()).get(KEY_PROPCOLOR));
        return "      <trans id=\"" + t.getId() + "\"\n" + "             explicit=\"false\">\n" + "        <posattr x=\"" + this.computeXcoordinate(t.getX()) + "\"\n" + "                 y=\"" + this.computeYcoordinate(t.getY()) + "\"/>\n" + "        <fillattr colour=\"" + color + "\"\n" + "                  pattern=\"\"\n" + "                  filled=\"false\"/>\n" + "        <lineattr colour=\"Black\"\n" + "                  thick=\"1\"\n" + "                  type=\"solid\"/>\n" + "        <textattr colour=\"Black\"\n" + "                  bold=\"false\"/>\n" + "        <text>" + t.getName() + "</text>\n" + "        <box w=\"60.000000\"\n" + "             h=\"40.000000\"/>\n" + "        <binding x=\"7.200000\"\n" + "                 y=\"-3.000000\"/>\n" + "      </trans>\n";
    }

    private String generateArc(IArc a) {
        String orientation = "";
        String transID = "";
        String placeID = "";
        if (a.getStartingVertex() instanceof IPlace) {
            orientation = "PtoT";
            transID = a.getEndingVertex().getId();
            placeID = a.getStartingVertex().getId();
        } else if (a.getStartingVertex() instanceof ITransition) {
            orientation = "TtoP";
            transID = a.getStartingVertex().getId();
            placeID = a.getEndingVertex().getId();
        }
        return "      <arc id=\"" + a.getId() + "\"\n" + "           orientation=\"" + orientation + "\"\n" + "           order=\"1\">\n" + "        <posattr x=\"0.000000\"\n" + "                 y=\"0.000000\"/>\n" + "        <fillattr colour=\"White\"\n" + "                  pattern=\"\"\n" + "                  filled=\"false\"/>\n" + "        <lineattr colour=\"Black\"\n" + "                  thick=\"1\"\n" + "                  type=\"Solid\"/>\n" + "        <textattr colour=\"Black\"\n" + "                  bold=\"false\"/>\n" + "        <arrowattr headsize=\"1.200000\"\n" + "                   currentcyckle=\"2\"/>\n" + "        <transend idref=\"" + transID + "\"/>\n" + "        <placeend idref=\"" + placeID + "\"/>\n" + this.generateArcBendPoints(a) + "        <annot id=\"" + "A_" + a.getId() + "\">\n" + "          <posattr x=\"" + this.computeXcoordinate(a.getCountX()) + "\"\n" + "                   y=\"" + this.computeYcoordinate(a.getCountY()) + "\"/>\n" + "          <fillattr colour=\"White\"\n" + "                    pattern=\"Solid\"\n" + "                    filled=\"false\"/>\n" + "          <lineattr colour=\"Black\"\n" + "                    thick=\"0\"\n" + "                    type=\"Solid\"/>\n" + "          <textattr colour=\"Black\"\n" + "                    bold=\"false\"/>\n" + "          <text tool=\"CPN Tools\"\n" + "                version=\"3.2.2\">" + a.getCount() + "</text>\n" + "        </annot>\n" + "      </arc>\n";
    }

    private String generateFooter() {
        return "  </page>\n  <instances>\n   <instance id=\"ID2149\"\n             page=\"" + this.petriNet.getId() + "\"/>\n" + "    </instances>\n" + "    <options>\n" + "      <option name=\"outputdirectory\">\n" + "        <value>\n" + "          <text>&lt;same as model&gt;</text>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"realtimestamp\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repavg\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repciavg\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repcount\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repfirstval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"replastval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repmax\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repmin\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repssquare\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repssqdev\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repstddev\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repsum\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"repvariance\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"avg\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"ciavg\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"count\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"firstval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"lastval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"max\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"min\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"ssquare\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"ssqdev\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"stddev\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"sum\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"variance\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"firstupdate\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"interval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"lastupdate\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedavg\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedciavg\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedcount\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedfirstval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedlastval\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedmax\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedmin\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedssquare\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedssqdev\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedstddev\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedsum\">\n" + "        <value>\n" + "          <boolean>true</boolean>\n" + "        </value>\n" + "      </option>\n" + "      <option name=\"untimedvariance\">\n" + "        <value>\n" + "          <boolean>false</boolean>\n" + "        </value>\n" + "      </option>\n" + "    </options>\n" + "    <binders>\n" + "      <cpnbinder id=\"ID2222\"\n" + "                 x=\"257\"\n" + "                 y=\"122\"\n" + "                 width=\"600\"\n" + "                 height=\"400\">\n" + "        <sheets>\n" + "          <cpnsheet id=\"ID2215\"\n" + "                    panx=\"5.000000\"\n" + "                    pany=\"-7.000000\"\n" + "                    zoom=\"1.000000\"\n" + "                    instance=\"ID2149\">\n" + "            <zorder>\n" + "              <position value=\"0\"/>\n" + "            </zorder>\n" + "          </cpnsheet>\n" + "        </sheets>\n" + "        <zorder>\n" + "          <position value=\"0\"/>\n" + "        </zorder>\n" + "      </cpnbinder>\n" + "    </binders>\n" + "    <monitorblock name=\"Monitors\"/>\n" + "    <IndexNode expanded=\"true\">\n" + "      <IndexNode expanded=\"false\"/>\n" + "      <IndexNode expanded=\"false\"/>\n" + "      <IndexNode expanded=\"false\">\n" + "        <IndexNode expanded=\"false\"/>\n" + "        <IndexNode expanded=\"false\"/>\n" + "        <IndexNode expanded=\"false\">\n" + "          <IndexNode expanded=\"false\">\n" + "            <IndexNode expanded=\"false\">\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "            </IndexNode>\n" + "            <IndexNode expanded=\"false\">\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "              <IndexNode expanded=\"false\"/>\n" + "            </IndexNode>\n" + "          </IndexNode>\n" + "          <IndexNode expanded=\"false\">\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "            <IndexNode expanded=\"false\"/>\n" + "          </IndexNode>\n" + "        </IndexNode>\n" + "      </IndexNode>\n" + "      <IndexNode expanded=\"false\"/>\n" + "      <IndexNode expanded=\"true\">\n" + "        <IndexNode expanded=\"false\">\n" + "          <IndexNode expanded=\"true\"/>\n" + "          <IndexNode expanded=\"true\"/>\n" + "          <IndexNode expanded=\"true\"/>\n" + "        </IndexNode>\n" + "        <IndexNode expanded=\"false\">\n" + "          <IndexNode expanded=\"false\"/>\n" + "          <IndexNode expanded=\"false\"/>\n" + "          <IndexNode expanded=\"false\"/>\n" + "          <IndexNode expanded=\"false\"/>\n" + "        </IndexNode>\n" + "      </IndexNode>\n" + "      <IndexNode expanded=\"false\"/>\n" + "      <IndexNode expanded=\"true\"/>\n" + "    </IndexNode>\n" + " </cpnet>\n" + "</workspaceElements>";
    }

    private String generateArcBendPoints(IArc a) {
        String bendPointElement = "";
        Iterator<double[]> iterator = a.getKnots().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            double[] coordinates = iterator.next();
            bendPointElement = bendPointElement + "        <bendpoint id=\"B_" + ++i + "_" + a.getId() + "\"\n" + "                   serial=\"" + i + "\">\n" + "          <posattr x=\"" + this.computeXcoordinate(coordinates[0]) + "\"\n" + "                   y=\"" + this.computeYcoordinate(coordinates[1]) + "\"/>\n" + "          <fillattr colour=\"White\"\n" + "                    pattern=\"Solid\"\n" + "                    filled=\"false\"/>\n" + "          <lineattr colour=\"Black\"\n" + "                    thick=\"0\"\n" + "                    type=\"Solid\"/>\n" + "          <textattr colour=\"Black\"\n" + "                    bold=\"false\"/>\n" + "        </bendpoint>\n";
        }
        return bendPointElement;
    }

    private double computeXcoordinate(double x) {
        return Math.round(x - 385.0 + 50.0);
    }

    private double computeYcoordinate(double y) {
        return Math.round(240.0 - y - 50.0);
    }

    private String chooseColor(Color color) {
        int[] colorComponents = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        String[] colorNames = new String[]{"Black", "Silver", "Gray", "White", "Maroon", "Red", "Purple", "Fuchsia", "Green", "Lime", "Olive", "Yellow", "Navy", "Blue", "Teal", "Aqua"};
        int[][] colorCodes = new int[][]{{0, 0, 0}, {192, 192, 192}, {128, 128, 128}, {255, 255, 255}, {128, 0, 0}, {255, 0, 0}, {128, 0, 128}, {255, 0, 255}, {0, 128, 0}, {0, 255, 0}, {128, 128, 0}, {255, 255, 0}, {0, 0, 128}, {0, 0, 255}, {0, 128, 128}, {0, 255, 255}};
        int resultIndex = 3;
        int lowestSum = Integer.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            int sum = 0;
            for (int j = 0; j < 3; ++j) {
                sum = (int)((double)sum + Math.pow(colorComponents[j] - colorCodes[i][j], 2.0));
            }
            if (sum >= lowestSum) continue;
            lowestSum = sum;
            resultIndex = i;
        }
        return colorNames[resultIndex];
    }
}

