/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pn.export.CPNFilter;
import pn.export.CPNSaver;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;

public class ModuleImpl
extends JPanel
implements IModule {
    private IPetriNet petriNet;
    private ArrayList<IResponseListener> responseListeners;
    private CPNSaver saver;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
        this.responseListeners = new ArrayList();
    }

    public String getHTMLDescription() {
        return "<html><h1>Module for saving Petri net in CPN format</h1>Author: Martin Hajduk</html>";
    }

    public String getHTMLHelpSK() {
        return "";
    }

    public String getHTMLHelpENG() {
        return "";
    }

    public String getTarget() {
        return "pnCPNexport";
    }

    public void addPetriNet(IPetriNet pn) {
        this.petriNet = pn;
    }

    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    public void executeCommand(String command) {
    }

    public void open() {
        if (!this.petriNet.getType().equals("GPN")) {
            JOptionPane.showMessageDialog(null, "Only general Petri nets (GPN) can be completely exported.\nYou may continue but non-GPN information will not be saved.", "Warning!", 2);
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new CPNFilter());
        fc.setCurrentDirectory(new File("./"));
        fc.setSelectedFile(new File(this.petriNet.getName() + ".cpn"));
        int a = fc.showSaveDialog(null);
        if (a == 0) {
            String filePath = fc.getSelectedFile().getAbsolutePath();
            int i = filePath.lastIndexOf(46);
            if (i > -1 && i < filePath.length()) {
                if (!filePath.substring(i + 1).equals("cpn")) {
                    filePath = filePath + ".cpn";
                }
            } else {
                filePath = filePath + ".cpn";
            }
            this.saver = new CPNSaver(this.petriNet);
            try {
                this.saver.save(filePath);
                JOptionPane.showMessageDialog(null, "Petri net has been exported successfully.", this.getName(), 1);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(ModuleImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ModuleImpl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void close() {
        this.petriNet = null;
    }

    public String getName() {
        return "CPN Saver";
    }

    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Export do CPN";
        }
        if (prefix.equals("_eng")) {
            languageName = "Export to CPN";
        }
        return languageName;
    }

    public JComponent getControlPanel() {
        return this;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pn/export/CPN Tools.png")));
        this.jButton1.setToolTipText("Export to CPN");
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.setMaximumSize(new Dimension(70, 30));
        this.jButton1.setMinimumSize(new Dimension(53, 30));
        this.jButton1.setPreferredSize(new Dimension(60, 30));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 60, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 30, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.petriNet = null;
        for (int i = 0; i < this.responseListeners.size(); ++i) {
            ArrayList<IPetriNet> a = this.responseListeners.get(i).requestPetriNets();
            if (a == null) continue;
            this.addPetriNet(a.get(0));
        }
        if (this.petriNet != null) {
            this.open();
        }
    }
}

