/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.locks;

import com.jogamp.common.util.locks.LockExt;
import java.security.AccessController;
import java.util.LinkedList;
import jogamp.common.Debug;

public class RecursiveLock
implements LockExt {
    private final SyncData sdata = new SyncData();
    private static final boolean TRACE_LOCK = Debug.isPropertyDefined("jogamp.debug.Lock.TraceLock", true, AccessController.getContext());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Throwable getLockedStack() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.lockedStack;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Thread getOwner() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.owner;
        }
    }

    public final boolean isOwner() {
        return this.isOwner(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOwner(Thread thread) {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.owner == thread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLocked() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return null != this.sdata.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLockedByOtherThread() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return null != this.sdata.owner && Thread.currentThread() != this.sdata.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getRecursionCount() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.recursionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void validateLocked() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            if (null == this.sdata.owner) {
                throw new RuntimeException(Thread.currentThread() + ": Not locked");
            }
            if (Thread.currentThread() != this.sdata.owner) {
                if (null != this.sdata.lockedStack) {
                    this.sdata.lockedStack.printStackTrace();
                }
                throw new RuntimeException(Thread.currentThread() + ": Not owner, owner is " + this.sdata.owner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void lock() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            if (!this.tryLock(TIMEOUT)) {
                if (null != this.sdata.lockedStack) {
                    this.sdata.lockedStack.printStackTrace();
                }
                throw new RuntimeException("Waited " + TIMEOUT + "ms for: " + this.sdata.owner + " - " + Thread.currentThread() + ", with recursionCount " + this.sdata.recursionCount + ", lock: " + this + ", qsz " + this.sdata.threadQueue.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(long maxwait) {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            Thread cur = Thread.currentThread();
            if (TRACE_LOCK) {
                String msg = "LOCK 0 [" + this + "], recursions " + this.sdata.recursionCount + ", cur " + cur + ", owner " + this.sdata.owner;
                System.err.println(msg);
            }
            if (this.sdata.owner == cur) {
                ++this.sdata.recursionCount;
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK 2 [" + this + "], recursions " + this.sdata.recursionCount + ", " + cur);
                }
                return true;
            }
            if (this.sdata.owner != null || 0L < maxwait && (this.sdata.signaled || this.sdata.threadQueue.size() > 0)) {
                if (0L >= maxwait) {
                    return false;
                }
                boolean timedOut = false;
                do {
                    this.sdata.threadQueue.addFirst(cur);
                    try {
                        this.sdata.wait(maxwait);
                        timedOut = this.sdata.threadQueue.remove(cur);
                    }
                    catch (InterruptedException e) {
                        if (this.sdata.signaled) continue;
                        this.sdata.threadQueue.remove(cur);
                        if (!TRACE_LOCK) continue;
                        System.err.println("XXX LOCK - [" + this + "], recursions " + this.sdata.recursionCount + ", " + cur);
                    }
                } while (null != this.sdata.owner && !timedOut);
                this.sdata.signaled = false;
                if (timedOut || null != this.sdata.owner) {
                    return false;
                }
                if (TRACE_LOCK) {
                    System.err.println("+++ LOCK 3 [" + this + "], recursions " + this.sdata.recursionCount + ", qsz " + this.sdata.threadQueue.size() + ", " + cur);
                }
            } else if (TRACE_LOCK) {
                System.err.println("+++ LOCK 1 [" + this + "], recursions " + this.sdata.recursionCount + ", qsz " + this.sdata.threadQueue.size() + ", " + cur);
            }
            this.sdata.owner = cur;
            if (DEBUG) {
                this.sdata.lockedStack = new Throwable("Previously locked by " + this.sdata.owner + ", lock: " + this);
            }
            return true;
        }
    }

    public final void unlock() {
        this.unlock(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unlock(Runnable taskAfterUnlockBeforeNotify) {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            int qsz;
            this.validateLocked();
            if (this.sdata.recursionCount > 0) {
                --this.sdata.recursionCount;
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK 1 [" + this + "], recursions " + this.sdata.recursionCount + ", " + Thread.currentThread());
                }
                return;
            }
            this.sdata.owner = null;
            this.sdata.lockedStack = null;
            if (null != taskAfterUnlockBeforeNotify) {
                taskAfterUnlockBeforeNotify.run();
            }
            if ((qsz = this.sdata.threadQueue.size()) > 0) {
                Thread parkedThread = (Thread)this.sdata.threadQueue.removeLast();
                if (TRACE_LOCK) {
                    System.err.println("--- LOCK X [" + this + "], recursions " + this.sdata.recursionCount + ", " + Thread.currentThread() + ", irq " + (qsz - 1) + ": " + parkedThread);
                }
                this.sdata.signaled = true;
                if (qsz == 1) {
                    this.sdata.notify();
                } else {
                    parkedThread.interrupt();
                }
            } else if (TRACE_LOCK) {
                System.err.println("--- LOCK X [" + this + "], recursions " + this.sdata.recursionCount + ", " + Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWaitingThreadQueueSize() {
        SyncData syncData = this.sdata;
        synchronized (syncData) {
            return this.sdata.threadQueue.size();
        }
    }

    static class SyncData {
        Thread owner = null;
        int recursionCount = 0;
        Throwable lockedStack = null;
        LinkedList threadQueue = new LinkedList();
        boolean signaled = false;

        SyncData() {
        }
    }
}

