/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.StringTokenizer;

public class VersionNumber
implements Comparable {
    protected int major;
    protected int minor;
    protected int sub;

    public VersionNumber(int majorRev, int minorRev, int subMinorRev) {
        this.major = majorRev;
        this.minor = minorRev;
        this.sub = subMinorRev;
    }

    public VersionNumber(String versionString, String delim) {
        try {
            StringTokenizer tok = new StringTokenizer(versionString, delim);
            if (!tok.hasMoreTokens()) {
                this.major = 0;
                return;
            }
            this.major = Integer.valueOf(tok.nextToken());
            if (!tok.hasMoreTokens()) {
                this.minor = 0;
                return;
            }
            this.minor = Integer.valueOf(tok.nextToken());
            if (!tok.hasMoreTokens()) {
                this.sub = 0;
                return;
            }
            this.sub = Integer.valueOf(tok.nextToken());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("version <" + versionString + ">, delim <" + delim + ">", e);
        }
    }

    protected VersionNumber() {
    }

    public final int hashCode() {
        int hash = 31 + this.major;
        hash = (hash << 5) - hash + this.minor;
        return (hash << 5) - hash + this.sub;
    }

    public final boolean equals(Object o) {
        return 0 == this.compareTo(o);
    }

    public final int compareTo(Object o) {
        if (!(o instanceof VersionNumber)) {
            Class<?> c = null != o ? o.getClass() : null;
            throw new ClassCastException("Not a Capabilities object: " + c);
        }
        VersionNumber vo = (VersionNumber)o;
        if (this.major > vo.major) {
            return 1;
        }
        if (this.major < vo.major) {
            return -1;
        }
        if (this.minor > vo.minor) {
            return 1;
        }
        if (this.minor < vo.minor) {
            return -1;
        }
        if (this.sub > vo.sub) {
            return 1;
        }
        if (this.sub < vo.sub) {
            return -1;
        }
        return 0;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getSub() {
        return this.sub;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.sub;
    }
}

