/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class StructAccessor {
    private ByteBuffer bb;
    private FloatBuffer fb;
    private IntBuffer ib;
    private ShortBuffer sb;
    private CharBuffer cb;
    private DoubleBuffer db;
    private LongBuffer lb;

    public StructAccessor(ByteBuffer bb) {
        this.bb = bb.order(ByteOrder.nativeOrder());
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public ByteBuffer slice(int byteOffset, int byteLength) {
        this.bb.position(byteOffset);
        this.bb.limit(byteOffset + byteLength);
        ByteBuffer newBuf = this.bb.slice();
        this.bb.position(0);
        this.bb.limit(this.bb.capacity());
        return newBuf;
    }

    public byte getByteAt(int slot) {
        return this.bb.get(slot);
    }

    public void setByteAt(int slot, byte v) {
        this.bb.put(slot, v);
    }

    public char getCharAt(int slot) {
        return this.charBuffer().get(slot);
    }

    public void setCharAt(int slot, char v) {
        this.charBuffer().put(slot, v);
    }

    public double getDoubleAt(int slot) {
        return this.doubleBuffer().get(slot);
    }

    public void setDoubleAt(int slot, double v) {
        this.doubleBuffer().put(slot, v);
    }

    public float getFloatAt(int slot) {
        return this.floatBuffer().get(slot);
    }

    public void setFloatAt(int slot, float v) {
        this.floatBuffer().put(slot, v);
    }

    public int getIntAt(int slot) {
        return this.intBuffer().get(slot);
    }

    public void setIntAt(int slot, int v) {
        this.intBuffer().put(slot, v);
    }

    public short getShortAt(int slot) {
        return this.shortBuffer().get(slot);
    }

    public void setShortAt(int slot, short v) {
        this.shortBuffer().put(slot, v);
    }

    public void setBytesAt(int slot, byte[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.bb.put(slot++, v[i]);
        }
    }

    public byte[] getBytesAt(int slot, byte[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.bb.get(slot++);
        }
        return v;
    }

    public void setCharsAt(int slot, char[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.charBuffer().put(slot++, v[i]);
        }
    }

    public char[] getCharsAt(int slot, char[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.charBuffer().get(slot++);
        }
        return v;
    }

    public void setIntsAt(int slot, int[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.intBuffer().put(slot++, v[i]);
        }
    }

    public int[] getIntsAt(int slot, int[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.intBuffer().get(slot++);
        }
        return v;
    }

    public void setFloatsAt(int slot, float[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.floatBuffer().put(slot++, v[i]);
        }
    }

    public float[] getFloatsAt(int slot, float[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.floatBuffer().get(slot++);
        }
        return v;
    }

    public void setDoublesAt(int slot, double[] v) {
        for (int i = 0; i < v.length; ++i) {
            this.doubleBuffer().put(slot++, v[i]);
        }
    }

    public double[] getDoublesAt(int slot, double[] v) {
        for (int i = 0; i < v.length; ++i) {
            v[i] = this.doubleBuffer().get(slot++);
        }
        return v;
    }

    public long getLongAt(int slot) {
        return this.longBuffer().get(slot);
    }

    public void setLongAt(int slot, long v) {
        this.longBuffer().put(slot, v);
    }

    private final FloatBuffer floatBuffer() {
        if (this.fb == null) {
            this.fb = this.bb.asFloatBuffer();
        }
        return this.fb;
    }

    private final IntBuffer intBuffer() {
        if (this.ib == null) {
            this.ib = this.bb.asIntBuffer();
        }
        return this.ib;
    }

    private final ShortBuffer shortBuffer() {
        if (this.sb == null) {
            this.sb = this.bb.asShortBuffer();
        }
        return this.sb;
    }

    private final LongBuffer longBuffer() {
        if (this.lb == null) {
            this.lb = this.bb.asLongBuffer();
        }
        return this.lb;
    }

    private final DoubleBuffer doubleBuffer() {
        if (this.db == null) {
            this.db = this.bb.asDoubleBuffer();
        }
        return this.db;
    }

    private final CharBuffer charBuffer() {
        if (this.cb == null) {
            this.cb = this.bb.asCharBuffer();
        }
        return this.cb;
    }
}

