/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class PointerBuffer
extends NativeSizeBuffer {
    protected final Map<Long, Buffer> dataMap = new HashMap<Long, Buffer>();

    protected PointerBuffer(ByteBuffer bb) {
        super(bb);
    }

    public static PointerBuffer allocate(int size) {
        return new PointerBuffer(ByteBuffer.wrap(new byte[PointerBuffer.elementSize() * size]));
    }

    public static PointerBuffer allocate(long[] array) {
        return PointerBuffer.allocate(array.length).put(array, 0, array.length).rewind();
    }

    public static PointerBuffer allocateDirect(int size) {
        return new PointerBuffer(Buffers.newDirectByteBuffer(PointerBuffer.elementSize() * size));
    }

    public static PointerBuffer allocateDirect(long[] array) {
        return PointerBuffer.allocateDirect(array.length).put(array, 0, array.length).rewind();
    }

    public static PointerBuffer wrap(ByteBuffer src) {
        return new PointerBuffer(src);
    }

    public PointerBuffer put(NativeBuffer src) {
        if (this.remaining() < src.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        while (src.hasRemaining()) {
            long addr = src.get();
            this.put(addr);
            Buffer buffer = this.dataMap.get(addr);
            if (buffer != null) {
                this.dataMap.put(addr, buffer);
                continue;
            }
            this.dataMap.remove(addr);
        }
        return this;
    }

    private void referenceBufferImpl(int index, Buffer buffer, boolean relative) {
        if (buffer == null) {
            throw new IllegalArgumentException("Buffer is null");
        }
        if (buffer.isDirect() != this.isDirect()) {
            throw new IllegalArgumentException("buffer.isDirect() != this.isDirect()");
        }
        long mask = Platform.is32Bit() ? 0xFFFFFFFFL : -1L;
        long bbAddr = this.getDirectBufferAddressImpl(buffer) & mask;
        if (bbAddr == 0L) {
            throw new RuntimeException("Couldn't determine native address of given Buffer: " + buffer);
        }
        if (relative) {
            this.put(bbAddr);
        } else {
            this.put(index, bbAddr);
        }
        this.dataMap.put(bbAddr, buffer);
    }

    public final PointerBuffer referenceBuffer(int index, Buffer buffer) {
        this.referenceBufferImpl(index, buffer, false);
        return this;
    }

    public final PointerBuffer referenceBuffer(Buffer buffer) {
        this.referenceBufferImpl(0, buffer, true);
        return this;
    }

    public final Buffer getReferencedBuffer(int index) {
        long addr = this.get(index);
        return this.dataMap.get(addr);
    }

    public final Buffer getReferencedBuffer() {
        long addr = this.get();
        return this.dataMap.get(addr);
    }

    protected native long getDirectBufferAddressImpl(Object var1);

    public PointerBuffer put(int index, long value) {
        return (PointerBuffer)super.put(index, value);
    }

    public PointerBuffer get(long[] dest, int offset, int length) {
        return (PointerBuffer)super.get(dest, offset, length);
    }

    public PointerBuffer put(long value) {
        return (PointerBuffer)super.put(value);
    }

    public PointerBuffer put(long[] src, int offset, int length) {
        return (PointerBuffer)super.put(src, offset, length);
    }

    public PointerBuffer position(int newPos) {
        return (PointerBuffer)super.position(newPos);
    }

    public PointerBuffer rewind() {
        return (PointerBuffer)super.rewind();
    }
}

