/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.NativeSizeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class CachedBufferFactory {
    public static final int DEFAULT_ALLOCATION_SIZE = 0x100000;
    private final int ALLOCATION_SIZE;
    private ByteBuffer currentBuffer;

    private CachedBufferFactory() {
        this(0x100000, 0x100000);
    }

    private CachedBufferFactory(int initialSize, int allocationSize) {
        if (initialSize < 0 || allocationSize < 0) {
            throw new IllegalArgumentException("sizes must be >= 0");
        }
        this.currentBuffer = Buffers.newDirectByteBuffer(initialSize);
        this.ALLOCATION_SIZE = allocationSize;
    }

    public static CachedBufferFactory create() {
        return new CachedBufferFactory();
    }

    public static CachedBufferFactory create(int initialSize) {
        return new CachedBufferFactory(initialSize, 0x100000);
    }

    public static CachedBufferFactory create(int initialSize, boolean fixed) {
        return new CachedBufferFactory(initialSize, fixed ? 0 : 0x100000);
    }

    public static CachedBufferFactory create(int initialSize, int allocationSize) {
        return new CachedBufferFactory(initialSize, allocationSize);
    }

    public static CachedBufferFactory createSynchronized() {
        return new SynchronizedCachedBufferFactory();
    }

    public static CachedBufferFactory createSynchronized(int initialSize) {
        return new SynchronizedCachedBufferFactory(initialSize, 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int initialSize, boolean fixed) {
        return new SynchronizedCachedBufferFactory(initialSize, fixed ? 0 : 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int initialSize, int allocationSize) {
        return new CachedBufferFactory(initialSize, allocationSize);
    }

    public boolean isFixed() {
        return this.ALLOCATION_SIZE == 0;
    }

    public int getAllocationSize() {
        return this.isFixed() ? this.currentBuffer.capacity() : this.ALLOCATION_SIZE;
    }

    private void checkIfFixed() {
        if (this.isFixed()) {
            throw new RuntimeException("fixed size buffer factory ran out ouf bounds.");
        }
    }

    public ByteBuffer newDirectByteBuffer(int size) {
        if (size > this.currentBuffer.capacity()) {
            this.checkIfFixed();
            return Buffers.newDirectByteBuffer(size);
        }
        if (size > this.currentBuffer.remaining()) {
            this.checkIfFixed();
            this.currentBuffer = Buffers.newDirectByteBuffer(this.ALLOCATION_SIZE);
        }
        this.currentBuffer.limit(this.currentBuffer.position() + size);
        ByteBuffer result = this.currentBuffer.slice().order(this.currentBuffer.order());
        this.currentBuffer.position(this.currentBuffer.limit());
        this.currentBuffer.limit(this.currentBuffer.capacity());
        return result;
    }

    public ByteBuffer newDirectByteBuffer(byte[] values, int offset, int lenght) {
        return (ByteBuffer)this.newDirectByteBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public ByteBuffer newDirectByteBuffer(byte[] values, int offset) {
        return this.newDirectByteBuffer(values, offset, values.length - offset);
    }

    public ByteBuffer newDirectByteBuffer(byte[] values) {
        return this.newDirectByteBuffer(values, 0);
    }

    public DoubleBuffer newDirectDoubleBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 8).asDoubleBuffer();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] values, int offset, int lenght) {
        return (DoubleBuffer)this.newDirectDoubleBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] values, int offset) {
        return this.newDirectDoubleBuffer(values, offset, values.length - offset);
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] values) {
        return this.newDirectDoubleBuffer(values, 0);
    }

    public FloatBuffer newDirectFloatBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 4).asFloatBuffer();
    }

    public FloatBuffer newDirectFloatBuffer(float[] values, int offset, int lenght) {
        return (FloatBuffer)this.newDirectFloatBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public FloatBuffer newDirectFloatBuffer(float[] values, int offset) {
        return this.newDirectFloatBuffer(values, offset, values.length - offset);
    }

    public FloatBuffer newDirectFloatBuffer(float[] values) {
        return this.newDirectFloatBuffer(values, 0);
    }

    public IntBuffer newDirectIntBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 4).asIntBuffer();
    }

    public IntBuffer newDirectIntBuffer(int[] values, int offset, int lenght) {
        return (IntBuffer)this.newDirectIntBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public IntBuffer newDirectIntBuffer(int[] values, int offset) {
        return this.newDirectIntBuffer(values, offset, values.length - offset);
    }

    public IntBuffer newDirectIntBuffer(int[] values) {
        return this.newDirectIntBuffer(values, 0);
    }

    public LongBuffer newDirectLongBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 8).asLongBuffer();
    }

    public LongBuffer newDirectLongBuffer(long[] values, int offset, int lenght) {
        return (LongBuffer)this.newDirectLongBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public LongBuffer newDirectLongBuffer(long[] values, int offset) {
        return this.newDirectLongBuffer(values, offset, values.length - offset);
    }

    public LongBuffer newDirectLongBuffer(long[] values) {
        return this.newDirectLongBuffer(values, 0);
    }

    public ShortBuffer newDirectShortBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 2).asShortBuffer();
    }

    public ShortBuffer newDirectShortBuffer(short[] values, int offset, int lenght) {
        return (ShortBuffer)this.newDirectShortBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public ShortBuffer newDirectShortBuffer(short[] values, int offset) {
        return this.newDirectShortBuffer(values, offset, values.length - offset);
    }

    public ShortBuffer newDirectShortBuffer(short[] values) {
        return this.newDirectShortBuffer(values, 0);
    }

    public CharBuffer newDirectCharBuffer(int numElements) {
        return this.newDirectByteBuffer(numElements * 2).asCharBuffer();
    }

    public CharBuffer newDirectCharBuffer(char[] values, int offset, int lenght) {
        return (CharBuffer)this.newDirectCharBuffer(lenght).put(values, offset, lenght).rewind();
    }

    public CharBuffer newDirectCharBuffer(char[] values, int offset) {
        return this.newDirectCharBuffer(values, offset, values.length - offset);
    }

    public CharBuffer newDirectCharBuffer(char[] values) {
        return this.newDirectCharBuffer(values, 0);
    }

    public NativeSizeBuffer newDirectNativeSizeBuffer(int numElements) {
        return NativeSizeBuffer.allocateDirect(numElements);
    }

    public NativeSizeBuffer newDirectNativeSizeBuffer(long[] values, int offset, int lenght) {
        return (NativeSizeBuffer)NativeSizeBuffer.allocateDirect(values.length).put(values, offset, lenght).rewind();
    }

    public NativeSizeBuffer newDirectNativeSizeBuffer(long[] values, int offset) {
        return this.newDirectNativeSizeBuffer(values.length).put(values, offset, values.length - offset);
    }

    public NativeSizeBuffer newDirectNativeSizeBuffer(long[] values) {
        return this.newDirectNativeSizeBuffer(values, 0);
    }

    public PointerBuffer newDirectPointerBuffer(int numElements) {
        return PointerBuffer.allocateDirect(numElements);
    }

    public PointerBuffer newDirectPointerBuffer(long[] values, int offset, int lenght) {
        return PointerBuffer.allocateDirect(values.length).put(values, offset, lenght).rewind();
    }

    public PointerBuffer newDirectPointerBuffer(long[] values, int offset) {
        return this.newDirectPointerBuffer(values.length).put(values, offset, values.length - offset);
    }

    public PointerBuffer newDirectPointerBuffer(long[] values) {
        return this.newDirectPointerBuffer(values, 0);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CachedBufferFactory other = (CachedBufferFactory)obj;
        if (this.ALLOCATION_SIZE != other.ALLOCATION_SIZE) {
            return false;
        }
        return this.currentBuffer == other.currentBuffer || this.currentBuffer != null && this.currentBuffer.equals(other.currentBuffer);
    }

    public String toString() {
        return this.getClass().getName() + "[static:" + this.isFixed() + " alloc size:" + this.getAllocationSize() + "]";
    }

    private static class SynchronizedCachedBufferFactory
    extends CachedBufferFactory {
        private SynchronizedCachedBufferFactory() {
        }

        private SynchronizedCachedBufferFactory(int size, int step) {
            super(size, step);
        }

        public synchronized ByteBuffer newDirectByteBuffer(int size) {
            return super.newDirectByteBuffer(size);
        }
    }
}

