/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pnmodulepretabgen.EvPNPreTable;
import pnmodulepretabgen.PreTable;
import pnmodulepretabgen.PreTableFrame;

public class ModuleImpl
extends JPanel
implements IModule {
    private IPetriNet petriNet;
    private PreTableFrame pptf;
    private ArrayList<IResponseListener> responseListeners;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
        this.petriNet = null;
        this.pptf = null;
        this.responseListeners = new ArrayList();
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PN module generating Pre tables</h1>Author: Peter Antal</html>";
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNet = pn;
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        if (this.petriNet == null) {
            return;
        }
        this.pptf = new PreTableFrame(this.getPreTable(), "PRE table");
        this.pptf.setVisible(true);
    }

    @Override
    public void close() {
        if (this.pptf == null) {
            return;
        }
        this.pptf.dispose();
    }

    @Override
    public String getName() {
        return "PRE table generator";
    }

    public PreTable getPreTable() {
        if (this.petriNet == null) {
            return null;
        }
        if (this.petriNet.getType().equals("EvPN")) {
            EvPNPreTable evppt = new EvPNPreTable();
            for (int i = 0; i < this.petriNet.getArcs().size(); ++i) {
                String relPlace;
                if (this.petriNet.getArcs().get(i).getStartingVertex() instanceof IPlace) {
                    relPlace = "";
                    try {
                        relPlace = (String)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN Function");
                        if (relPlace == null) {
                            relPlace = "1";
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    evppt.addLine(this.petriNet.getArcs().get(i).getStartingVertex().getId(), relPlace, this.petriNet.getArcs().get(i).getEndingVertex().getId(), this.petriNet.getArcs().get(i).getCount(), (Boolean)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN d"), (Integer)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN w") == -1);
                    continue;
                }
                relPlace = "";
                try {
                    relPlace = (String)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN Function");
                    if (relPlace == null) {
                        relPlace = "1";
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                evppt.addLine(this.petriNet.getArcs().get(i).getEndingVertex().getId(), relPlace, this.petriNet.getArcs().get(i).getStartingVertex().getId(), 0, (Boolean)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN d"), (Integer)((Properties)this.petriNet.getArcs().get(i).getAdditionalData()).get("EvPN w") == -1);
            }
            evppt.sort();
            return evppt;
        }
        PreTable ppt = new PreTable();
        for (int i = 0; i < this.petriNet.getArcs().size(); ++i) {
            if (this.petriNet.getArcs().get(i).getStartingVertex() instanceof IPlace) {
                ppt.addLine(this.petriNet.getArcs().get(i).getStartingVertex().getId(), this.petriNet.getArcs().get(i).getEndingVertex().getId(), this.petriNet.getArcs().get(i).getCount());
                continue;
            }
            ppt.addLine(this.petriNet.getArcs().get(i).getEndingVertex().getId(), this.petriNet.getArcs().get(i).getStartingVertex().getId(), 0);
        }
        ppt.sort();
        return ppt;
    }

    @Override
    public JComponent getControlPanel() {
        return this;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pnmodulepretabgen/icon.png")));
        this.jButton1.setToolTipText("Generate PRE table");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.petriNet == null) {
            for (int i = 0; i < this.responseListeners.size(); ++i) {
                ArrayList<IPetriNet> a = this.responseListeners.get(i).requestPetriNets();
                if (a == null || a.size() <= 0) continue;
                this.petriNet = a.get(0);
                this.open();
                this.petriNet = null;
            }
        }
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Gener\u00e1tor PRE tabu&#318;ky";
        }
        if (prefix.equals("_eng")) {
            languageName = "PRE table generator";
        }
        return languageName;
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/pre_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/pre_eng.html";
    }

    @Override
    public String getTarget() {
        return "pre";
    }
}

