/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import pn.modules.pn.Impl.PetriNet;
import pnmodulereachability.Loop;
import pnmodulereachability.Vertex;
import pnmodulereachability.reachabilityException;

public class VstPath {
    public static final byte NOTFOUND = 110;
    public static final byte EQUALSTATE = 101;
    public static final byte OMEGALIZE = 111;
    private int count_P = 0;
    private int count_T = 0;
    private int[] omegaVector = null;
    private Vertex eqVertex = null;
    private Vertex omgVertex = null;
    private List<Vertex> pVertices = null;
    private BitSet pVerticesFlag;
    private List<Integer> pTransts = null;
    private List<Integer> pMwTransts = null;
    private PetriNet pn;

    public VstPath(PetriNet pn, int noOfPlaces, int noOfTransitions, Vertex qStart, boolean isForLoops) {
        this.initPath(noOfPlaces, noOfTransitions, qStart, isForLoops);
        this.pn = pn;
    }

    public VstPath(PetriNet pn, int noOfPlaces, int noOfTransitions) {
        this.initPath(noOfPlaces, noOfTransitions, null, false);
        this.pn = pn;
    }

    private void initPath(int noOfPlaces, int noOfTransitions, Vertex qStart, boolean isForLoops) {
        this.pVertices = new ArrayList<Vertex>();
        this.count_P = noOfPlaces;
        this.count_T = noOfTransitions;
        this.pVerticesFlag = new BitSet();
        if (isForLoops) {
            this.pTransts = new ArrayList<Integer>();
            this.pMwTransts = new ArrayList<Integer>();
        } else {
            this.omegaVector = new int[this.count_P];
            Arrays.fill(this.omegaVector, 0);
        }
        if (qStart != null) {
            this.pVertices.add(qStart);
            this.pVerticesFlag.set(qStart.getVertId());
        }
    }

    public void addVertex(Vertex v) {
        this.pVertices.add(v);
    }

    public boolean isEmpty() {
        return this.pVertices.isEmpty();
    }

    public Vertex removeLastVertex() {
        if (this.pVertices == null) {
            return null;
        }
        if (this.pVertices.isEmpty()) {
            return null;
        }
        this.pVerticesFlag.clear(this.pVertices.get(this.pVertices.size() - 1).getVertId());
        return this.pVertices.remove(this.pVertices.size() - 1);
    }

    public Integer removeLastTr() {
        if (this.pTransts == null) {
            return null;
        }
        if (this.pTransts.isEmpty()) {
            return null;
        }
        this.pMwTransts.remove(this.pMwTransts.size() - 1);
        return this.pTransts.remove(this.pTransts.size() - 1);
    }

    public byte findSmallerOrEqualTo(Vertex qNew) {
        this.eqVertex = null;
        this.omgVertex = null;
        this.omegaVector = null;
        if (this.pVertices.size() == 0) {
            return 110;
        }
        int flag = 110;
        ListIterator<Vertex> it = this.pVertices.listIterator(this.pVertices.size());
        do {
            Vertex pom;
            int[] compResult;
            if ((compResult = (pom = it.previous()).compareTo(qNew)) == null) continue;
            if (compResult[0] == -1) {
                if (flag != 110) continue;
                flag = 101;
                this.eqVertex = pom;
                continue;
            }
            flag = 111;
            this.omgVertex = pom;
            this.omegaVector = compResult;
        } while (it.hasPrevious() && flag != 111);
        return (byte)flag;
    }

    public void createEqualLoop(Vertex q, int transIndex, Vertex qNew, boolean qNewIsReallyNew) throws reachabilityException {
        if (this.eqVertex == null) {
            throw new reachabilityException("eqVertex not set.");
        }
        if (qNewIsReallyNew) {
            q.setNext(transIndex, this.eqVertex);
        } else if (qNew.getVertId() > this.eqVertex.getVertId()) {
            if (q == this.eqVertex) {
                q.setNext(transIndex, q);
            } else {
                int j = 0;
                while (j < this.count_T) {
                    if (this.eqVertex.getNext(j) == null && qNew.getNext(j) != null && qNew.getNext(j) != qNew) {
                        this.eqVertex.setNext(j, qNew.getNext(j));
                    }
                    ++j;
                }
                q.setNext(transIndex, this.eqVertex);
            }
        }
        this.eqVertex = null;
    }

    public void createOmegaLoop(Vertex q, int transIndex, Vertex qNew, int newOmegaId, boolean qNewIsReallyNew) throws reachabilityException {
        if (this.omgVertex == null || this.omegaVector == null) {
            throw new reachabilityException("omgVertex or omegaVector not set.");
        }
        if (!qNewIsReallyNew) {
            int j = 0;
            while (j < this.count_T) {
                if (this.omgVertex.getNext(j) == null && qNew.getNext(j) != null) {
                    if (qNew.getNext(j) == qNew) {
                        this.omgVertex.setNext(j, this.omgVertex);
                    } else {
                        this.omgVertex.setNext(j, qNew.getNext(j));
                    }
                }
                ++j;
            }
        }
        q.setNext(transIndex, this.omgVertex);
        this.removeFrom(this.pVertices.lastIndexOf(this.omgVertex) + 1);
        this.omgVertex.setOmegasWrt(this.omegaVector);
        this.omgVertex.setOmegaId(newOmegaId);
        this.omgVertex.resetCalculated(false);
        this.omgVertex = null;
        this.omegaVector = null;
    }

    public Vertex getLastVertex() {
        if (this.pVertices.size() > 0) {
            return this.pVertices.get(this.pVertices.size() - 1);
        }
        return null;
    }

    public void add(int transIndex, int mwTransIndex, Vertex state) {
        if (transIndex >= 0 && state != null) {
            this.pVertices.add(state);
            this.pVerticesFlag.set(state.getVertId());
            this.pTransts.add(new Integer(transIndex));
            this.pMwTransts.add(new Integer(mwTransIndex));
        }
    }

    public int getFirstVertexPosition(Vertex state) {
        if (!this.pVerticesFlag.get(state.getVertId())) {
            return -1;
        }
        return this.pVertices.indexOf(state);
    }

    public Loop createLoop(int initVertPos, int lastTrIndex) throws reachabilityException {
        if (this.pVertices.size() != this.pTransts.size() + 1 || this.pVertices.size() <= initVertPos) {
            throw new reachabilityException("Path incosistent.");
        }
        BitSet loop = new BitSet();
        BitSet states = new BitSet();
        int i = initVertPos;
        while (i < this.pTransts.size()) {
            loop.set(this.pMwTransts.get(i));
            states.set(this.pVertices.get(i).getVertId());
            ++i;
        }
        loop.set(lastTrIndex);
        states.set(this.getLastVertex().getVertId());
        Loop temp = new Loop(this.pn, loop, states);
        return temp;
    }

    public int[] transVector(PetriNet pn) {
        if (this.pTransts == null) {
            return null;
        }
        int[] trVector = new int[this.count_P];
        Arrays.fill(trVector, 0);
        ListIterator<Integer> it = this.pTransts.listIterator(0);
        while (it.hasNext()) {
            int trIndex = it.next();
            int i = 0;
            while (i < this.count_P) {
                trVector[i] = trVector[i] + pn.postt[i][trIndex] - pn.pre[i][trIndex];
                ++i;
            }
        }
        return trVector;
    }

    public String toString() {
        if (this.pTransts == null) {
            return this.pVertices.toString();
        }
        if (this.pVertices == null) {
            return this.pTransts.toString();
        }
        StringBuilder tt = new StringBuilder("");
        int i = 0;
        while (i < this.pVertices.size()) {
            tt.append("Q" + this.pVertices.get(i).getVertId());
            if (i < this.pTransts.size()) {
                tt.append("-t" + this.pTransts.get(i).toString() + "->");
            }
            ++i;
        }
        return tt.toString();
    }

    public int size() {
        return this.pVertices.size();
    }

    private void removeFrom(int index) throws reachabilityException {
        if (index < 0) {
            throw new reachabilityException("Illegal parameter (index) value.");
        }
        int lastElmIndex = this.pVertices.size() - 1;
        if (this.pTransts == null) {
            while (index <= lastElmIndex) {
                this.pVertices.remove(lastElmIndex);
                --lastElmIndex;
            }
        } else if (this.pVertices.size() == this.pTransts.size() + 1) {
            while (index <= lastElmIndex) {
                this.pVertices.remove(lastElmIndex);
                if (lastElmIndex > 0) {
                    this.pTransts.remove(lastElmIndex - 1);
                    this.pMwTransts.remove(lastElmIndex - 1);
                }
                --lastElmIndex;
            }
        } else {
            throw new reachabilityException("Path incosistent.");
        }
    }

    public void setPVertices(List<Vertex> pVertices) {
        this.pVertices = pVertices;
    }

    public List<Vertex> getPVertices() {
        return this.pVertices;
    }

    public void setPTransts(List<Integer> pTransts) {
        this.pTransts = pTransts;
    }

    public List<Integer> getPTransts() {
        return this.pTransts;
    }
}

