/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.Arrays;

public class Vertex {
    private int vert_id;
    private int omegaId;
    private int[] stateVector;
    private int[] firstNonOmegalizedVector;
    private Vertex[] next;
    private boolean[] calculated;
    private boolean[] visited;
    private int count_P;
    private int count_T;
    private int[] synchronicTransitionFired;
    public boolean seen;
    private int sccTempIndex;
    private int sccTempLowIndex;
    private int sccId = -1;
    private boolean inSccStack;

    public Vertex(int count_P, int count_T, int statenumber) {
        this.count_P = count_P;
        this.count_T = count_T;
        this.vert_id = statenumber;
        this.omegaId = 0;
        this.stateVector = new int[count_P];
        this.next = new Vertex[count_T];
        this.calculated = new boolean[count_T];
        int i = 0;
        while (i < count_P) {
            this.stateVector[i] = 0;
            ++i;
        }
        i = 0;
        while (i < count_T) {
            this.next[i] = null;
            this.calculated[i] = false;
            ++i;
        }
    }

    public boolean setStateVector(int[] stateVctr) {
        if (stateVctr == null) {
            return false;
        }
        if (stateVctr.length != this.count_P) {
            return false;
        }
        int i = 0;
        while (i < this.count_P) {
            this.stateVector[i] = stateVctr[i];
            ++i;
        }
        if (this.firstNonOmegalizedVector == null) {
            this.firstNonOmegalizedVector = new int[this.stateVector.length];
            System.arraycopy(this.stateVector, 0, this.firstNonOmegalizedVector, 0, this.stateVector.length);
        }
        return true;
    }

    public int getStateVectorAt(int i) {
        return this.stateVector[i];
    }

    public int getStateVectorLength() {
        return this.stateVector.length;
    }

    public int getVertId() {
        return this.vert_id;
    }

    public void setVertId(int id) {
        this.vert_id = id;
    }

    public int getOmegaId() {
        return this.omegaId;
    }

    public byte enabled(int[] transPreVect, int[] transVect) {
        if (transPreVect.length != this.count_P && transVect.length != this.count_P) {
            return 0;
        }
        boolean toOmegOrEqual = true;
        int i = 0;
        while (i < this.count_P) {
            if (this.stateVector[i] != 200000000) {
                if (this.stateVector[i] - transPreVect[i] < 0) {
                    return 0;
                }
                if (transVect[i] < 0) {
                    toOmegOrEqual = false;
                }
            }
            ++i;
        }
        if (toOmegOrEqual) {
            return 2;
        }
        return 1;
    }

    public int[] firingResult(int[] transVect) {
        int[] stateAfterFiring = new int[this.count_P];
        int i = 0;
        while (i < this.count_P) {
            if (this.stateVector[i] == 200000000) {
                stateAfterFiring[i] = 200000000;
            } else {
                stateAfterFiring[i] = this.stateVector[i] + transVect[i];
                if (stateAfterFiring[i] >= 200000000 || stateAfterFiring[i] < 0) {
                    return null;
                }
            }
            ++i;
        }
        return stateAfterFiring;
    }

    public Vertex getNext(int transIndex) {
        return this.next[transIndex];
    }

    public Vertex[] getWholeNext() {
        return this.next;
    }

    public int getNextTr(boolean unVisited) {
        int i = 0;
        while (i < this.count_T) {
            if (this.next[i] != null) {
                if (unVisited) {
                    if (!this.visited[i]) {
                        return i;
                    }
                } else {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public void setNext(int transIndex, Vertex q) {
        this.next[transIndex] = q;
    }

    public void resetCalculated(boolean notNullOnly) {
        if (notNullOnly) {
            int i = 0;
            while (i < this.count_T) {
                if (this.next[i] != null) {
                    this.calculated[i] = false;
                }
                ++i;
            }
        } else {
            Arrays.fill(this.calculated, false);
            int i = 0;
            while (i < this.count_T) {
                this.calculated[i] = false;
                ++i;
            }
        }
    }

    public boolean isCalculated(int transIndex) {
        return this.calculated[transIndex];
    }

    public void setAsCalculated(int transIndex) {
        this.calculated[transIndex] = true;
    }

    public void initResetVisited(boolean resetOnly) {
        if (!resetOnly) {
            this.visited = new boolean[this.count_T];
        }
        Arrays.fill(this.visited, false);
    }

    public void setAsVisited(int transIndex) {
        this.visited[transIndex] = true;
    }

    public boolean isEquivalentTo(Vertex q, boolean considerOmegaId) {
        if (this.stateVector.length != q.getStateVectorLength()) {
            return false;
        }
        if (considerOmegaId && this.omegaId != q.getOmegaId()) {
            return false;
        }
        int i = 0;
        while (i < this.count_P) {
            if (this.stateVector[i] != q.getStateVectorAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasSameOmegasAs(Vertex q) {
        int i = 0;
        while (i < this.count_P) {
            if (this.stateVector[i] == 200000000 && q.getStateVectorAt(i) != 200000000) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reomegalizeWrt(Vertex q) {
        int i = 0;
        while (i < this.count_P) {
            if (q.getStateVectorAt(i) == 200000000) {
                if (this.getFirstNonOmegalizedVector() == null) {
                    this.firstNonOmegalizedVector = new int[this.stateVector.length];
                    System.arraycopy(this.stateVector, 0, this.getFirstNonOmegalizedVector(), 0, this.stateVector.length);
                }
                this.stateVector[i] = 200000000;
            }
            ++i;
        }
        this.omegaId = q.getOmegaId();
        this.resetCalculated(false);
    }

    public boolean covers(int[] vector) {
        if (this.getStateVectorLength() != vector.length) {
            return false;
        }
        int i = 0;
        while (i < this.count_P) {
            if (this.stateVector[i] != 200000000 && this.stateVector[i] != vector[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] compareTo(Vertex q2) {
        int[] omegVect = new int[this.count_P];
        Arrays.fill(omegVect, 0);
        boolean omegalize = false;
        int j = 0;
        while (j < this.count_P) {
            if (this.stateVector[j] > q2.getStateVectorAt(j)) {
                return null;
            }
            if (this.stateVector[j] < q2.getStateVectorAt(j)) {
                omegalize = true;
                omegVect[j] = 200000000;
            }
            ++j;
        }
        if (omegalize) {
            return omegVect;
        }
        int[] eqv = new int[]{-1};
        return eqv;
    }

    public String toHtmlString() {
        StringBuffer sb0 = new StringBuffer();
        sb0.append("Q" + this.vert_id + " = ");
        if (this.stateVector[0] != 200000000) {
            sb0.append("(" + this.stateVector[0]);
        } else {
            sb0.append("(&#969;");
        }
        int i = 1;
        while (i < this.count_P) {
            if (this.stateVector[i] != 200000000) {
                sb0.append("," + this.stateVector[i]);
            } else {
                sb0.append(",&#969;");
            }
            ++i;
        }
        sb0.append(")<BR>");
        return sb0.toString();
    }

    public String toString() {
        if (this.stateVector[0] == 200000001) {
            return new String("QAux");
        }
        StringBuffer sb0 = new StringBuffer();
        sb0.append("Q" + this.vert_id + "/" + this.omegaId + "=");
        if (this.stateVector[0] != 200000000) {
            sb0.append("(" + this.stateVector[0]);
        } else {
            sb0.append("(w");
        }
        int i = 1;
        while (i < this.count_P) {
            if (this.stateVector[i] != 200000000) {
                sb0.append("," + this.stateVector[i]);
            } else {
                sb0.append(",w");
            }
            ++i;
        }
        sb0.append(")");
        return sb0.toString();
    }

    public String toShortString() {
        return "Q" + this.getVertId();
    }

    public void setOmegasWrt(int[] omegaVector) {
        int i = 0;
        while (i < this.count_P) {
            if (omegaVector[i] == 200000000) {
                if (this.getFirstNonOmegalizedVector() == null) {
                    this.firstNonOmegalizedVector = new int[this.stateVector.length];
                    System.arraycopy(this.stateVector, 0, this.getFirstNonOmegalizedVector(), 0, this.stateVector.length);
                }
                this.stateVector[i] = 200000000;
            }
            ++i;
        }
    }

    public void setOmegasWrt(Vertex q) {
        int i = 0;
        while (i < this.count_P) {
            if (q.getStateVectorAt(i) == 200000000) {
                if (this.getFirstNonOmegalizedVector() == null) {
                    this.firstNonOmegalizedVector = new int[this.stateVector.length];
                    System.arraycopy(this.stateVector, 0, this.getFirstNonOmegalizedVector(), 0, this.stateVector.length);
                }
                this.stateVector[i] = 200000000;
            }
            ++i;
        }
    }

    public void setStateVectorAt(int i, int newVal) {
        this.stateVector[i] = newVal;
    }

    public void setOmegaId(int newOmegaId) {
        this.omegaId = newOmegaId;
    }

    public boolean has2orMoreChilds() {
        int chCount = 0;
        int i = 0;
        while (i < this.count_T) {
            if (this.next[i] != null) {
                if (chCount > 0) {
                    return true;
                }
                ++chCount;
            }
            ++i;
        }
        return false;
    }

    public String autMwGetTransTableRowAsString(boolean inHtml) {
        StringBuffer sb1 = new StringBuffer();
        if (inHtml) {
            sb1.append("<tr><th>Q" + this.vert_id);
        } else {
            sb1.append("\nQ" + this.vert_id + "/" + this.omegaId + "\t| ");
        }
        int i = 0;
        while (i < this.count_T) {
            if (this.next[i] != null) {
                if (inHtml) {
                    sb1.append("<td>Q" + this.next[i].vert_id);
                } else {
                    sb1.append("Q" + this.next[i].vert_id + "/" + this.next[i].omegaId + "\t| ");
                }
            } else if (inHtml) {
                sb1.append("<td>&nbsp;");
            } else {
                sb1.append("\t| ");
            }
            ++i;
        }
        return sb1.toString();
    }

    public int[] getSynchronicTransitionFired() {
        return this.synchronicTransitionFired;
    }

    public void setSynchronicTransitionFired(int[] synchronicTransitionFired) {
        this.synchronicTransitionFired = synchronicTransitionFired;
    }

    public int[] getFirstNonOmegalizedVector() {
        return this.firstNonOmegalizedVector;
    }

    public int getSccTempIndex() {
        return this.sccTempIndex;
    }

    public void setSccTempIndex(int val) {
        this.sccTempIndex = val;
    }

    public int getSccTempLowIndex() {
        return this.sccTempLowIndex;
    }

    public void setSccTempLowIndex(int val) {
        this.sccTempLowIndex = val;
    }

    public int getSccId() {
        return this.sccId;
    }

    public void setSccId(int val) {
        this.sccId = val;
    }

    public boolean isInSccStack() {
        return this.inSccStack;
    }

    public void setInSccStack(boolean val) {
        this.inSccStack = val;
    }
}

