/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.ArrayList;
import java.util.BitSet;
import pn.ModuleImpl;
import pn.modules.pn.Impl.Arc;
import pn.modules.pn.Impl.PetriNet;
import pn.modules.pn.Impl.Place;
import pn.modules.pn.Impl.PnVertex;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.Vertex;

public class TJuncSplitter {
    public static ArrayList<PetriNet> structureDependantDecomposition(PetriNet pn, boolean exactNumber, int maxSynchronicTransition) {
        int maxTrans = pn.transition_pocet;
        ArrayList<PetriNet> decomposedPns = null;
        float ratio = 0.0f;
        int numSubPns = 1;
        int min = 1;
        if (exactNumber) {
            min = maxSynchronicTransition;
        }
        int i = min;
        while (i <= maxSynchronicTransition) {
            BitSet syncTrans = new BitSet(maxTrans);
            int j = 0;
            while (j < i) {
                syncTrans.set(j);
                ++j;
            }
            do {
                ArrayList<PetriNet> tempDecomposedPns = new ArrayList<PetriNet>();
                float tempRatio = TJuncSplitter.decomposeOnTransitions(pn, syncTrans, tempDecomposedPns);
                if (ModuleImpl.isDebug) {
                    System.out.println("Ratio:" + tempRatio + " Subnet count:" + tempDecomposedPns.size());
                }
                if (tempDecomposedPns.size() > numSubPns) {
                    decomposedPns = tempDecomposedPns;
                    ratio = tempRatio;
                    numSubPns = tempDecomposedPns.size();
                    continue;
                }
                if (tempDecomposedPns.size() != numSubPns || numSubPns == 1 || !(tempRatio > ratio)) continue;
                ratio = tempRatio;
                decomposedPns = tempDecomposedPns;
            } while (TJuncSplitter.nextMask(syncTrans, maxTrans, i));
            if (numSubPns > 1) break;
            ++i;
        }
        if (decomposedPns != null) {
            int j = 0;
            for (PetriNet decPn : decomposedPns) {
                decPn.compileArrays();
                decPn.initprepost();
                decPn.setName("Decomposed subnet " + ++j + " of " + pn.getName());
            }
        }
        return decomposedPns;
    }

    public static ArrayList<PetriNet> markingDependantDecomposition(PetriNet pn) {
        ArrayList<PetriNet> decomposedPns = null;
        ArrayList<Place> placesWithMarking = new ArrayList<Place>();
        ArrayList<Place> placesWithoutMarking = new ArrayList<Place>();
        Place[] placeArray = pn.place;
        int n = pn.place.length;
        int n2 = 0;
        while (n2 < n) {
            Place p = placeArray[n2];
            if (p.marking > 0) {
                placesWithMarking.add(p);
            } else {
                placesWithoutMarking.add(p);
            }
            ++n2;
        }
        if (placesWithoutMarking.size() == 0) {
            return null;
        }
        if (placesWithMarking.size() == 0) {
            return null;
        }
        decomposedPns = new ArrayList<PetriNet>();
        Place place = null;
        do {
            place = null;
            for (Place p : placesWithMarking) {
                if (p.dek != -1) continue;
                place = p;
            }
            if (place == null) continue;
            PetriNet newPn = new PetriNet();
            TJuncSplitter.createSubnetFromPlace(pn, newPn, place, null, placesWithMarking);
            int i = 0;
            while (i < newPn.transition_pocet) {
                if (newPn.transition[i].getArcs().size() != pn.transition[newPn.transition[i].dek].getArcs().size()) {
                    newPn.transition[i].setSynchronic(true);
                }
                ++i;
            }
            decomposedPns.add(newPn);
        } while (place != null);
        Object[] objectArray = pn.place;
        int n3 = pn.place.length;
        int i = 0;
        while (i < n3) {
            Place p = objectArray[i];
            p.dek = -1;
            ++i;
        }
        objectArray = pn.transition;
        n3 = pn.transition.length;
        i = 0;
        while (i < n3) {
            PnVertex t = objectArray[i];
            ((Transition)t).dek = -1;
            ++i;
        }
        objectArray = pn.arc;
        n3 = pn.arc.length;
        i = 0;
        while (i < n3) {
            Object a = objectArray[i];
            ((Arc)a).dek = 0;
            ++i;
        }
        do {
            place = null;
            for (Place p : placesWithoutMarking) {
                if (p.dek != -1) continue;
                place = p;
                break;
            }
            if (place == null) continue;
            PetriNet newPn = new PetriNet();
            TJuncSplitter.createSubnetFromPlace(pn, newPn, place, null, placesWithoutMarking);
            i = 0;
            while (i < newPn.transition_pocet) {
                if (newPn.transition[i].getArcs().size() != pn.transition[newPn.transition[i].dek].getArcs().size()) {
                    newPn.transition[i].setSynchronic(true);
                }
                ++i;
            }
            decomposedPns.add(newPn);
        } while (place != null);
        for (PetriNet tpn : decomposedPns) {
            tpn.compileArrays();
            tpn.initprepost();
        }
        objectArray = pn.place;
        n3 = pn.place.length;
        int n4 = 0;
        while (n4 < n3) {
            Object p = objectArray[n4];
            ((Place)p).dek = -1;
            ++n4;
        }
        objectArray = pn.transition;
        n3 = pn.transition.length;
        n4 = 0;
        while (n4 < n3) {
            Object t = objectArray[n4];
            ((Transition)t).dek = -1;
            ++n4;
        }
        objectArray = pn.arc;
        n3 = pn.arc.length;
        n4 = 0;
        while (n4 < n3) {
            Object a = objectArray[n4];
            ((Arc)a).dek = 0;
            ++n4;
        }
        return decomposedPns;
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<PetriNet> omegalizationDependantDecomposition(PetriNet pn, MwAutomaton mw) {
        void var7_39;
        void var7_37;
        void var7_35;
        void var7_29;
        void var7_27;
        void var7_25;
        ArrayList<PetriNet> decomposedPns = null;
        ArrayList<Place> placesWithOmegalization = new ArrayList<Place>();
        ArrayList<Place> placesWithoutOmegalization = new ArrayList<Place>();
        int i = 0;
        while (i < pn.place_pocet) {
            boolean omegalization = false;
            for (Vertex vertex : mw.getStates()) {
                if (vertex.getOmegaId() == 0 || vertex.getStateVectorAt(i) != 200000000) continue;
                omegalization = true;
            }
            if (omegalization) {
                placesWithOmegalization.add(pn.place[i]);
            } else {
                placesWithoutOmegalization.add(pn.place[i]);
            }
            ++i;
        }
        if (placesWithOmegalization.size() == 0) {
            return null;
        }
        if (placesWithoutOmegalization.size() == 0) {
            return null;
        }
        decomposedPns = new ArrayList<PetriNet>();
        Place place = null;
        do {
            void var7_23;
            place = null;
            for (Place p : placesWithOmegalization) {
                if (p.dek != -1) continue;
                place = p;
            }
            if (place == null) continue;
            PetriNet newPn = new PetriNet();
            TJuncSplitter.createSubnetFromPlace(pn, newPn, place, null, placesWithOmegalization);
            boolean bl = false;
            while (var7_23 < newPn.transition_pocet) {
                if (newPn.transition[var7_23].getArcs().size() != pn.transition[newPn.transition[var7_23].dek].getArcs().size()) {
                    newPn.transition[var7_23].setSynchronic(true);
                }
                ++var7_23;
            }
            decomposedPns.add(newPn);
        } while (place != null);
        Object[] objectArray = pn.place;
        int n = pn.place.length;
        boolean bl = false;
        while (var7_25 < n) {
            Place p = objectArray[var7_25];
            p.dek = -1;
            ++var7_25;
        }
        objectArray = pn.transition;
        n = pn.transition.length;
        boolean n2 = false;
        while (var7_27 < n) {
            PnVertex t = objectArray[var7_27];
            ((Transition)t).dek = -1;
            ++var7_27;
        }
        objectArray = pn.arc;
        n = pn.arc.length;
        boolean bl2 = false;
        while (var7_29 < n) {
            Object a = objectArray[var7_29];
            ((Arc)a).dek = 0;
            ++var7_29;
        }
        do {
            void var7_32;
            place = null;
            for (Place p : placesWithoutOmegalization) {
                if (p.dek != -1) continue;
                place = p;
                break;
            }
            if (place == null) continue;
            PetriNet newPn = new PetriNet();
            TJuncSplitter.createSubnetFromPlace(pn, newPn, place, null, placesWithoutOmegalization);
            boolean bl3 = false;
            while (var7_32 < newPn.transition_pocet) {
                if (newPn.transition[var7_32].getArcs().size() != pn.transition[newPn.transition[var7_32].dek].getArcs().size()) {
                    newPn.transition[var7_32].setSynchronic(true);
                }
                ++var7_32;
            }
            decomposedPns.add(newPn);
        } while (place != null);
        for (PetriNet tpn : decomposedPns) {
            tpn.compileArrays();
            tpn.initprepost();
        }
        objectArray = pn.place;
        n = pn.place.length;
        boolean bl4 = false;
        while (var7_35 < n) {
            Object p = objectArray[var7_35];
            ((Place)p).dek = -1;
            ++var7_35;
        }
        objectArray = pn.transition;
        n = pn.transition.length;
        boolean bl5 = false;
        while (var7_37 < n) {
            Object t = objectArray[var7_37];
            ((Transition)t).dek = -1;
            ++var7_37;
        }
        objectArray = pn.arc;
        n = pn.arc.length;
        boolean bl6 = false;
        while (var7_39 < n) {
            Object a = objectArray[var7_39];
            ((Arc)a).dek = 0;
            ++var7_39;
        }
        return decomposedPns;
    }

    public static ArrayList<PetriNet> customDecompostion(PetriNet pn) {
        ArrayList<PetriNet> decomposedPns = null;
        ArrayList placesIn = new ArrayList();
        int found = 0;
        int group = -1;
        ArrayList<Place> actual = null;
        do {
            found = 0;
            group = -1;
            Place[] placeArray = pn.place;
            int n = pn.place.length;
            int n2 = 0;
            while (n2 < n) {
                Place p = placeArray[n2];
                if (p.dek != -1) {
                    if (group != -1) {
                        if (group == p.dek) {
                            actual.add(p);
                            p.dek = -1;
                            ++found;
                        }
                    } else {
                        group = p.dek;
                        p.dek = -1;
                        ++found;
                        actual = new ArrayList<Place>();
                        actual.add(p);
                    }
                }
                ++n2;
            }
            if (found <= 0) continue;
            placesIn.add(actual);
        } while (found > 0);
        if (placesIn.size() == 0) {
            return null;
        }
        decomposedPns = new ArrayList<PetriNet>();
        Place place = null;
        for (ArrayList arrayList : placesIn) {
            do {
                place = null;
                for (Place p : arrayList) {
                    if (p.dek != -1) continue;
                    place = p;
                }
                if (place == null) continue;
                PetriNet newPn = new PetriNet();
                TJuncSplitter.createSubnetFromPlace(pn, newPn, place, null, arrayList);
                int i = 0;
                while (i < newPn.transition_pocet) {
                    if (newPn.transition[i].getArcs().size() != pn.transition[newPn.transition[i].dek].getArcs().size()) {
                        newPn.transition[i].setSynchronic(true);
                    }
                    ++i;
                }
                decomposedPns.add(newPn);
            } while (place != null);
            Object[] objectArray = pn.place;
            int n = pn.place.length;
            int n3 = 0;
            while (n3 < n) {
                Place p;
                p = objectArray[n3];
                p.dek = -1;
                ++n3;
            }
            objectArray = pn.transition;
            n = pn.transition.length;
            n3 = 0;
            while (n3 < n) {
                PnVertex t = objectArray[n3];
                ((Transition)t).dek = -1;
                ++n3;
            }
            objectArray = pn.arc;
            n = pn.arc.length;
            n3 = 0;
            while (n3 < n) {
                Object a = objectArray[n3];
                ((Arc)a).dek = 0;
                ++n3;
            }
        }
        for (PetriNet petriNet : decomposedPns) {
            petriNet.compileArrays();
            petriNet.initprepost();
        }
        Object[] objectArray = pn.place;
        int n = pn.place.length;
        int n4 = 0;
        while (n4 < n) {
            Place place2 = objectArray[n4];
            place2.dek = -1;
            ++n4;
        }
        objectArray = pn.transition;
        n = pn.transition.length;
        n4 = 0;
        while (n4 < n) {
            PnVertex pnVertex = objectArray[n4];
            ((Transition)pnVertex).dek = -1;
            ++n4;
        }
        objectArray = pn.arc;
        n = pn.arc.length;
        n4 = 0;
        while (n4 < n) {
            Object object = objectArray[n4];
            ((Arc)object).dek = 0;
            ++n4;
        }
        return decomposedPns;
    }

    private static void createSubnetFromPlace(PetriNet origPn, PetriNet newPn, PnVertex currVertex, PnVertex prevNewVertex, ArrayList<Place> placesGroup) {
        block15: {
            block16: {
                if (!(currVertex instanceof Place)) break block16;
                Place p = null;
                Place curr = (Place)currVertex;
                if (curr.dek == -1) {
                    p = newPn.addPlace(curr.name, curr.x, curr.y, curr.marking, curr.getId());
                    p.dek = curr.getArrayIndex();
                    curr.dek = p.getArrayIndex();
                    for (Arc a : curr.getArcs()) {
                        if (a.from == curr) {
                            TJuncSplitter.createSubnetFromPlace(origPn, newPn, a.to, p, placesGroup);
                            continue;
                        }
                        TJuncSplitter.createSubnetFromPlace(origPn, newPn, a.from, p, placesGroup);
                    }
                } else {
                    p = newPn.place[curr.dek];
                }
                if (prevNewVertex == null) break block15;
                for (Arc a : curr.getArcs()) {
                    if (a.dek == 1) continue;
                    if (a.from instanceof Transition && a.from.getArrayIndex() == prevNewVertex.getDek()) {
                        newPn.addArc(prevNewVertex, p);
                        a.dek = 1;
                    } else {
                        if (!(a.to instanceof Transition) || a.to.getArrayIndex() != prevNewVertex.getDek()) continue;
                        newPn.addArc(p, prevNewVertex);
                        a.dek = 1;
                    }
                    break block15;
                }
                break block15;
            }
            Transition t = null;
            Transition curr = (Transition)currVertex;
            if (curr.dek == -1) {
                t = newPn.addTransition(curr.name, curr.x, curr.y, false, curr.getId());
                t.dek = curr.getArrayIndex();
                curr.dek = t.getArrayIndex();
                for (Arc a : curr.getArcs()) {
                    if (a.from == curr) {
                        if (!placesGroup.contains(a.to)) continue;
                        TJuncSplitter.createSubnetFromPlace(origPn, newPn, a.to, t, placesGroup);
                        continue;
                    }
                    if (!placesGroup.contains(a.from)) continue;
                    TJuncSplitter.createSubnetFromPlace(origPn, newPn, a.from, t, placesGroup);
                }
            } else {
                t = newPn.transition[curr.dek];
            }
            if (prevNewVertex != null) {
                for (Arc a : curr.getArcs()) {
                    if (a.dek == 1) continue;
                    if (a.from instanceof Place && a.from.getArrayIndex() == prevNewVertex.getDek()) {
                        newPn.addArc(prevNewVertex, t);
                        a.dek = 1;
                    } else {
                        if (!(a.to instanceof Place) || a.to.getArrayIndex() != prevNewVertex.getDek()) continue;
                        newPn.addArc(t, prevNewVertex);
                        a.dek = 1;
                    }
                    break;
                }
            }
        }
    }

    private static boolean nextMask(BitSet mask, int numTransition, int synchronicTransition) {
        int lowest = mask.nextSetBit(0);
        if (lowest == numTransition - synchronicTransition) {
            return false;
        }
        ++lowest;
        while (lowest < mask.length() && mask.get(lowest)) {
            ++lowest;
        }
        mask.set(lowest);
        int i = lowest - 1;
        while (i >= 0) {
            mask.clear(i);
            --i;
        }
        int j = 0;
        while (mask.cardinality() < synchronicTransition) {
            mask.set(j);
            ++j;
        }
        return true;
    }

    private static float decomposeOnTransitions(PetriNet pn, BitSet transMask, ArrayList<PetriNet> decomposedPns) {
        int transBit = 0;
        int i = transMask.nextSetBit(0);
        while (i >= 0) {
            Transition currentTransition = pn.transition[i];
            int decNum = 0;
            for (Arc arc : currentTransition.getArcs()) {
                if (arc.dek == 0) {
                    Place np;
                    PetriNet newPn = new PetriNet();
                    ++decNum;
                    if (ModuleImpl.isDebug) {
                        System.out.println("Decomposition on transition:" + currentTransition.name + " decNum:" + decNum);
                    }
                    Transition nt = newPn.addTransition(currentTransition.name, currentTransition.x, currentTransition.y, true, currentTransition.getId());
                    currentTransition.setDek(nt.getArrayIndex());
                    decomposedPns.add(newPn);
                    arc.dek = decNum;
                    if (arc.pod == 0) {
                        np = newPn.addPlace(((Place)arc.from).name, ((Place)arc.from).x, ((Place)arc.from).y, ((Place)arc.from).marking, ((Place)arc.from).getId());
                        arc.from.setDek(np.getArrayIndex());
                        newPn.addArc(np, nt);
                        TJuncSplitter.createSubnet(newPn, arc.from, np, transMask, decNum);
                    } else {
                        np = newPn.addPlace(((Place)arc.to).name, ((Place)arc.to).x, ((Place)arc.to).y, ((Place)arc.to).marking, ((Place)arc.to).getId());
                        arc.to.setDek(np.getArrayIndex());
                        newPn.addArc(nt, np);
                        TJuncSplitter.createSubnet(newPn, arc.to, np, transMask, decNum);
                    }
                }
                int j = 0;
                while (j < pn.transition_pocet) {
                    if (transMask.get(j)) {
                        pn.transition[j].dek = -1;
                    }
                    ++j;
                }
            }
            ++transBit;
            i = transMask.nextSetBit(i + 1);
        }
        int j = 0;
        while (j < pn.arc.length) {
            pn.arc[j].dek = 0;
            ++j;
        }
        j = 0;
        while (j < pn.transition.length) {
            pn.transition[j].dek = -1;
            ++j;
        }
        j = 0;
        while (j < pn.place.length) {
            pn.place[j].dek = -1;
            ++j;
        }
        if (decomposedPns.size() > 0) {
            int min = Integer.MAX_VALUE;
            for (PetriNet decPn : decomposedPns) {
                if (ModuleImpl.isDebug) {
                    System.out.println("Places:" + decPn.place_pocet + " Transitions:" + decPn.transition_pocet + " Arcs:" + decPn.arc_pocet);
                }
                if (decPn.place_pocet >= min) continue;
                min = decPn.place_pocet;
            }
            if (min == 0) {
                return -1.0f;
            }
            return (float)min / (float)pn.place_pocet;
        }
        return -1.0f;
    }

    private static void createSubnet(PetriNet newPn, PnVertex currentVertex, PnVertex currentNew, BitSet synTransitions, int decNum) {
        if (currentVertex instanceof Transition) {
            boolean endInSynTrans = false;
            int i = synTransitions.nextSetBit(0);
            while (i >= 0) {
                if (i == currentVertex.getArrayIndex()) {
                    endInSynTrans = true;
                    break;
                }
                i = synTransitions.nextSetBit(i + 1);
            }
            if (endInSynTrans) {
                return;
            }
        }
        for (Arc arc : currentVertex.getArcs()) {
            PnVertex nv;
            boolean canAdd;
            if (arc.dek != 0) continue;
            arc.dek = decNum;
            if (arc.from == currentVertex) {
                boolean bl = canAdd = arc.to.getDek() == -1;
                if (arc.to instanceof Place) {
                    nv = canAdd ? newPn.addPlace(((Place)arc.to).name, ((Place)arc.to).x, ((Place)arc.to).y, ((Place)arc.to).marking, ((Place)arc.to).getId()) : newPn.place[arc.to.getDek()];
                    arc.to.setDek(nv.getArrayIndex());
                    if (arc.pod == 0) {
                        newPn.addArc(nv, currentNew);
                    } else {
                        newPn.addArc(currentNew, nv);
                    }
                } else {
                    nv = canAdd ? newPn.addTransition(((Transition)arc.to).name, ((Transition)arc.to).x, ((Transition)arc.to).y, synTransitions.get(arc.to.getArrayIndex()), ((Transition)arc.to).getId()) : newPn.transition[arc.to.getDek()];
                    arc.to.setDek(nv.getArrayIndex());
                    if (arc.pod == 0) {
                        newPn.addArc(currentNew, nv);
                    } else {
                        newPn.addArc(nv, currentNew);
                    }
                }
                TJuncSplitter.createSubnet(newPn, arc.to, nv, synTransitions, decNum);
                continue;
            }
            boolean bl = canAdd = arc.from.getDek() == -1;
            if (arc.from instanceof Place) {
                nv = canAdd ? newPn.addPlace(((Place)arc.from).name, ((Place)arc.from).x, ((Place)arc.from).y, ((Place)arc.from).marking, ((Place)arc.from).getId()) : newPn.place[arc.from.getDek()];
                arc.from.setDek(nv.getArrayIndex());
                if (arc.pod == 0) {
                    newPn.addArc(nv, currentNew);
                } else {
                    newPn.addArc(currentNew, nv);
                }
            } else {
                nv = canAdd ? newPn.addTransition(((Transition)arc.from).name, ((Transition)arc.from).x, ((Transition)arc.from).y, synTransitions.get(arc.from.getArrayIndex()), ((Transition)arc.from).getId()) : newPn.transition[arc.from.getDek()];
                arc.from.setDek(nv.getArrayIndex());
                if (arc.pod == 0) {
                    newPn.addArc(currentNew, nv);
                } else {
                    newPn.addArc(nv, currentNew);
                }
            }
            TJuncSplitter.createSubnet(newPn, arc.from, nv, synTransitions, decNum);
        }
    }
}

