/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.JOptionPane;
import pn.modules.pn.Impl.PetriNet;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.GraphicMw;
import pnmodulereachability.ListOfVertices;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.Vertex;
import pnmodulereachability.VstPath;
import pnmodulereachability.reachabilityException;

public class MwCreator {
    private boolean stop = false;
    private static final int NO_TRANSITION = -1;
    private int count_P;
    private int count_T;
    private int[][] preTbl;
    private int[][] transitions;
    private PetriNet pn;
    private StringBuffer console = new StringBuffer();
    private int numberOfGeneratedStates;
    private int stepNo;
    private GraphicMw graphicMw = new GraphicMw();
    private int[] initMarking;
    private boolean visualize = false;
    private boolean equivCheck = false;
    private int maxStateNumber = 1;
    private int statenumber = 0;
    VstPath path;
    private int totalProgress;
    private int actualProgress;

    public MwCreator(PetriNet pn, boolean visualize, boolean equivCheck, int maxStateNumber) {
        int j;
        this.count_P = pn.place_pocet;
        this.count_T = pn.transition_pocet;
        this.pn = pn;
        this.transitions = new int[this.count_T][this.count_P];
        this.preTbl = new int[this.count_T][this.count_P];
        this.initMarking = new int[this.count_P];
        int i = 0;
        while (i < this.count_P) {
            this.initMarking[i] = pn.place[i].marking;
            j = 0;
            while (j < this.count_T) {
                this.transitions[j][i] = pn.postt[i][j] - pn.pre[i][j];
                this.preTbl[j][i] = pn.pre[i][j];
                ++j;
            }
            ++i;
        }
        this.visualize = visualize;
        this.equivCheck = equivCheck;
        this.maxStateNumber = maxStateNumber;
        if (visualize) {
            this.console.append("Transitions:\n");
            i = 0;
            while (i < this.count_T) {
                this.console.append(String.valueOf(pn.transition[i].name.toString()) + " =\t(");
                j = 0;
                while (j < this.count_P) {
                    if (j > 0) {
                        this.console.append(",");
                    }
                    this.console.append("" + this.transitions[i][j]);
                    ++j;
                }
                this.console.append(")\t= (");
                j = 0;
                while (j < this.count_P) {
                    if (j > 0) {
                        this.console.append(",");
                    }
                    this.console.append(pn.postt[j][i] + "-" + this.preTbl[i][j]);
                    ++j;
                }
                this.console.append(")\n");
                ++i;
            }
        }
    }

    public MwAutomaton buildMw() throws reachabilityException {
        return this.buildMwInternal(null);
    }

    public MwAutomaton buildMw(ArrayList<Integer> examinedVector) throws reachabilityException {
        if (examinedVector == null) {
            return this.buildMwInternal(null);
        }
        int[] vector = new int[examinedVector.size()];
        int i = 0;
        while (i < examinedVector.size()) {
            vector[i] = examinedVector.get(i);
            ++i;
        }
        return this.buildMwInternal(vector);
    }

    private MwAutomaton buildMwInternal(int[] examinedVector) throws reachabilityException {
        this.stop = false;
        int loopCount = 1;
        int answer = -1;
        this.actualProgress = 0;
        this.totalProgress = -1;
        boolean partial = false;
        int omegaNumber = 0;
        this.path = new VstPath(this.pn, this.count_P, this.count_T);
        ListOfVertices createdVertices = new ListOfVertices();
        if (this.visualize) {
            this.getConsole().append("\n\nNDSQ:: Started\n\n");
            if (examinedVector != null) {
                this.getConsole().append("\nTrying to create partial Mw Automaton\n");
            }
        }
        this.statenumber = 0;
        int synchronicNum = 0;
        Transition[] transitionArray = this.pn.transition;
        int n = this.pn.transition.length;
        int n2 = 0;
        while (n2 < n) {
            Transition trans = transitionArray[n2];
            if (trans.isSynchronic()) {
                ++synchronicNum;
            }
            ++n2;
        }
        int[] synchronicTrans = null;
        if (synchronicNum > 0) {
            synchronicTrans = new int[synchronicNum];
        }
        int i = 0;
        while (i < synchronicNum) {
            synchronicTrans[i] = 0;
            ++i;
        }
        Vertex q = new Vertex(this.count_P, this.count_T, this.statenumber);
        q.setSynchronicTransitionFired(synchronicTrans);
        ++this.statenumber;
        if (!q.setStateVector(this.initMarking)) {
            throw new reachabilityException("New state vector not consistent with given vertex.");
        }
        Vertex root = q;
        this.setNoOfGeneratedStates(1);
        do {
            if (this.visualize) {
                this.getConsole().append("\n\n-------------------------------------------------------\nNDSQ." + loopCount + ". enter::\n ");
            }
            if (this.statenumber == this.maxStateNumber) {
                if (this.visualize) {
                    this.getConsole().append("\nNdsq aborted because too much (" + this.maxStateNumber + ") vertexes has been generated.");
                }
                throw new reachabilityException("Too much (" + this.maxStateNumber + ") vertexes has been generated.");
            }
            this.setStepNo(loopCount);
            int enbTransIndx = this.chooseEnabledTransition(q, true);
            if (enbTransIndx != -1) {
                Vertex qNew;
                if (this.visualize) {
                    this.getConsole().append(String.valueOf(q.toString()) + " [" + this.pn.transition[enbTransIndx].name.toString() + "> ");
                }
                if (q.getNext(enbTransIndx) != null) {
                    qNew = q.getNext(enbTransIndx);
                    this.path.addVertex(q);
                    if (examinedVector != null && q.getOmegaId() == 0 && q.covers(examinedVector)) {
                        partial = true;
                        break;
                    }
                    if (qNew.getOmegaId() == q.getOmegaId()) {
                        if (!qNew.hasSameOmegasAs(q)) {
                            throw new reachabilityException("Omega consistency check failed for " + q.toString() + " and " + qNew.toString());
                        }
                        q = qNew;
                    } else if (qNew.getOmegaId() < q.getOmegaId()) {
                        qNew.reomegalizeWrt(q);
                        switch (this.path.findSmallerOrEqualTo(qNew)) {
                            case 110: {
                                q = qNew;
                                break;
                            }
                            case 101: {
                                this.path.createEqualLoop(q, enbTransIndx, qNew, false);
                                q = this.path.removeLastVertex();
                                break;
                            }
                            case 111: {
                                this.path.createOmegaLoop(q, enbTransIndx, qNew, ++omegaNumber, false);
                                q = this.path.removeLastVertex();
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    qNew = this.fireTransition(q, enbTransIndx);
                    this.path.addVertex(q);
                    if (examinedVector != null && q.getOmegaId() == 0 && q.covers(examinedVector)) {
                        partial = true;
                        break;
                    }
                    switch (this.path.findSmallerOrEqualTo(qNew)) {
                        case 110: {
                            if (this.equivCheck) {
                                Vertex qEquiv = createdVertices.getEquivalentVertex(qNew);
                                if (qEquiv != null) {
                                    qNew = qEquiv;
                                } else {
                                    createdVertices.addVertex(qNew);
                                }
                            }
                            q.setNext(enbTransIndx, qNew);
                            q = qNew;
                            qNew = null;
                            break;
                        }
                        case 101: {
                            this.path.createEqualLoop(q, enbTransIndx, qNew, true);
                            q = this.path.removeLastVertex();
                            qNew = null;
                            break;
                        }
                        case 111: {
                            this.path.createOmegaLoop(q, enbTransIndx, qNew, ++omegaNumber, true);
                            q = this.path.removeLastVertex();
                            qNew = null;
                        }
                    }
                }
            } else {
                if (this.visualize && q != null) {
                    this.getConsole().append("No transition to fire in " + q.toString());
                }
                q = this.path.removeLastVertex();
            }
            if (this.visualize) {
                this.getConsole().append("\n\n------\nNDSQ." + loopCount + ":: Path after loop:");
                this.getConsole().append("\n path = " + this.path.toString());
                this.getConsole().append("\n\n------\nNDSQ." + loopCount + ":: VSG transition table after loop:\n");
                this.getConsole().append(this.getTransTableAsString(false, root));
                if (answer == -1 && this.getGraphicMw() != null) {
                    this.constructGMw(root);
                    float percent = (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
                    if ((double)percent < 0.1 && (answer = JOptionPane.showConfirmDialog(null, "There is less than 10% free memory ( " + (int)(percent * 100.0f) + "% free) available. Disabling Mw Automaton creation process visualization may provide more available memory.\nDo you wish to disable Mw Automaton Creation visualization?", "Less than 10% free memory", 0)) == 0) {
                        this.graphicMw = null;
                        this.console = new StringBuffer();
                        System.gc();
                        float percent2 = (float)Runtime.getRuntime().freeMemory() / (float)Runtime.getRuntime().totalMemory();
                        JOptionPane.showMessageDialog(null, "Free memory after disabling Mw Automaton creation visualisation: " + (int)(percent2 * 100.0f) + "%", "Provided memory", 1);
                    }
                }
            }
            ++loopCount;
            ++this.actualProgress;
        } while (!this.stop && q != null);
        MwAutomaton mw = new MwAutomaton(this.pn, root);
        mw.setPartial(partial);
        if (this.visualize) {
            this.getConsole().append("\n\n------\nNDSQ.MwAutomaton\n\nStates:\n" + mw.getStatesListAsString(false, true));
            this.getConsole().append("\n\nTrans.table:\n" + mw.getTransTableAsString(false));
        }
        mw.reduceAutomaton();
        mw.markSCC();
        if (this.visualize) {
            this.getConsole().append("\n\n\n------\nNDSQ.MwAutomaton after reduction \n\nStates:\n" + mw.getStatesListAsString(false, true));
            this.getConsole().append("\n\nTrans.table:\n" + mw.getTransTableAsString(false));
        }
        if (this.getGraphicMw() != null) {
            this.getGraphicMw().addGMwStep(mw);
            this.getGraphicMw().setPetriNet(this.pn);
            if (this.getGraphicMw().getMaxNumStates() > 200 && (answer = JOptionPane.showConfirmDialog(null, "Generated Mw Automaton has more than 200 states. Visualasation might be too complex.\nDo you wish to disable Mw Automaton visualisation?", "Mw Automaton visualisation too complex", 0)) == 0) {
                this.graphicMw = null;
            }
        }
        return mw;
    }

    private int chooseEnabledTransition(Vertex q, boolean omegalisEquivFirst) {
        int noOmegalisEqCandidate = -1;
        int i = 0;
        while (i < this.count_T) {
            if (!q.isCalculated(i)) {
                if (omegalisEquivFirst) {
                    byte enbl = q.enabled(this.preTbl[i], this.transitions[i]);
                    if (enbl == 1) {
                        if (noOmegalisEqCandidate == -1) {
                            noOmegalisEqCandidate = i;
                        }
                    } else {
                        if (enbl == 2) {
                            q.setAsCalculated(i);
                            return i;
                        }
                        q.setAsCalculated(i);
                    }
                } else {
                    q.setAsCalculated(i);
                    if (q.enabled(this.preTbl[i], this.transitions[i]) != 0) {
                        return i;
                    }
                }
            }
            ++i;
        }
        if (noOmegalisEqCandidate != -1) {
            q.setAsCalculated(noOmegalisEqCandidate);
        }
        return noOmegalisEqCandidate;
    }

    public int getTotal() {
        if (this.path == null) {
            return 1;
        }
        if (this.totalProgress == -1) {
            int total = 0;
            int i = 0;
            while (i < this.count_P) {
                total += this.initMarking[i];
                ++i;
            }
            this.totalProgress = (total = (int)Math.pow(total, this.count_T)) == 0 ? 1 : total;
        }
        return this.totalProgress;
    }

    public int getActual() {
        if (this.path == null) {
            return 0;
        }
        return this.actualProgress;
    }

    private Vertex fireTransition(Vertex q, int transIndex) throws reachabilityException {
        Vertex qNew = null;
        if (q.getNext(transIndex) != null) {
            throw new reachabilityException(String.valueOf(q.toString()) + " already has an offspring via t" + transIndex);
        }
        int[] synchronicTrans = null;
        if (q.getSynchronicTransitionFired() != null) {
            synchronicTrans = new int[q.getSynchronicTransitionFired().length];
            System.arraycopy(q.getSynchronicTransitionFired(), 0, synchronicTrans, 0, q.getSynchronicTransitionFired().length);
            if (this.pn.transition[transIndex].isSynchronic()) {
                int t = 0;
                int i = 0;
                while (i < this.pn.transition_pocet) {
                    if (i == transIndex) {
                        int n = t;
                        synchronicTrans[n] = synchronicTrans[n] + 1;
                        break;
                    }
                    if (this.pn.transition[i].isSynchronic()) {
                        ++t;
                    }
                    ++i;
                }
            }
        }
        qNew = new Vertex(this.count_P, this.count_T, this.statenumber);
        qNew.setSynchronicTransitionFired(synchronicTrans);
        this.setNoOfGeneratedStates(this.statenumber);
        ++this.statenumber;
        qNew.setOmegaId(q.getOmegaId());
        int[] firingRes = q.firingResult(this.transitions[transIndex]);
        int[] firingResTemp = new int[firingRes.length];
        System.arraycopy(firingRes, 0, firingResTemp, 0, firingRes.length);
        boolean omegaFound = false;
        int i = 0;
        while (i < firingResTemp.length) {
            if (firingResTemp[i] == 200000000) {
                firingResTemp[i] = q.getOmegaId() == 0 ? q.getStateVectorAt(i) : q.getFirstNonOmegalizedVector()[i];
                omegaFound = true;
            }
            ++i;
        }
        if (omegaFound) {
            qNew.setStateVector(firingResTemp);
        }
        if (!qNew.setStateVector(firingRes)) {
            throw new reachabilityException("Illegal firing in the state " + q.toString());
        }
        return qNew;
    }

    private void constructGMw(Vertex initState) {
        if (this.getGraphicMw() != null) {
            MwAutomaton mw = new MwAutomaton(this.pn, initState);
            mw.markSCC();
            this.getGraphicMw().addGMwStep(mw);
            this.getGraphicMw().setPetriNet(this.pn);
        }
    }

    private String getTransTableAsString(boolean inHtml, Vertex root) {
        Stack<Vertex> pom_stack = new Stack<Vertex>();
        Stack<Vertex> kontr_stack = new Stack<Vertex>();
        Stack<Vertex> helping = new Stack<Vertex>();
        StringBuffer sb_tab = new StringBuffer();
        int j = 0;
        Vertex pom_vert = root;
        pom_stack.push(pom_vert);
        kontr_stack.push(pom_vert);
        if (inHtml) {
            sb_tab.append("<table border='1'><tr><td>&nbsp;");
        } else {
            sb_tab.append("\n\t| ");
        }
        int i = 0;
        while (i < this.count_T) {
            if (inHtml) {
                sb_tab.append("<th>" + this.pn.transition[i].name.toString());
            } else {
                sb_tab.append(String.valueOf(this.pn.transition[i].name.toString()) + "\t| ");
            }
            ++i;
        }
        if (inHtml) {
            sb_tab.append("</tr>");
        }
        while (!pom_stack.empty()) {
            ++j;
            sb_tab.append(pom_vert.autMwGetTransTableRowAsString(inHtml));
            i = 0;
            while (i < this.count_T) {
                if (pom_vert.getNext(i) != null) {
                    boolean ok = true;
                    helping.clear();
                    while (!kontr_stack.empty()) {
                        Vertex kontr_vert = (Vertex)kontr_stack.pop();
                        helping.push(kontr_vert);
                        if (kontr_vert.getVertId() != pom_vert.getNext(i).getVertId()) continue;
                        ok = false;
                    }
                    while (!helping.empty()) {
                        kontr_stack.push((Vertex)helping.pop());
                    }
                    if (ok) {
                        kontr_stack.push(pom_vert.getNext(i));
                        pom_stack.push(pom_vert.getNext(i));
                    }
                }
                ++i;
            }
            pom_vert = (Vertex)pom_stack.pop();
        }
        if (inHtml) {
            sb_tab.append("</table>");
        } else {
            sb_tab.append("\n");
        }
        return sb_tab.toString();
    }

    private void setNoOfGeneratedStates(int n) {
        this.numberOfGeneratedStates = n;
    }

    public int getNoOfGeneratedStates() {
        return this.numberOfGeneratedStates;
    }

    public int getStepNo() {
        return this.stepNo;
    }

    private void setStepNo(int stepNo) {
        this.stepNo = stepNo;
    }

    public GraphicMw getGraphicMw() {
        return this.graphicMw;
    }

    public StringBuffer getConsole() {
        return this.console;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStop() {
        return this.stop;
    }
}

