/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Stack;
import org.w3c.dom.Element;
import pn.ModuleImpl;
import pn.modules.pn.IArc;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;
import pn.modules.pn.Impl.PetriNet;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.Loop;
import pnmodulereachability.Vertex;
import pnmodulereachability.VstPath;
import pnmodulereachability.reachabilityException;

public class MwAutomaton {
    private long loopCouter;
    private boolean stop = false;
    private long teoreticalLoopNum = -1L;
    private PetriNet pn;
    private int noOfTr = 0;
    private int maxOmegaId;
    private List<Vertex> states;
    private List<Vertex[]> transTable;
    private List<Loop> simpleLoops;
    private boolean partial = false;
    private boolean finished = false;
    private Vertex root = null;
    private int gSccindex;
    private Stack<Vertex> gSccStack;
    private int gSccSetIndex;

    public MwAutomaton(PetriNet pn, PetriNet original) {
        this.states = new ArrayList<Vertex>();
        this.transTable = new ArrayList<Vertex[]>();
        this.pn = pn;
        this.partial = false;
        int j = 0;
        this.noOfTr = original.getTransitions().size();
        for (IPlace p : pn.getPlaces()) {
            Object id;
            Vertex v = new Vertex(original.getPlaces().size(), original.getTransitions().size(), Integer.parseInt(p.getName().substring(1)));
            if (this.root == null) {
                this.root = v;
            }
            String[] minimal = null;
            if (p.getId().contains("#")) {
                id = p.getId().split("#")[0];
                minimal = p.getId().split("#")[1].replaceAll("\\[", "").replaceAll("\\]", "").split(",");
            } else {
                id = p.getId();
            }
            String[] str = ((String)id).replaceAll("\\(", "").replaceAll("\\)", "").split(",");
            int[] statevec = new int[str.length];
            int i = 0;
            while (i < str.length) {
                if (str[i].compareTo("w") == 0) {
                    statevec[i] = 200000000;
                    ++this.maxOmegaId;
                    v.setOmegaId(this.maxOmegaId);
                } else {
                    statevec[i] = Integer.parseInt(str[i]);
                }
                ++i;
            }
            if (minimal != null) {
                int[] temp = new int[minimal.length];
                int i2 = 0;
                while (i2 < minimal.length) {
                    temp[i2] = Integer.parseInt(minimal[i2].trim());
                    ++i2;
                }
                v.setStateVector(temp);
            }
            v.setStateVector(statevec);
            this.states.add(v);
            this.transTable.add(new Vertex[original.getTransitions().size()]);
            ++j;
        }
        block3: for (IArc a : pn.getArcs()) {
            if (!(a.getStartingVertex() instanceof ITransition)) continue;
            for (IArc a2 : pn.getArcs()) {
                if (a2.getEndingVertex() != a.getStartingVertex()) continue;
                int x = 0;
                int k = 0;
                while (k < original.getTransitions().size()) {
                    if (original.getTransitions().get(k).getName().compareTo(pn.getTransitions().get(pn.getTransitions().indexOf(a2.getEndingVertex())).getName()) == 0) {
                        x = k;
                        break;
                    }
                    ++k;
                }
                this.transTable.get((int)pn.getPlaces().indexOf((Object)a2.getStartingVertex()))[x] = this.states.get(pn.getPlaces().indexOf(a.getEndingVertex()));
                continue block3;
            }
        }
        j = 0;
        for (Vertex[] va : this.transTable) {
            int i = 0;
            Vertex[] vertexArray = va;
            int k = va.length;
            int x = 0;
            while (x < k) {
                Vertex v = vertexArray[x];
                if (v != null) {
                    this.states.get(j).setNext(i, v);
                }
                ++i;
                ++x;
            }
            ++j;
        }
        Element e = (Element)((Properties)pn.getAdditionalData()).get("mwAutomaton");
        if (e.getElementsByTagName("simpleLoops").getLength() > 0) {
            this.simpleLoops = new ArrayList<Loop>();
            e = (Element)e.getElementsByTagName("simpleLoops").item(0);
            int i = 0;
            while (i < e.getElementsByTagName("loop").getLength()) {
                Element sl = (Element)e.getElementsByTagName("loop").item(i);
                String loop = sl.getAttribute("data");
                String stateId = sl.getAttribute("stateId");
                Loop l = new Loop(original, loop, stateId);
                this.simpleLoops.add(l);
                ++i;
            }
        }
        this.markSCC();
    }

    public MwAutomaton(PetriNet pn, Vertex root) {
        this.partial = false;
        if (pn == null || root == null) {
            return;
        }
        this.pn = pn;
        this.noOfTr = pn.transition_pocet;
        this.maxOmegaId = root.getOmegaId();
        this.states = new ArrayList<Vertex>();
        int actPos = 0;
        this.states.add(root);
        this.root = root;
        Vertex actVertex = root;
        do {
            actVertex = this.states.get(actPos);
            int i = 0;
            while (i < this.noOfTr) {
                if (actVertex.getNext(i) != null && !this.states.contains(actVertex.getNext(i))) {
                    if (actVertex.getNext(i).getOmegaId() > this.maxOmegaId) {
                        this.maxOmegaId = actVertex.getNext(i).getOmegaId();
                    }
                    this.states.add(actVertex.getNext(i));
                }
                ++i;
            }
        } while (++actPos < this.states.size());
        int noOfSt = this.states.size();
        this.transTable = new ArrayList<Vertex[]>();
        int i = 0;
        while (i < noOfSt) {
            this.transTable.add(this.states.get(i).getWholeNext());
            ++i;
        }
    }

    public int[] getVertexTransitionExecution(Vertex v) {
        int[] result = new int[this.pn.transition_pocet];
        int i = 0;
        while (i < result.length) {
            result[i] = 0;
            ++i;
        }
        return result;
    }

    public void fillPathsToRoot(Vertex v, ArrayList<ArrayList<Vertex>> paths, ArrayList<Vertex> actual) {
        if (actual == null) {
            actual = new ArrayList();
        }
        if (!actual.contains(v)) {
            if (this.root == v) {
                actual.add(v);
                int[] pathval = this.getPathVectorRepresentation(actual);
                boolean unique = true;
                for (ArrayList<Vertex> p : paths) {
                    int[] pval = this.getPathVectorRepresentation(p);
                    if (!Arrays.equals(pval, pathval)) continue;
                    unique = false;
                    break;
                }
                if (unique) {
                    paths.add(actual);
                }
                return;
            }
            actual.add(v);
            for (Vertex vv : this.getStates()) {
                Vertex[] vertexArray = vv.getWholeNext();
                int n = vertexArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Vertex vvv = vertexArray[n2];
                    if (vvv == v) {
                        this.fillPathsToRoot(vv, paths, (ArrayList)actual.clone());
                    }
                    ++n2;
                }
            }
            return;
        }
    }

    public int[] getPathVectorRepresentation(ArrayList<Vertex> path) {
        int[] res = new int[this.pn.place_pocet];
        Arrays.fill(res, 0);
        int i = path.size() - 2;
        while (i >= 0) {
            int k = 0;
            while (k < path.get(i).getWholeNext().length) {
                Vertex v = path.get(i + 1).getWholeNext()[k];
                if (v == path.get(i)) {
                    int j = 0;
                    while (j < this.pn.place_pocet) {
                        int n = j;
                        res[n] = res[n] + (this.pn.postt[j][k % this.pn.transition_pocet] - this.pn.pre[j][k % this.pn.transition_pocet]);
                        ++j;
                    }
                    break;
                }
                ++k;
            }
            --i;
        }
        return res;
    }

    public Vertex getRoot() {
        return this.root;
    }

    public int[][] getLoopMatrix(Vertex covering, ArrayList<Loop> loops, ArrayList<Vertex> pathToRoot) {
        int[][] matrix = null;
        int numLoops = 0;
        block0: for (Loop l : this.simpleLoops) {
            if (l.getLoopStates().get(covering.getVertId())) {
                ++numLoops;
                loops.add(l);
                continue;
            }
            if (pathToRoot != null) {
                block1: for (Vertex v : pathToRoot) {
                    if (l.getLoopStates().get(v.getVertId())) {
                        ++numLoops;
                        loops.add(l);
                        continue block0;
                    }
                    for (Vertex vv : this.getStates()) {
                        if (vv.getSccId() != v.getSccId() || !l.getLoopStates().get(vv.getVertId())) continue;
                        ++numLoops;
                        loops.add(l);
                        continue block1;
                    }
                }
                continue;
            }
            for (Vertex v : this.getStates()) {
                if (v.getSccId() != covering.getSccId() || !l.getLoopStates().get(v.getVertId())) continue;
                ++numLoops;
                loops.add(l);
                continue block0;
            }
        }
        matrix = new int[this.pn.place_pocet][numLoops];
        numLoops = 0;
        for (Loop l : loops) {
            int i = 0;
            while (i < this.pn.place_pocet) {
                matrix[i][numLoops] = 0;
                ++i;
            }
            i = l.nextSetBit(0);
            while (i >= 0) {
                int j = 0;
                while (j < this.pn.place_pocet) {
                    int[] nArray = matrix[j];
                    int n = numLoops;
                    nArray[n] = nArray[n] + (this.pn.postt[j][i % this.pn.transition_pocet] - this.pn.pre[j][i % this.pn.transition_pocet]);
                    ++j;
                }
                i = l.nextSetBit(i + 1);
            }
            ++numLoops;
        }
        return matrix;
    }

    public int getNumberOfTransitions() {
        int total = 0;
        int i = 0;
        while (i < this.states.size()) {
            int j = 0;
            while (j < this.noOfTr) {
                if (this.transTable.get(i)[j] != null) {
                    ++total;
                }
                ++j;
            }
            ++i;
        }
        return total;
    }

    public long getProgress() {
        return this.loopCouter;
    }

    public void reduceAutomaton() {
        if (this.states.size() < 2) {
            return;
        }
        int qIndex = 0;
        int statesSize = this.states.size();
        do {
            Vertex q = this.states.get(qIndex);
            ArrayList<Vertex> equivToQ = new ArrayList<Vertex>();
            int i = qIndex + 1;
            while (i < statesSize) {
                if (q.isEquivalentTo(this.states.get(i), false)) {
                    equivToQ.add(this.states.get(i));
                }
                ++i;
            }
            if (equivToQ.isEmpty()) continue;
            i = 0;
            while (i < this.transTable.size()) {
                int j = 0;
                while (j < this.noOfTr) {
                    if (equivToQ.contains(this.transTable.get(i)[j])) {
                        this.transTable.get((int)i)[j] = q;
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < equivToQ.size()) {
                int stateIndex = this.states.indexOf(equivToQ.get(i));
                this.states.remove(stateIndex);
                this.transTable.remove(stateIndex);
                ++i;
            }
            statesSize = this.states.size();
            equivToQ = null;
        } while (++qIndex < statesSize);
    }

    public void findSimpleLoops() throws reachabilityException {
        this.stop = false;
        ArrayList<Loop> loopsFound = new ArrayList<Loop>();
        int markCalc = -1;
        int markVisit = -1;
        int nextTr = -1;
        int qNewPos = -1;
        int i = 0;
        this.loopCouter = 1L;
        int noOfSt = this.states.size();
        if (noOfSt == 0) {
            return;
        }
        i = 0;
        while (i < noOfSt) {
            this.states.get(i).resetCalculated(false);
            this.states.get(i).initResetVisited(false);
            ++i;
        }
        VstPath path = new VstPath(this.pn, this.pn.place_pocet, this.noOfTr, this.states.get(0), true);
        long last = 0L;
        Vertex q = path.getLastVertex();
        while (!this.stop) {
            long now;
            nextTr = q.getNextTr(true);
            if (nextTr != -1) {
                Vertex qNew = q.getNext(nextTr);
                q.setAsVisited(nextTr);
                markVisit = path.size() - 1;
                if (!q.isCalculated(nextTr)) {
                    q.setAsCalculated(nextTr);
                    markCalc = markVisit;
                }
                if ((qNewPos = path.getFirstVertexPosition(qNew)) == -1) {
                    path.add(nextTr, this.noOfTr * this.states.indexOf(qNew) + nextTr, qNew);
                } else if (qNewPos <= markCalc) {
                    loopsFound.add(path.createLoop(qNewPos, this.noOfTr * this.states.indexOf(qNew) + nextTr));
                    ++this.loopCouter;
                }
            } else if (markVisit > -1 && markVisit < path.size() - 1) {
                q.initResetVisited(true);
                markVisit = path.size() - 1;
            } else {
                if (markVisit == path.size() - 1) {
                    markVisit = -1;
                }
                if (markCalc == path.size() - 1) {
                    markCalc = -1;
                }
                path.removeLastVertex();
                path.removeLastTr();
            }
            if (ModuleImpl.isDebug && (now = System.nanoTime()) > last + 1000000000L) {
                System.out.println(this.loopCouter);
                last = now;
            }
            if ((q = path.getLastVertex()) != null) continue;
        }
        if (ModuleImpl.isDebug) {
            System.out.println("Finished loop search:" + this.loopCouter);
        }
        this.simpleLoops = loopsFound;
    }

    public String getStatesListAsString(boolean inHtml, boolean addNoOfStates) {
        int noOfSt = this.states.size();
        StringBuilder sl = new StringBuilder("");
        int i = 0;
        while (i < noOfSt) {
            if (inHtml) {
                sl.append(this.states.get(i).toHtmlString());
            } else {
                sl.append(this.states.get(i).toString());
                sl.append("\n");
            }
            ++i;
        }
        if (addNoOfStates) {
            if (inHtml) {
                sl.append(" <BR> ");
            }
            sl.append("\n(" + this.states.size() + " states)");
        }
        return sl.toString();
    }

    public String getTransTableAsString(boolean inHtml) {
        int noOfSt = this.states.size();
        StringBuilder tt = new StringBuilder("");
        if (inHtml) {
            tt.append("<table border='1'><tr><td>&nbsp;");
        } else {
            tt.append("\n\t| ");
        }
        int i = 0;
        while (i < this.noOfTr) {
            if (inHtml) {
                tt.append("<th>" + this.pn.transition[i].name.toString());
            } else {
                tt.append(String.valueOf(this.pn.transition[i].name.toString()) + "\t| ");
            }
            ++i;
        }
        if (inHtml) {
            tt.append("</tr>");
        }
        i = 0;
        while (i < noOfSt) {
            if (inHtml) {
                tt.append("<tr><th>Q" + this.states.get(i).getVertId());
            } else {
                tt.append("\nQ" + this.states.get(i).getVertId() + "/" + this.states.get(i).getOmegaId() + "\t| ");
            }
            int j = 0;
            while (j < this.noOfTr) {
                if (this.transTable.get(i)[j] != null) {
                    if (inHtml) {
                        tt.append("<td>Q" + this.transTable.get(i)[j].getVertId());
                    } else {
                        tt.append("Q" + this.transTable.get(i)[j].getVertId() + "/" + this.transTable.get(i)[j].getOmegaId() + "\t| ");
                    }
                } else if (inHtml) {
                    tt.append("<td>&nbsp;");
                } else {
                    tt.append("\t| ");
                }
                ++j;
            }
            ++i;
        }
        if (inHtml) {
            tt.append("</table>");
        } else {
            tt.append("\n");
        }
        return tt.toString();
    }

    public List<Vertex> getStates() {
        return this.states;
    }

    public List<Vertex[]> getTransTable() {
        return this.transTable;
    }

    public PetriNet getPn() {
        return this.pn;
    }

    public int getNoOfTr() {
        return this.noOfTr;
    }

    public void setNoOfTr(int noOfTr) {
        this.noOfTr = noOfTr;
    }

    public boolean hasMacroStates() {
        return this.maxOmegaId > 0;
    }

    public Vertex getCovering(int[] vector) {
        ListIterator<Vertex> it = this.states.listIterator(0);
        while (it.hasNext()) {
            Vertex q = it.next();
            if (!q.covers(vector)) continue;
            return q;
        }
        return null;
    }

    public String getLoopsReportAsString(boolean inHtml) {
        String lend;
        String lmiddle;
        String lbegin;
        if (this.simpleLoops == null) {
            return "";
        }
        StringBuilder rep = new StringBuilder("");
        StringBuilder lnw = new StringBuilder("");
        if (inHtml) {
            lbegin = "<tr><td><b>L";
            lmiddle = "</b></td><td> ";
            lend = " </td></tr> ";
        } else {
            lbegin = " L";
            lmiddle = "\t ";
            lend = "\n";
        }
        ListIterator<Loop> it = this.simpleLoops.listIterator(0);
        int lNo = 0;
        while (it.hasNext()) {
            Loop l = it.next();
            lnw.append(String.valueOf(lbegin) + lNo + lmiddle + l.toString() + lend);
            ++lNo;
        }
        rep.append(String.valueOf(this.simpleLoops.size()) + " Simple loops found:");
        if (inHtml) {
            rep.append("<br> <table border='1'>");
        } else {
            rep.append("\n");
        }
        rep.append((CharSequence)lnw);
        if (inHtml) {
            rep.append("</table>");
        }
        return rep.toString();
    }

    public void setSimpleLoops(List<Loop> simpleLoops) {
        this.simpleLoops = simpleLoops;
    }

    public List<Loop> getSimpleLoops() {
        return this.simpleLoops;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public void stop() {
        this.stop = true;
    }

    public boolean isStop() {
        return this.stop;
    }

    public long getTeoreticalLoopNum() {
        if (this.teoreticalLoopNum > 0L) {
            return this.teoreticalLoopNum;
        }
        long cycles = 0L;
        if (this.getStates().size() == 1) {
            this.teoreticalLoopNum = this.getStates().size() * this.getNumberOfTransitions();
            return this.teoreticalLoopNum;
        }
        cycles = (long)Math.pow(2.0, this.states.size());
        this.teoreticalLoopNum = cycles *= (long)this.getNumberOfTransitions();
        return cycles;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public ArrayList<int[]> getSynTransFiring(Vertex v) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        ArrayList<int[]> tempresult = new ArrayList<int[]>();
        for (Vertex vv : this.states) {
            vv.seen = false;
        }
        this.synTransFiring(v, this.states.get(0), tempresult, null);
        int numSynTrans = 0;
        Transition[] transitionArray = this.getPn().transition;
        int n = this.getPn().transition.length;
        int n2 = 0;
        while (n2 < n) {
            Transition t = transitionArray[n2];
            if (t.isSynchronic()) {
                ++numSynTrans;
            }
            ++n2;
        }
        for (int[] array : tempresult) {
            int j = 0;
            int[] res = new int[numSynTrans];
            int i = 0;
            while (i < this.getPn().transition_pocet) {
                if (this.getPn().transition[i].isSynchronic()) {
                    res[j] = array[i];
                    ++j;
                }
                ++i;
            }
            result.add(res);
        }
        for (Vertex vv : this.states) {
            vv.seen = false;
        }
        return result;
    }

    private void synTransFiring(Vertex v, Vertex first, ArrayList<int[]> result, int[] temp) {
        if (v == first) {
            result.add(temp);
            return;
        }
        v.seen = true;
        int i = -1;
        Vertex[] vertexArray = v.getWholeNext();
        int n = vertexArray.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex vv = vertexArray[n2];
            ++i;
            if (vv != null && !vv.seen) {
                int[] tmpArray = new int[v.getStateVectorLength()];
                if (temp != null) {
                    System.arraycopy(temp, 0, tmpArray, 0, v.getStateVectorLength());
                }
                int n3 = i;
                tmpArray[n3] = tmpArray[n3] + 1;
                this.synTransFiring(vv, first, result, tmpArray);
            }
            ++n2;
        }
    }

    public void setPn(PetriNet pn) {
        this.pn = pn;
    }

    public void markSCC() {
        this.gSccindex = 0;
        this.gSccStack = new Stack();
        for (Vertex v : this.states) {
            v.setSccId(-1);
            v.setSccTempIndex(-1);
            v.setInSccStack(false);
        }
        for (Vertex v : this.states) {
            if (v.getSccTempIndex() != -1) continue;
            this.Scc(v);
        }
        this.gSccSetIndex = 0;
    }

    private void Scc(Vertex v) {
        Vertex w;
        Vertex[] next;
        v.setSccTempIndex(this.gSccindex);
        v.setSccTempLowIndex(this.gSccindex);
        ++this.gSccindex;
        this.gSccStack.push(v);
        v.setInSccStack(true);
        Vertex[] vertexArray = next = v.getWholeNext();
        int n = next.length;
        int n2 = 0;
        while (n2 < n) {
            w = vertexArray[n2];
            if (w != null) {
                if (w.getSccTempIndex() == -1) {
                    this.Scc(w);
                    v.setSccTempLowIndex(Math.min(w.getSccTempLowIndex(), v.getSccTempLowIndex()));
                } else if (w.isInSccStack()) {
                    v.setSccTempLowIndex(Math.min(w.getSccTempIndex(), v.getSccTempLowIndex()));
                }
            }
            ++n2;
        }
        if (v.getSccTempLowIndex() == v.getSccTempIndex()) {
            w = null;
            do {
                w = this.gSccStack.pop();
                w.setSccId(this.gSccSetIndex);
                w.setInSccStack(false);
            } while (v != w);
            ++this.gSccSetIndex;
        }
    }
}

