/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.util.BitSet;
import pn.modules.pn.Impl.PetriNet;

public class Loop
extends BitSet {
    private static char[] hextable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private PetriNet pn;
    private BitSet states;

    public Loop(PetriNet pn, BitSet bs, BitSet states) {
        this.pn = pn;
        this.or(bs);
        this.states = states;
    }

    public Loop(PetriNet pn, String loop, String states) {
        int l;
        int bitcount;
        int num;
        int k;
        int j;
        StringBuffer part;
        this.pn = pn;
        this.states = new BitSet();
        int i = 0;
        while (i < states.length()) {
            part = new StringBuffer(states.substring(i, i + 8));
            part.reverse();
            j = 0;
            while (j < 8) {
                k = 0;
                while (k < 16) {
                    if (part.toString().charAt(j) == hextable[k]) {
                        num = k;
                        bitcount = Integer.bitCount(num);
                        l = 0;
                        while (l < bitcount) {
                            this.states.set(i * 8 + j * 4 + Integer.numberOfTrailingZeros(num));
                            num -= 1 << Integer.numberOfTrailingZeros(num);
                            ++l;
                        }
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            i += 8;
        }
        i = 0;
        while (i < loop.length()) {
            part = new StringBuffer(loop.substring(i, i + 8));
            part.reverse();
            j = 0;
            while (j < 8) {
                k = 0;
                while (k < 16) {
                    if (part.toString().charAt(j) == hextable[k]) {
                        num = k;
                        bitcount = Integer.bitCount(num);
                        l = 0;
                        while (l < bitcount) {
                            this.set(i * 8 + j * 4 + Integer.numberOfTrailingZeros(num));
                            num -= 1 << Integer.numberOfTrailingZeros(num);
                            ++l;
                        }
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            i += 8;
        }
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        int i = this.states.nextSetBit(0);
        while (i >= 0) {
            if (this.states.nextSetBit(0) == i) {
                str.append("Q" + Integer.toString(i));
            } else {
                str.append(", Q" + Integer.toString(i));
            }
            i = this.states.nextSetBit(i + 1);
        }
        str.append("}");
        str.append(" - {");
        i = this.nextSetBit(0);
        while (i >= 0) {
            if (this.nextSetBit(0) == i) {
                str.append(this.pn.transition[i % this.pn.transition_pocet].getName());
            } else {
                str.append(", " + this.pn.transition[i % this.pn.transition_pocet].getName());
            }
            i = this.nextSetBit(i + 1);
        }
        str.append("}");
        return str.toString();
    }

    public String toPNML() {
        return new StringBuffer("<loop stateId=\"" + this.statesToHex() + "\" data=\"" + this.toHex() + "\" />").toString();
    }

    public String toHex() {
        StringBuffer sb = new StringBuffer();
        int[] temp = new int[this.length() / 32 + (this.length() % 32 > 0 ? 1 : 0)];
        int i = 0;
        while (i < temp.length) {
            int j = 0;
            while (j < 32) {
                if (this.get(i * 32 + j)) {
                    int n = i;
                    temp[n] = temp[n] | 1 << j;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(temp.length);
        int[] nArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            sb.append(this.toHexString(num));
            ++n2;
        }
        return sb.toString();
    }

    public String statesToHex() {
        StringBuffer sb = new StringBuffer();
        int[] temp = new int[this.states.length() / 32 + (this.states.length() % 32 > 0 ? 1 : 0)];
        int i = 0;
        while (i < temp.length) {
            int j = 0;
            while (j < 32) {
                if (this.states.get(i * 32 + j)) {
                    int n = i;
                    temp[n] = temp[n] | 1 << j;
                }
                ++j;
            }
            ++i;
        }
        System.out.println(temp.length);
        int[] nArray = temp;
        int n = temp.length;
        int n2 = 0;
        while (n2 < n) {
            int num = nArray[n2];
            sb.append(this.toHexString(num));
            ++n2;
        }
        return sb.toString();
    }

    private String toHexString(int num) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 8) {
            sb.append(hextable[num & 0xF]);
            num >>= 4;
            ++i;
        }
        return sb.reverse().toString();
    }

    public BitSet getLoopStates() {
        return this.states;
    }
}

