/*
 * Decompiled with CFR 0.152.
 */
package pnmodulereachability;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.LineBorder;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pn.ModuleImpl;
import pn.modules.pn.Impl.PetriNet;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.Loop;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.Vertex;

public class GraphicMw
extends JPanel {
    private MwAutomaton mwToSave;
    private ArrayList<GMwStep> GMwSteps = new ArrayList();
    private int actualStep = -1;
    private JScrollBar vertical = new JScrollBar(1);
    private JScrollBar horizontal = new JScrollBar(0);
    private int scrollY = 0;
    private int scrollX = 0;
    private static final long serialVersionUID = -7943382636672763010L;
    private PetriNet petriNet;
    private JPanel buttonPanel;
    private JScrollBar scroll = new JScrollBar();
    private JCheckBox addToProject;
    private boolean partial;
    private static Color[] sccColors = new Color[]{Color.BLACK, Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};

    public ArrayList<GMwStep> getGMwSteps() {
        return this.GMwSteps;
    }

    public GraphicMw() {
        this.scroll.setOrientation(0);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(new LineBorder(Color.DARK_GRAY));
        this.setLayout(new BorderLayout());
        this.vertical.setBlockIncrement(1);
        this.vertical.setUnitIncrement(2);
        this.vertical.setMinimum(0);
        this.vertical.setMaximum(20);
        this.horizontal.setBlockIncrement(1);
        this.horizontal.setUnitIncrement(2);
        this.horizontal.setMinimum(-1000);
        this.horizontal.setValue(0);
        this.horizontal.setMaximum(1000);
        this.vertical.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                GraphicMw.this.scrollY = e.getValue();
                GraphicMw.this.repaint();
            }
        });
        this.horizontal.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                GraphicMw.this.scrollX = e.getValue();
                GraphicMw.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                GraphicMw.this.vertical.setValue(GraphicMw.this.vertical.getValue() + e.getWheelRotation() * 30);
            }
        });
        this.add((Component)this.vertical, "East");
        this.add((Component)this.horizontal, "South");
        this.scroll.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                GraphicMw.this.setActualStep(GraphicMw.this.scroll.getValue());
                GraphicMw.this.repaint();
            }
        });
        this.addToProject = new JCheckBox("Add Mw Automaton to project", false);
        this.buttonPanel.add(this.addToProject);
        this.buttonPanel.add(this.scroll);
        this.add((Component)this.buttonPanel, "North");
    }

    public boolean isAddToProject() {
        return this.addToProject.isSelected();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.partial) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.BLACK);
        }
        this.drawGMw(this.getActualStep(), g);
    }

    public void stepChanged() {
        if (this.getGMwSteps().size() > this.actualStep && this.actualStep >= 0) {
            this.vertical.setMaximum(this.getGMwSteps().get(this.actualStep).GMwStates.size() * 80 + 160 - this.getHeight());
        }
        if (this.vertical.getMaximum() < 0) {
            this.vertical.setMaximum(0);
        }
        this.vertical.setMinimum(0);
        this.vertical.setValue(0);
        this.horizontal.setValue(0);
        this.addToProject.setEnabled(!this.partial);
    }

    private void drawGMwState(String stateName, String stateMeaning, int number, int sccId, Graphics g) {
        this.scrollY -= 20;
        int center = this.getWidth() / 2 - 20;
        g.setColor(sccColors[sccId < 0 ? 0 : sccId % sccColors.length]);
        g.drawOval(center - this.scrollX, (number + 1) * 80 - 20 - this.scrollY, 40, 40);
        g.drawString(stateName, center + 5 - this.scrollX, (number + 1) * 80 + 5 - this.scrollY);
        g.drawString(stateMeaning, center + 45 - this.scrollX, (number + 1) * 80 - 10 - this.scrollY);
        if (stateName.contains("Q0")) {
            g.setColor(Color.BLACK);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
            g.drawLine(center - this.scrollX - 60, (number + 1) * 80 - 20 - this.scrollY - 40, center - this.scrollX, (number + 1) * 80 - 20 - this.scrollY + 20);
            g.drawLine(center - this.scrollX - 2, (number + 1) * 80 - 20 - this.scrollY + 20 - 8, center - this.scrollX, (number + 1) * 80 - 20 - this.scrollY + 20);
            g.drawLine(center - this.scrollX - 8, (number + 1) * 80 - 20 - this.scrollY + 20 - 2, center - this.scrollX, (number + 1) * 80 - 20 - this.scrollY + 20);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        }
        this.scrollY += 20;
    }

    private void drawGMwTransition(GMwTransition mwt, int stepNumber, Graphics g) {
        int center = this.getWidth() / 2 - 20;
        this.scrollY -= 20;
        if (mwt.from.sccId == mwt.to.sccId) {
            g.setColor(sccColors[mwt.from.sccId < 0 ? 0 : mwt.from.sccId % sccColors.length]);
        } else {
            g.setColor(Color.BLACK);
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        }
        if (mwt.from != mwt.to) {
            String name = "";
            for (GMwTransition mwt2 : this.getGMwSteps().get(stepNumber).GMwTransitions) {
                if (mwt2.from != mwt.from || mwt2.to != mwt.to) continue;
                name = String.valueOf(name) + mwt2.name + ",";
            }
            if (name.length() > 0) {
                name = name.substring(0, name.length() - 1);
            }
            if (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.from) > this.getGMwSteps().get(stepNumber).GMwStates.lastIndexOf(mwt.to)) {
                int firstx = center + 40 - this.scrollX;
                int firsty = (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.from) + 1) * 80 - this.scrollY;
                int lastx = center + 40 - this.scrollX;
                int lasty = (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.to) + 1) * 80 - this.scrollY;
                int offsetedx = firstx + 40 + 50 * this.getOffsetMult(stepNumber, mwt);
                this.drawBezier(g, firstx, firsty, offsetedx, firsty, offsetedx, lasty, lastx, lasty);
                g.drawLine(lastx, lasty, lastx + 10, lasty - 5);
                g.drawLine(lastx, lasty, lastx + 10, lasty + 5);
                g.drawString(name, this.getTransitionX(mwt, firstx, offsetedx, offsetedx + 5, lastx), (firsty + lasty) / 2);
            } else {
                int firstx = center - this.scrollX;
                int firsty = (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.from) + 1) * 80 - this.scrollY;
                int lastx = center - this.scrollX;
                int lasty = (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.to) + 1) * 80 - this.scrollY;
                int offsetedx = firstx - 40 - 50 * this.getOffsetMult(stepNumber, mwt);
                this.drawBezier(g, firstx, firsty, offsetedx, firsty, offsetedx, lasty, lastx, lasty);
                g.drawLine(lastx, lasty, lastx - 10, lasty - 5);
                g.drawLine(lastx, lasty, lastx - 10, lasty + 5);
                g.drawString(name, this.getTransitionX(mwt, firstx, offsetedx, offsetedx, firstx) + 5, (firsty + lasty) / 2);
            }
        } else {
            int firstx = center - this.scrollX;
            int lastx = center + 40 - this.scrollX;
            int firsty = (this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mwt.to) + 1) * 80 - this.scrollY;
            int offsetedy = firsty - 60;
            int offsetedx1 = firstx - 30;
            int offsetedx2 = lastx + 30;
            String name = "";
            for (GMwTransition mwt2 : this.getGMwSteps().get(stepNumber).GMwTransitions) {
                if (mwt2.from != mwt.from || mwt2.to != mwt.to) continue;
                name = String.valueOf(name) + mwt2.name + ",";
            }
            name.contains(",");
            if (name.length() > 0) {
                name = name.substring(0, name.length() - 1);
            }
            this.drawBezier(g, firstx, firsty, offsetedx1, offsetedy, offsetedx2, offsetedy, lastx, firsty);
            g.drawLine(firstx, firsty, firstx - 7, firsty - 4);
            g.drawLine(firstx, firsty, firstx, firsty - 10);
            g.drawString(name, (firstx + lastx) / 2 - 5, firsty - 50);
        }
        this.scrollY += 20;
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
    }

    private int getOffsetMult(int actualStep, GMwTransition mwt) {
        int temp = 0;
        int count = 0;
        int i = 1;
        int[] offset = new int[this.GMwSteps.get(actualStep).GMwTransitions.size()];
        for (GMwTransition mwt2 : this.getGMwSteps().get(actualStep).GMwTransitions) {
            if (this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.from) > this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.to) && this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt.from) > this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt.to)) {
                offset[count] = this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.from) - this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.to);
                if (mwt2 == mwt) {
                    temp = offset[count];
                }
                ++count;
            }
            if (this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.from) >= this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.to) || this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt.from) >= this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt.to)) continue;
            offset[count] = this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.to) - this.getGMwSteps().get(actualStep).GMwStates.indexOf(mwt2.from);
            if (mwt2 == mwt) {
                temp = offset[count];
            }
            ++count;
        }
        Arrays.sort(offset, 0, count);
        int j = count - 1;
        while (j >= 0) {
            if (offset[j] < temp) {
                temp = offset[j];
                ++i;
            }
            --j;
        }
        return i;
    }

    private void drawBezier(Graphics g, int x1, int y1, int x2, int y2, int a1, int b1, int a2, int b2) {
        double t = 0.0;
        double[] b = new double[4];
        int x = x1;
        int y = y1;
        t = 0.0;
        while (t <= 1.0) {
            b[0] = (1.0 - t) * (1.0 - t) * (1.0 - t);
            b[1] = 3.0 * t * (1.0 - t) * (1.0 - t);
            b[2] = 3.0 * t * t * (1.0 - t);
            b[3] = t * t * t;
            int p = (int)((double)x1 * b[0] + (double)x2 * b[1] + (double)a1 * b[2] + (double)a2 * b[3]);
            int q = (int)((double)y1 * b[0] + (double)y2 * b[1] + (double)b1 * b[2] + (double)b2 * b[3]);
            g.drawLine(x, y, p, q);
            x = p;
            y = q;
            t += 0.01;
        }
    }

    private int getTransitionX(GMwTransition mwt, int x1, int x2, int a1, int a2) {
        double t = 0.5;
        double[] b = new double[]{(1.0 - t) * (1.0 - t) * (1.0 - t), 3.0 * t * (1.0 - t) * (1.0 - t), 3.0 * t * t * (1.0 - t), t * t * t};
        int temp = (int)((double)x1 * b[0] + (double)x2 * b[1] + (double)a1 * b[2] + (double)a2 * b[3]);
        return temp;
    }

    public void drawGMw(int stepNumber, Graphics g) {
        if (this.vertical.getMaximum() == 20) {
            this.stepChanged();
        }
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.drawString("Step: " + (stepNumber + 1) + "/" + this.getGMwSteps().size(), 10, 50);
        if (stepNumber >= 0 && this.getGMwSteps().size() > stepNumber) {
            for (GMwTransition mwt : this.getGMwSteps().get(stepNumber).GMwTransitions) {
                this.drawGMwTransition(mwt, this.getActualStep(), g);
            }
            for (GMwState mws : this.getGMwSteps().get(stepNumber).GMwStates) {
                this.drawGMwState(mws.stateName, mws.stateMeaning, this.getGMwSteps().get(stepNumber).GMwStates.indexOf(mws), mws.sccId, g);
            }
        }
    }

    public void addGMwStep(MwAutomaton automaton) {
        this.partial = automaton.isPartial();
        int transCounter = 0;
        this.setActualStep(this.getActualStep() + 1);
        GMwStep gmws = new GMwStep();
        this.getGMwSteps().add(gmws);
        if (automaton != null) {
            this.mwToSave = automaton;
            for (Vertex v : automaton.getStates()) {
                this.addGMwState("Q" + String.valueOf(v.getVertId()), v.toString(), v.getFirstNonOmegalizedVector() != null && v.getOmegaId() > -1000 ? Arrays.toString(v.getFirstNonOmegalizedVector()) : null, v.getSccId());
            }
            int i = 0;
            while (i < automaton.getStates().size()) {
                String from = "Q" + String.valueOf(automaton.getStates().get(i).getVertId());
                int j = 0;
                while (j < automaton.getNoOfTr()) {
                    if (automaton.getTransTable().get(i)[j] != null) {
                        if (automaton.getPn() != null) {
                            this.addGMwTransition(automaton.getPn().transition[j].getName().toString(), from, "Q" + String.valueOf(automaton.getTransTable().get(i)[j].getVertId()), automaton.getPn().transition[j].isSynchronic());
                        } else {
                            this.addGMwTransition("Transition" + transCounter, from, "Q" + String.valueOf(automaton.getTransTable().get(i)[j].getVertId()), false);
                            ++transCounter;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.scroll.setMaximum(this.getGMwSteps().size());
        this.scroll.setValue(this.getGMwSteps().size());
    }

    public void addGMwState(String name, String nameMeaning, String minimalMarking, int sccId) {
        if (nameMeaning.contains("=")) {
            nameMeaning = nameMeaning.split("=", 2)[1];
        }
        GMwState mws = new GMwState(name, nameMeaning, minimalMarking, sccId);
        int index = -1;
        for (GMwState state : this.getGMwSteps().get(this.getActualStep()).GMwStates) {
            if (sccId == state.sccId) {
                index = this.getGMwSteps().get(this.getActualStep()).GMwStates.indexOf(state);
                continue;
            }
            if (index != -1) break;
        }
        if (index != -1) {
            this.getGMwSteps().get(this.getActualStep()).GMwStates.add(index + 1, mws);
        } else {
            this.getGMwSteps().get(this.getActualStep()).GMwStates.add(mws);
        }
        this.stepChanged();
    }

    public void addGMwTransition(String name, String from, String to, boolean synchronic) {
        GMwState tfrom = null;
        GMwState tto = null;
        for (GMwState mws : this.getGMwSteps().get(this.getActualStep()).GMwStates) {
            if (mws.stateName.compareTo(from) != 0) continue;
            tfrom = mws;
        }
        for (GMwState mws : this.getGMwSteps().get(this.getActualStep()).GMwStates) {
            if (mws.stateName.compareTo(to) != 0) continue;
            tto = mws;
        }
        GMwTransition mwt = new GMwTransition(name, tfrom, tto, synchronic);
        this.getGMwSteps().get(this.getActualStep()).GMwTransitions.add(mwt);
    }

    private void setActualStep(int actualStep) {
        this.actualStep = actualStep;
        this.stepChanged();
    }

    public int getActualStep() {
        return this.actualStep;
    }

    public PetriNet getPnFromMw(ArrayList<Loop> loops) {
        if (!this.addToProject.isSelected() && loops == null) {
            return null;
        }
        PetriNet pp = new PetriNet();
        pp.setName("Mw Automaton for " + this.petriNet.getName());
        int center = (this.getGMwSteps().get(this.actualStep).GMwTransitions.size() * 30 + 200) / 2;
        int j = 0;
        for (GMwState state : this.getGMwSteps().get(this.actualStep).GMwStates) {
            if (j == 0) {
                if (state.minimalMarking == null) {
                    pp.addPlace(state.stateName, center + 20, (this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(state) + 1) * 80 - 20, 1, state.stateMeaning);
                } else {
                    pp.addPlace(state.stateName, center + 20, (this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(state) + 1) * 80 - 20, 1, String.valueOf(state.stateMeaning) + "#" + state.minimalMarking);
                }
            } else if (state.minimalMarking == null) {
                pp.addPlace(state.stateName, center + 20, (this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(state) + 1) * 80 - 20, 0, state.stateMeaning);
            } else {
                pp.addPlace(state.stateName, center + 20, (this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(state) + 1) * 80 - 20, 0, String.valueOf(state.stateMeaning) + "#" + state.minimalMarking);
            }
            ++j;
        }
        int offset = 100;
        j = 0;
        for (GMwTransition transition : this.getGMwSteps().get(this.actualStep).GMwTransitions) {
            Transition t = pp.addTransition(transition.name, center + offset, ((this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(transition.to) + 1) * 80 - 20 + ((this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(transition.from) + 1) * 80 - 20)) / 2, transition.synchronic, "T" + j);
            pp.addArc(pp.place[this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(transition.from)], t);
            pp.addArc(t, pp.place[this.getGMwSteps().get(this.actualStep).GMwStates.indexOf(transition.to)]);
            if (offset > 0) {
                offset *= -1;
            } else if (offset < 0) {
                offset *= -1;
                offset += 30;
            }
            ++j;
        }
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = builder.newDocument();
        Element e = doc.createElement("mwAutomaton");
        Element tmp = doc.createElement("dependingPetriNet");
        tmp.setAttribute("hash", ModuleImpl.getPetriNetHash(this.petriNet));
        e.appendChild(tmp);
        if (loops != null) {
            tmp = doc.createElement("simpleLoops");
            for (Loop l : loops) {
                Element tmp2 = doc.createElement("loop");
                tmp2.setAttribute("stateId", l.statesToHex());
                tmp2.setAttribute("data", l.toHex());
                tmp.appendChild(tmp2);
            }
            e.appendChild(tmp);
        }
        pp.setAdditionalData(e, "mwAutomaton");
        return pp;
    }

    public void setPetriNet(PetriNet petriNet) {
        this.petriNet = petriNet;
    }

    public int getMaxNumStates() {
        int max = 0;
        for (GMwStep g : this.getGMwSteps()) {
            if (g.GMwStates.size() <= max) continue;
            max = g.GMwStates.size();
        }
        return max;
    }

    private class GMwState {
        public String stateName;
        public String stateMeaning;
        public String minimalMarking;
        public int sccId;

        public GMwState(String stateName, String stateMeaning, String minimalMarking, int sccId) {
            this.stateName = stateName;
            this.stateMeaning = stateMeaning;
            this.minimalMarking = minimalMarking;
            this.sccId = sccId;
        }
    }

    public class GMwStep {
        private ArrayList<GMwTransition> GMwTransitions = new ArrayList();
        private ArrayList<GMwState> GMwStates = new ArrayList();
    }

    private class GMwTransition {
        public String name;
        public GMwState from;
        public GMwState to;
        public boolean synchronic;

        public GMwTransition(String name, GMwState from, GMwState to, boolean synchronic) {
            this.name = name;
            this.from = from;
            this.to = to;
            this.synchronic = synchronic;
        }
    }
}

