/*
 * Decompiled with CFR 0.152.
 */
package pn.modules.pn.Impl;

import java.util.ArrayList;
import java.util.Properties;
import org.w3c.dom.Element;
import pn.ModuleImpl;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;
import pn.modules.pn.Impl.Arc;
import pn.modules.pn.Impl.Place;
import pn.modules.pn.Impl.PnVertex;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.reachabilityException;

public class PetriNet
implements IPetriNet {
    private String name;
    private boolean canAdd;
    public int place_pocet = 0;
    public int transition_pocet = 0;
    public int arc_pocet = 0;
    public int[][] pre;
    public int[][] postt;
    public Place[] place;
    public Transition[] transition;
    public Arc[] arc;
    private String additionalData = null;
    private Object additional = null;

    public PetriNet(IPetriNet pn) throws reachabilityException {
        this.additional = pn.getAdditionalData();
        this.name = pn.getName();
        this.place = new Place[pn.getPlaces().size()];
        this.transition = new Transition[pn.getTransitions().size()];
        this.arc = new Arc[pn.getArcs().size()];
        this.place_pocet = pn.getPlaces().size();
        this.transition_pocet = pn.getTransitions().size();
        this.postt = new int[this.place_pocet][this.transition_pocet];
        this.pre = new int[this.place_pocet][this.transition_pocet];
        this.arc_pocet = pn.getArcs().size();
        int i = 0;
        for (IPlace iPlace : pn.getPlaces()) {
            this.place[i] = new Place(i, iPlace.getId());
            this.place[i].marking = iPlace.getTokens();
            this.place[i].name = iPlace.getName();
            this.place[i].x = (int)iPlace.getX();
            this.place[i].y = (int)iPlace.getY();
            ++i;
        }
        i = 0;
        for (ITransition iTransition : pn.getTransitions()) {
            this.transition[i] = new Transition(i, false, iTransition.getId());
            this.transition[i].name = iTransition.getName();
            this.transition[i].x = (int)iTransition.getX();
            this.transition[i].y = (int)iTransition.getY();
            ++i;
        }
        i = 0;
        for (IArc iArc : pn.getArcs()) {
            this.arc[i] = new Arc(i);
            this.arc[i].weight = iArc.getCount();
            boolean found = false;
            int j = 0;
            for (ITransition iTransition : pn.getTransitions()) {
                if (iArc.getStartingVertex() == iTransition) {
                    found = true;
                    this.arc[i].zac = j;
                    this.arc[i].pod = 1;
                    this.arc[i].from = this.transition[j];
                    this.transition[j].addArc(this.arc[i]);
                    break;
                }
                ++j;
            }
            if (!found) {
                j = 0;
                for (IPlace iPlace : pn.getPlaces()) {
                    if (iArc.getStartingVertex() == iPlace) {
                        found = true;
                        this.arc[i].zac = j;
                        this.arc[i].pod = 0;
                        this.arc[i].from = this.place[j];
                        this.place[j].addArc(this.arc[i]);
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                throw new reachabilityException("Starting vertex not found.");
            }
            found = false;
            j = 0;
            for (ITransition iTransition : pn.getTransitions()) {
                if (iArc.getEndingVertex() == iTransition) {
                    found = true;
                    this.arc[i].kon = j;
                    this.arc[i].to = this.transition[j];
                    this.transition[j].addArc(this.arc[i]);
                    break;
                }
                ++j;
            }
            if (!found) {
                j = 0;
                for (IPlace iPlace : pn.getPlaces()) {
                    if (iArc.getEndingVertex() == iPlace) {
                        found = true;
                        this.arc[i].kon = j;
                        this.arc[i].to = this.place[j];
                        this.place[j].addArc(this.arc[i]);
                        break;
                    }
                    ++j;
                }
            }
            if (!found) {
                throw new reachabilityException("Ending vertex not found.");
            }
            ++i;
        }
        this.initprepost();
        this.canAdd = false;
    }

    public PetriNet() {
        this.place = new Place[150];
        this.transition = new Transition[150];
        this.arc = new Arc[4500];
        this.postt = new int[150][150];
        this.pre = new int[150][150];
        this.place_pocet = 0;
        this.transition_pocet = 0;
        this.arc_pocet = 0;
        this.canAdd = true;
    }

    public Place addPlace(String name, int x, int y, String id) {
        if (!this.canAdd) {
            return null;
        }
        this.place[this.place_pocet] = new Place(this.place_pocet, id);
        this.place[this.place_pocet].x = x;
        this.place[this.place_pocet].y = y;
        this.place[this.place_pocet].name = name;
        ++this.place_pocet;
        return this.place[this.place_pocet - 1];
    }

    public Place addPlace(String name, int x, int y, int marking, String id) {
        if (!this.canAdd) {
            return null;
        }
        if (ModuleImpl.isDebug) {
            System.out.println("Added place:" + name);
        }
        this.place[this.place_pocet] = new Place(this.place_pocet, id);
        this.place[this.place_pocet].x = x;
        this.place[this.place_pocet].y = y;
        this.place[this.place_pocet].name = name;
        this.place[this.place_pocet].marking = marking;
        ++this.place_pocet;
        return this.place[this.place_pocet - 1];
    }

    public Transition addTransition(String name, int x, int y, boolean synchronic, String id) {
        if (!this.canAdd) {
            return null;
        }
        if (ModuleImpl.isDebug) {
            System.out.println("Add transition:" + name);
        }
        if (this.transition_pocet >= this.transition.length) {
            Transition[] tmp = new Transition[this.transition_pocet + 1];
            System.arraycopy(this.transition, 0, tmp, 0, this.transition.length);
            this.transition = tmp;
        }
        this.transition[this.transition_pocet] = new Transition(this.transition_pocet, synchronic, id);
        this.transition[this.transition_pocet].x = x;
        this.transition[this.transition_pocet].y = y;
        this.transition[this.transition_pocet].name = name;
        ++this.transition_pocet;
        return this.transition[this.transition_pocet - 1];
    }

    public Arc addArc(PnVertex from, PnVertex to) {
        if (!this.canAdd) {
            return null;
        }
        if (ModuleImpl.isDebug) {
            if (from instanceof Place) {
                System.out.println("Add arc from:" + ((Place)from).name + " to:" + ((Transition)to).name);
            } else {
                System.out.println("Add arc from:" + ((Transition)from).name + " to:" + ((Place)to).name);
            }
        }
        this.arc[this.arc_pocet] = new Arc(this.arc_pocet);
        this.arc[this.arc_pocet].dek = 0;
        this.arc[this.arc_pocet].from = from;
        this.arc[this.arc_pocet].to = to;
        this.arc[this.arc_pocet].weight = 1;
        int n = this.arc[this.arc_pocet].pod = from instanceof Place ? 0 : 1;
        if (this.arc[this.arc_pocet].pod == 0) {
            this.arc[this.arc_pocet].zac = ((Place)from).getArrayIndex();
            this.arc[this.arc_pocet].kon = ((Transition)to).getArrayIndex();
        } else {
            this.arc[this.arc_pocet].zac = ((Transition)from).getArrayIndex();
            this.arc[this.arc_pocet].kon = ((Place)to).getArrayIndex();
        }
        this.arc[this.arc_pocet].from.addArc(this.arc[this.arc_pocet]);
        this.arc[this.arc_pocet].to.addArc(this.arc[this.arc_pocet]);
        ++this.arc_pocet;
        return this.arc[this.arc_pocet - 1];
    }

    public void compileArrays() {
        Place[] tempPlaceArray = new Place[this.place_pocet];
        Transition[] tempTransitionArray = new Transition[this.transition_pocet];
        Arc[] tempArcArray = new Arc[this.arc_pocet];
        int[][] tempPre = new int[this.place_pocet][this.transition_pocet];
        int[][] tempPostt = new int[this.place_pocet][this.transition_pocet];
        System.arraycopy(this.place, 0, tempPlaceArray, 0, this.place_pocet);
        System.arraycopy(this.transition, 0, tempTransitionArray, 0, this.transition_pocet);
        System.arraycopy(this.arc, 0, tempArcArray, 0, this.arc_pocet);
        int i = 0;
        while (i < this.place_pocet) {
            System.arraycopy(this.pre[i], 0, tempPre[i], 0, this.transition_pocet);
            System.arraycopy(this.postt[i], 0, tempPostt[i], 0, this.transition_pocet);
            ++i;
        }
        this.place = tempPlaceArray;
        this.transition = tempTransitionArray;
        this.arc = tempArcArray;
        this.pre = tempPre;
        this.postt = tempPostt;
        System.gc();
        this.canAdd = false;
    }

    public void setMarking(int i, int j) {
        this.place[i].marking = j;
    }

    public StringBuffer getPlaceOrderingAsStrBuff() {
        StringBuffer plOrd = new StringBuffer(4810);
        plOrd.append("&lt; ");
        int i = 0;
        while (i < this.place_pocet) {
            plOrd.append(this.place[i].name);
            if (i < this.place_pocet - 1) {
                plOrd.append(", ");
            }
            ++i;
        }
        plOrd.append(" &gt;");
        return plOrd;
    }

    public ArrayList<String> getPlaceOrderingAsStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        int i = 0;
        while (i < this.place_pocet) {
            strs.add(this.place[i].getId());
            ++i;
        }
        return strs;
    }

    public StringBuffer getTransitionOrderingAsStrBuff() {
        StringBuffer trOrd = new StringBuffer();
        trOrd.append("&lt; ");
        int i = 0;
        while (i < this.transition_pocet) {
            trOrd.append(this.transition[i].name);
            if (i < this.transition_pocet - 1) {
                trOrd.append(", ");
            }
            ++i;
        }
        trOrd.append(" &gt;");
        return trOrd;
    }

    public ArrayList<String> getTransitionOrderingAsStrings() {
        ArrayList<String> strs = new ArrayList<String>();
        int i = 0;
        while (i < this.transition_pocet) {
            strs.add(this.transition[i].getId());
            ++i;
        }
        return strs;
    }

    public void initprepost() {
        int i = 0;
        while (i < this.place_pocet) {
            int j = 0;
            while (j < this.transition_pocet) {
                this.pre[i][j] = 0;
                this.postt[i][j] = 0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.arc_pocet) {
            if (this.arc[i].pod == 0) {
                int[] nArray = this.pre[this.arc[i].zac];
                int n = this.arc[i].kon;
                nArray[n] = nArray[n] + this.arc[i].weight;
            } else {
                int[] nArray = this.postt[this.arc[i].kon];
                int n = this.arc[i].zac;
                nArray[n] = nArray[n] + this.arc[i].weight;
            }
            ++i;
        }
    }

    @Override
    public ArrayList<IArc> getArcs() {
        ArrayList<IArc> arcs = new ArrayList<IArc>();
        int i = 0;
        while (i < this.arc_pocet) {
            if (this.arc[i].from != null && this.arc[i].to != null) {
                arcs.add(this.arc[i]);
            }
            ++i;
        }
        return arcs;
    }

    @Override
    public ArrayList<IPlace> getPlaces() {
        ArrayList<IPlace> places = new ArrayList<IPlace>();
        int i = 0;
        while (i < this.place_pocet) {
            places.add(this.place[i]);
            ++i;
        }
        return places;
    }

    @Override
    public ArrayList<ITransition> getTransitions() {
        ArrayList<ITransition> transitions = new ArrayList<ITransition>();
        int i = 0;
        while (i < this.transition_pocet) {
            transitions.add(this.transition[i]);
            ++i;
        }
        return transitions;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "Undefined";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        if (this.name == null) {
            return "Undefined";
        }
        return this.name;
    }

    @Override
    public String getType() {
        return "GPN";
    }

    @Override
    public Object getAdditionalData() {
        if (this.additional != null) {
            return this.additional;
        }
        if (this.additionalData == null) {
            return null;
        }
        Properties p = new Properties();
        p.setProperty("mwAutomaton", this.additionalData);
        return p;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public void setAdditionalData(Element e, String key) {
        if (this.additional == null) {
            this.additional = new Properties();
        }
        ((Properties)this.additional).put(key, e);
    }
}

