/*
 * Decompiled with CFR 0.152.
 */
package pn;

import LESSolver.ILESSolution;
import LESSolver.ILESSolver;
import gui.WizardStart;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.Impl.PetriNet;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.reachabilityException;

public class ModuleImpl
extends JPanel
implements IModule {
    private IPetriNet petriNet;
    private PetriNet petriNetInternal;
    private ArrayList<IResponseListener> responseListeners;
    private MwAutomaton mwAutomaton;
    public static boolean isDebug = true;
    private boolean error;
    private ILESSolver lesSolver;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
        this.petriNet = null;
        this.responseListeners = new ArrayList();
        if (isDebug) {
            System.out.println("Reachability module has been loaded.");
        }
        this.error = false;
    }

    public Image getPetriNetImage(PetriNet pn) {
        return this.responseListeners.get(0).convertToImage(pn);
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        if (isDebug) {
            System.out.println("Petri net added to RM");
        }
        this.petriNet = pn;
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        if (isDebug) {
            System.out.println("ResponseListener added to RM");
        }
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        block9: {
            if (!this.openDependingModules()) {
                this.error = true;
            }
            if (isDebug) {
                System.out.println("RM has been opened");
            }
            if (this.petriNet == null) {
                return;
            }
            if (isDebug) {
                System.out.println("Launching...");
            }
            try {
                this.petriNetInternal = new PetriNet(this.petriNet);
                if (this.petriNetInternal.place_pocet == 0) {
                    JOptionPane.showMessageDialog(null, "There are no places in selected Petri net. Analysis not applicable.", "No places in selected Petri net", 1);
                    return;
                }
                if (this.petriNetInternal.transition_pocet == 0) {
                    JOptionPane.showMessageDialog(null, "There are no transitions in selected Petri net. Analysis not applicable.", "No transitions in selected Petri net", 1);
                    return;
                }
                WizardStart wiz = new WizardStart(this.petriNetInternal, this);
                if (this.mwAutomaton != null) {
                    ArrayList<MwAutomaton> mws = new ArrayList<MwAutomaton>();
                    this.mwAutomaton.setPn(this.petriNetInternal);
                    mws.add(this.mwAutomaton);
                    wiz.setMws(mws);
                }
                wiz.start();
                wiz = null;
            }
            catch (reachabilityException ex) {
                if (!isDebug) break block9;
                System.out.println(ex.toString());
            }
        }
    }

    public void addPetriNetToProject(PetriNet pn) {
        for (IResponseListener rl : this.responseListeners) {
            rl.respond(pn);
        }
    }

    public static String getPetriNetHash(IPetriNet pn) {
        StringBuffer hash = new StringBuffer();
        String result = null;
        int[][] matrix = new int[pn.getPlaces().size()][pn.getTransitions().size()];
        int[][] matrix2 = new int[pn.getPlaces().size()][pn.getTransitions().size()];
        for (IPlace p : pn.getPlaces()) {
            hash.append(String.valueOf(p.getTokens()) + " ");
        }
        for (IArc a : pn.getArcs()) {
            if (a.getStartingVertex() instanceof IPlace) {
                matrix[pn.getPlaces().indexOf((Object)a.getStartingVertex())][pn.getTransitions().indexOf((Object)a.getEndingVertex())] = a.getCount();
                continue;
            }
            matrix2[pn.getPlaces().indexOf((Object)a.getEndingVertex())][pn.getTransitions().indexOf((Object)a.getStartingVertex())] = a.getCount();
        }
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                hash.append(String.valueOf(matrix[i][j]) + " ");
                ++j;
            }
            hash.append("\n");
            ++i;
        }
        i = 0;
        while (i < matrix2.length) {
            int j = 0;
            while (j < matrix2[0].length) {
                hash.append(String.valueOf(matrix2[i][j]) + " ");
                ++j;
            }
            hash.append("\n");
            ++i;
        }
        result = hash.toString();
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            byte[] b = m.digest(hash.toString().getBytes());
            result = "";
            int i2 = 0;
            while (i2 < b.length) {
                result = String.valueOf(result) + Integer.toString((b[i2] & 0xFF) + 256, 16).substring(1);
                ++i2;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("MD5 digest algorithm not found.");
        }
        return result;
    }

    private boolean openDependingModules() {
        boolean result = true;
        try {
            File lesFile = new File("./modules/LESSolver.jar");
            URLClassLoader cl = new URLClassLoader(new URL[]{lesFile.toURI().toURL()}, this.getClass().getClassLoader());
            Class<?> cls = cl.loadClass("LESSolver.LESSolverImpl");
            this.lesSolver = (ILESSolver)cls.newInstance();
        }
        catch (Exception ex) {
            if (isDebug) {
                ex.printStackTrace();
            }
            result = false;
        }
        if (this.lesSolver == null) {
            result = false;
        }
        if (!result && !this.error) {
            JOptionPane.showMessageDialog(null, "Reachability module require LESSolver module. LESSolver module was not found or is corrupted.", "Missing Dependant module", 0);
        }
        return result;
    }

    public ILESSolution solveLES(int[][] matica, int[] vektor) {
        block4: {
            try {
                if (this.lesSolver != null) break block4;
                return null;
            }
            catch (Exception ex) {
                if (isDebug) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        System.out.println("LESSolver>>");
        ILESSolution stb = this.lesSolver.solve(matica, vektor);
        System.out.println("<<LESSolver");
        return stb;
    }

    public ILESSolution solveLESGPU(int[][] matica, int[] vektor) {
        block4: {
            try {
                if (this.lesSolver != null) break block4;
                return null;
            }
            catch (Exception ex) {
                if (isDebug) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        System.out.println("LESSolver GPU>>");
        ILESSolution stb = this.lesSolver.solveGPU(matica, vektor);
        System.out.println("<<LESSolver GPU");
        return stb;
    }

    public ILESSolution solveLESGPUReal(int[][] matica, int[] vektor) {
        block4: {
            try {
                if (this.lesSolver != null) break block4;
                return null;
            }
            catch (Exception ex) {
                if (isDebug) {
                    ex.printStackTrace();
                }
                return null;
            }
        }
        System.out.println("LESSolver GPU Real>>");
        ILESSolution stb = this.lesSolver.solveGPUReal(matica, vektor);
        System.out.println("<<LESSolver GPU Real");
        return stb;
    }

    @Override
    public void close() {
        if (isDebug) {
            System.out.println("RM closed.");
        }
        this.petriNet = null;
    }

    @Override
    public String getName() {
        if (this.error) {
            return "Reachability analysis module(Error)";
        }
        return "Reachability analysis module";
    }

    @Override
    public JComponent getControlPanel() {
        if (this.error) {
            return null;
        }
        return this;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pnmodulereachability/icon.png")));
        this.jButton1.setToolTipText("Reachability analysis");
        this.jButton1.setMaximumSize(new Dimension(60, 30));
        this.jButton1.setMinimumSize(new Dimension(60, 30));
        this.jButton1.setPreferredSize(new Dimension(60, 30));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 60, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, 30, -2));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        boolean found = false;
        this.petriNet = null;
        if (this.petriNet == null) {
            int i = 0;
            while (i < this.responseListeners.size()) {
                ArrayList<IPetriNet> a = this.responseListeners.get(i).requestPetriNets();
                if (a != null && a.size() != 0) {
                    found = true;
                    this.addPetriNet(a.get(0));
                    String hash = ModuleImpl.getPetriNetHash(a.get(0));
                    int j = 1;
                    while (j < a.size()) {
                        block8: {
                            Element e;
                            IPetriNet pn = a.get(j);
                            if (pn != null && pn.getAdditionalData() != null && pn.getAdditionalData() instanceof Properties && ((Properties)pn.getAdditionalData()).get("mwAutomaton") instanceof Element && (e = (Element)((Properties)pn.getAdditionalData()).get("mwAutomaton")) != null && hash.compareTo(e.getElementsByTagName("dependingPetriNet").item(0).getAttributes().item(0).getNodeValue()) == 0) {
                                try {
                                    MwAutomaton mw;
                                    this.mwAutomaton = mw = new MwAutomaton(new PetriNet(a.get(j)), new PetriNet(a.get(0)));
                                }
                                catch (reachabilityException ex) {
                                    if (!isDebug) break block8;
                                    System.out.println(ex.getMessage());
                                    ex.printStackTrace();
                                }
                            }
                        }
                        ++j;
                    }
                    this.open();
                }
                ++i;
            }
        }
        if (!found) {
            JOptionPane.showMessageDialog(null, "Please select Petri Net to analyze.", "No Petri net selected", 1);
        }
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PN Reachability analysis module</h1><br>Module provides complex reachability analysis<br>Features:<ul><li>Mw Automaton creation</li><li>Simple loops search</li><li>Linear equation system (employing LESSolver module) solving</li><li>T-Junc Decomposition</li></ul><br>Authors:<br>Ing. \u010f\u017c\u02ddtefan Kore\u010f\u017c\u02ddko, PhD.<br>Miroslav Ivani\u010f\u017c\u02ddko<br>Jozef Dobo\u010f\u017c\u02dd</html>";
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/ram_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/ram_eng.html";
    }

    @Override
    public String getTarget() {
        return "ram";
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Modul na anal&#253;zu dosiahnute&#318;nosti";
        }
        if (prefix.equals("_eng")) {
            languageName = "Reachability analysis module";
        }
        return languageName;
    }
}

