/*
 * Decompiled with CFR 0.152.
 */
package gui.wizard;

import gui.wizard.Wizard;
import gui.wizard.WizardModel;
import gui.wizard.WizardPanelDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class WizardController
implements ActionListener {
    private Wizard wizard;

    public WizardController(Wizard w) {
        this.wizard = w;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("CancelButtonActionCommand")) {
            this.cancelButtonPressed();
        } else if (evt.getActionCommand().equals("BackButtonActionCommand")) {
            this.backButtonPressed();
        } else if (evt.getActionCommand().equals("NextButtonActionCommand")) {
            this.nextButtonPressed();
        }
    }

    private void cancelButtonPressed() {
        this.wizard.close(1);
    }

    private void nextButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object nextPanelDescriptor = descriptor.getNextPanelDescriptor();
        if (nextPanelDescriptor == null) {
            this.resetButtonsToPanelRules();
            return;
        }
        if (nextPanelDescriptor instanceof WizardPanelDescriptor.FinishIdentifier) {
            this.wizard.close(0);
        } else {
            this.wizard.setCurrentPanel(nextPanelDescriptor);
        }
    }

    private void backButtonPressed() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        Object backPanelDescriptor = descriptor.getBackPanelDescriptor();
        if (backPanelDescriptor == null) {
            this.resetButtonsToPanelRules();
            return;
        }
        this.wizard.setCurrentPanel(backPanelDescriptor);
    }

    void resetButtonsToPanelRules() {
        WizardModel model = this.wizard.getModel();
        WizardPanelDescriptor descriptor = model.getCurrentPanelDescriptor();
        model.setCancelButtonText(Wizard.CANCEL_TEXT);
        model.setBackButtonText(Wizard.BACK_TEXT);
        if (descriptor.getBackPanelDescriptor() != null) {
            model.setBackButtonEnabled(Boolean.TRUE);
        } else {
            model.setBackButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() != null) {
            model.setNextFinishButtonEnabled(Boolean.TRUE);
        } else {
            model.setNextFinishButtonEnabled(Boolean.FALSE);
        }
        if (descriptor.getNextPanelDescriptor() instanceof WizardPanelDescriptor.FinishIdentifier) {
            model.setNextFinishButtonText(Wizard.FINISH_TEXT);
        } else {
            model.setNextFinishButtonText(Wizard.NEXT_TEXT);
        }
    }
}

