/*
 * Decompiled with CFR 0.152.
 */
package gui.wizard;

import gui.wizard.WizardController;
import gui.wizard.WizardModel;
import gui.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    static String BACK_TEXT = "Back";
    static String NEXT_TEXT = "Next";
    static String FINISH_TEXT = "Finish";
    static String CANCEL_TEXT = "Cancel";
    private WizardModel wizardModel = new WizardModel();
    private WizardController wizardController;
    private JDialog wizardDialog;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;

    public Wizard() {
        this((Frame)null);
    }

    public Wizard(Dialog owner) {
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public Wizard(Frame owner) {
        this.wizardDialog = new JDialog(owner);
        this.initComponents();
    }

    public JDialog getDialog() {
        return this.wizardDialog;
    }

    public Component getOwner() {
        return this.wizardDialog.getOwner();
    }

    public void setTitle(String s) {
        this.wizardDialog.setTitle(s);
    }

    public String getTitle() {
        return this.wizardDialog.getTitle();
    }

    public void setModal(boolean b) {
        this.wizardDialog.setModal(b);
    }

    public boolean isModal() {
        return this.wizardDialog.isModal();
    }

    public int showModalDialog() {
        this.wizardDialog.setModal(true);
        this.wizardDialog.pack();
        this.wizardDialog.setVisible(true);
        return this.returnCode;
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object id, WizardPanelDescriptor panel) {
        this.cardPanel.add(panel.getPanelComponent(), id);
        panel.setWizard(this);
        this.wizardModel.registerPanel(id, panel);
    }

    public void setCurrentPanel(Object id) {
        WizardPanelDescriptor oldPanelDescriptor;
        if (id == null) {
            this.close(2);
        }
        if ((oldPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null) {
            oldPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(id);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, id.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void resetButtons() {
        this.wizardController.resetButtonsToPanelRules();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (evt.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(evt.getNewValue().toString());
        } else if (evt.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)evt.getNewValue());
        } else if (evt.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)evt.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean newValue) {
        this.wizardModel.setBackButtonEnabled(new Boolean(newValue));
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean newValue) {
        this.wizardModel.setNextFinishButtonEnabled(new Boolean(newValue));
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean newValue) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(newValue));
    }

    void close(int code) {
        this.returnCode = code;
        this.wizardDialog.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardDialog.getContentPane().setLayout(new BorderLayout());
        this.wizardDialog.addWindowListener(this);
        JPanel buttonPanel = new JPanel();
        JSeparator separator = new JSeparator();
        Box buttonBox = new Box(0);
        this.cardPanel = new JPanel();
        this.cardPanel.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        buttonPanel.setLayout(new BorderLayout());
        buttonPanel.add((Component)separator, "North");
        buttonBox.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        buttonBox.add(this.backButton);
        buttonBox.add(Box.createHorizontalStrut(10));
        buttonBox.add(this.nextButton);
        buttonBox.add(Box.createHorizontalStrut(30));
        buttonBox.add(this.cancelButton);
        buttonPanel.add((Component)buttonBox, "East");
        this.wizardDialog.getContentPane().add((Component)buttonPanel, "South");
        this.wizardDialog.getContentPane().add((Component)this.cardPanel, "Center");
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.returnCode = 1;
    }
}

