/*
 * Decompiled with CFR 0.152.
 */
package gui.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private JCheckBox checkBox;
    private Image image;

    public ImagePanel(Image image) {
        this.image = image;
        this.checkBox = new JCheckBox();
        this.checkBox.setText("Add this decomposed Petri Net to project");
        this.checkBox.setSelected(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.checkBox, "South");
    }

    @Override
    public void paintComponent(Graphics g) {
        double imgW = this.image.getWidth(null);
        double imgH = this.image.getHeight(null);
        double width = this.getWidth();
        double height = this.getHeight() - this.checkBox.getHeight();
        if (imgW <= width && imgH <= height) {
            g.drawImage(this.image, (int)(width / 2.0 - imgW / 2.0), (int)(height / 2.0 - imgH / 2.0), null);
        } else {
            double scale = Math.min(width / imgW, height / imgH);
            g.drawImage(this.image, (int)(width / 2.0 - (imgW *= scale) / 2.0), (int)(height / 2.0 - (imgH *= scale) / 2.0), (int)imgW, (int)imgH, null);
        }
    }

    public boolean isAddToProject() {
        return this.checkBox.isSelected();
    }
}

