/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import gui.panels.MwAutomatonPanel;
import gui.utils.MwAutomatonResultsPanel;
import java.util.ArrayList;
import pn.ModuleImpl;
import pn.modules.pn.Impl.PetriNet;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.MwCreator;

class thrRunReach
implements Runnable {
    private MwAutomatonPanel mwp;
    private ArrayList<PetriNet> pns;
    private MwAutomaton mw;
    private MwCreator mc;

    public void stopComputation() {
        this.mc.stop();
    }

    public thrRunReach(MwAutomatonPanel mwp, PetriNet pn) {
        this.mwp = mwp;
        this.pns = new ArrayList();
        this.pns.add(pn);
    }

    public thrRunReach(MwAutomatonPanel mwp, ArrayList<PetriNet> pns) {
        this.mwp = mwp;
        this.pns = pns;
    }

    @Override
    public void run() {
        int j = 1;
        for (PetriNet pn : this.pns) {
            if (ModuleImpl.isDebug) {
                System.out.println("Places:" + pn.place_pocet);
                int i = 0;
                while (i < pn.place_pocet) {
                    System.out.println(String.valueOf(pn.place[i].name) + " " + pn.place[i].x + " " + pn.place[i].y);
                    ++i;
                }
                System.out.println("Transitions:" + pn.transition_pocet);
                i = 0;
                while (i < pn.transition_pocet) {
                    System.out.println(String.valueOf(pn.transition[i].name) + " " + pn.transition[i].x + " " + pn.transition[i].y);
                    ++i;
                }
                System.out.println("Arcs:" + pn.arc_pocet);
            }
            if (this.mc != null && this.mc.isStop()) {
                return;
            }
            this.mc = new MwCreator(pn, this.mwp.isVisualize(), this.mwp.isEquicheck(), this.mwp.getMaxNumStates());
            try {
                this.mw = this.mwp.isBuildPartialMw() ? this.mc.buildMw(this.pns.size() > 1 ? this.mwp.getExaminedVector(j - 1) : this.mwp.getExaminedVector()) : this.mc.buildMw();
                if (this.mc.isStop()) {
                    return;
                }
                this.mwp.getMws().add(this.mw);
                this.mwp.getTabs().addTab("Mw automaton " + j, new MwAutomatonResultsPanel(this.mw.getStatesListAsString(true, true), this.mw.getTransTableAsString(true), pn.getPlaceOrderingAsStrBuff().toString(), pn.getTransitionOrderingAsStrBuff().toString()));
                this.mwp.getConsole().append(this.mc.getConsole().toString());
                if (this.mc.getGraphicMw() != null) {
                    this.mwp.getTabs().addTab("Mw Automaton vizualization " + j, this.mc.getGraphicMw());
                }
                this.mwp.setFullProgress();
                this.mwp.getTimer().cancel();
                this.mwp.evaluateResults();
                this.mwp.getMad().setReady(true);
                try {
                    this.mwp.getConsole().append(this.mc.getConsole().toString());
                }
                catch (Exception ex) {
                    this.mwp.getConsole().append(ex.getMessage());
                }
            }
            catch (Exception ex) {
                this.mwp.getConsole().setText(ex.getMessage());
                ex.printStackTrace();
            }
            ++j;
        }
    }

    public int getTotal() {
        if (this.mc == null) {
            return 0;
        }
        return this.mc.getTotal();
    }

    public int getActual() {
        if (this.mc == null) {
            return 0;
        }
        return this.mc.getActual();
    }
}

