/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import gui.WizardStart;
import gui.wizard.Wizard;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import pnmodulereachability.MwAutomaton;

public class SimpleLoopSearchPanel
extends JPanel {
    private ArrayList<MwAutomaton> mws;
    private Timer timer;
    Thread thread;
    SimpleLoopSearch sls;
    Wizard wizard;
    private JCheckBox jCheckBox1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public SimpleLoopSearchPanel() {
        this.initComponents();
        this.wizard = null;
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet style = kit.getStyleSheet();
        WizardStart.addStyleSheetRules(style);
        this.jTextPane1.setEditorKit(kit);
    }

    public void SetWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public void stopExectution() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.sls != null) {
            this.sls.stopComputation();
        }
    }

    public void compute() {
        if (this.wizard != null) {
            this.wizard.setNextFinishButtonEnabled(false);
        } else {
            System.out.println("NEFUNGUJE");
        }
        this.jProgressBar1.setMaximum(1);
        this.jProgressBar1.setMinimum(0);
        this.jProgressBar1.setValue(0);
        boolean foundWithoutLoops = false;
        for (MwAutomaton mw : this.mws) {
            if (mw.getSimpleLoops() != null && !mw.getSimpleLoops().isEmpty()) continue;
            foundWithoutLoops = true;
            break;
        }
        if (!foundWithoutLoops) {
            this.evaluateResults();
            return;
        }
        this.sls = new SimpleLoopSearch(this.mws, this);
        this.thread = new Thread(this.sls);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (SimpleLoopSearchPanel.this.sls == null) {
                    return;
                }
                int divider = 1;
                long max = SimpleLoopSearchPanel.this.sls.getMaxLoopCount();
                if (max > 0L) {
                    while (max > Integer.MAX_VALUE) {
                        max /= (long)(++divider);
                    }
                    SimpleLoopSearchPanel.this.jProgressBar1.setMaximum((int)max);
                    SimpleLoopSearchPanel.this.jProgressBar1.setValue((int)(SimpleLoopSearchPanel.this.sls.getActualLoopCount() / (long)divider));
                } else {
                    SimpleLoopSearchPanel.this.jProgressBar1.setMaximum(1);
                    SimpleLoopSearchPanel.this.jProgressBar1.setValue(1);
                }
            }
        }, 0L, 100L);
        this.thread.start();
    }

    public void evaluateResults() {
        StringBuffer str = new StringBuffer();
        this.jProgressBar1.setMaximum(1);
        this.jProgressBar1.setValue(1);
        int i = 1;
        for (MwAutomaton mw : this.mws) {
            str.append("<b>Mw Automaton " + i + "</b><br>");
            str.append(mw.getLoopsReportAsString(true));
            str.append("<hr>");
            ++i;
        }
        this.jTextPane1.setText(str.toString());
        if (this.wizard != null) {
            this.wizard.setNextFinishButtonEnabled(true);
        }
    }

    public boolean isAddToProject() {
        return this.jCheckBox1.isSelected();
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jCheckBox1 = new JCheckBox();
        this.jTextPane1.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.jCheckBox1.setText("Add all Mw Automata to project");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 603, Short.MAX_VALUE).addComponent(this.jCheckBox1, GroupLayout.Alignment.LEADING).addComponent(this.jProgressBar1, GroupLayout.Alignment.LEADING, -1, 603, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 361, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addContainerGap(15, Short.MAX_VALUE)));
    }

    public void setMws(ArrayList<MwAutomaton> mws) {
        this.mws = mws;
    }

    public ArrayList<MwAutomaton> getMws() {
        return this.mws;
    }

    private class SimpleLoopSearch
    implements Runnable {
        private ArrayList<MwAutomaton> mws;
        private MwAutomaton currentlyComputing;
        private long maxLoopCount = 1L;
        private SimpleLoopSearchPanel slsp;

        public SimpleLoopSearch(ArrayList<MwAutomaton> mws, SimpleLoopSearchPanel slsp) {
            this.mws = mws;
            this.slsp = slsp;
        }

        public void stopComputation() {
            this.currentlyComputing.stop();
        }

        @Override
        public void run() {
            for (MwAutomaton mw : this.mws) {
                if (this.currentlyComputing != null && this.currentlyComputing.isStop()) {
                    return;
                }
                this.currentlyComputing = mw;
                this.maxLoopCount = mw.getTeoreticalLoopNum();
                try {
                    mw.findSimpleLoops();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.maxLoopCount = 0L;
            if (this.currentlyComputing.isStop()) {
                return;
            }
            this.slsp.evaluateResults();
        }

        public long getActualLoopCount() {
            if (this.currentlyComputing == null) {
                return 0L;
            }
            return this.currentlyComputing.getProgress();
        }

        public long getMaxLoopCount() {
            return this.maxLoopCount;
        }
    }
}

