/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import LESSolver.ILESSolution;
import gui.WizardStart;
import gui.descriptors.FinalResultsDescriptor;
import gui.panels.ExaminedVectorPanel;
import gui.utils.PleaseWaitScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import pn.ModuleImpl;
import pn.modules.pn.Impl.PetriNet;
import pn.modules.pn.Impl.Transition;
import pnmodulereachability.Loop;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.Vertex;

public class FinalResultsPanel
extends JPanel {
    private ArrayList<PetriNet> pns;
    private PetriNet pn;
    private FinalResultsDescriptor frd;
    private ArrayList<ILESSolution> results;
    private ArrayList<Integer> examinedVector;
    private ArrayList<MwAutomaton> mws;
    private ArrayList<ArrayList<Loop>> loops;
    private boolean computed;
    private StringBuffer buffer;
    private String gpuresults = "";
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public FinalResultsPanel() {
        this.initComponents();
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet style = kit.getStyleSheet();
        WizardStart.addStyleSheetRules(style);
        this.jTextPane1.setEditorKit(kit);
    }

    public void setDescriptor(FinalResultsDescriptor frd) {
        this.frd = frd;
    }

    public void compute() {
        final PleaseWaitScreen pws = new PleaseWaitScreen(null, true);
        final ModuleImpl entryPoint = ((WizardStart)this.frd.getWizard()).getEntryPoint();
        this.computed = false;
        this.examinedVector = ((WizardStart)this.frd.getWizard()).getExaminedVector();
        this.pn = ((WizardStart)this.frd.getWizard()).getPn();
        this.pns = ((WizardStart)this.frd.getWizard()).getDecomposedPetriNets();
        this.mws = ((WizardStart)this.frd.getWizard()).getMws();
        this.results = new ArrayList();
        this.loops = new ArrayList();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int j = 0;
                FinalResultsPanel.this.buffer = new StringBuffer();
                for (MwAutomaton mw : FinalResultsPanel.this.mws) {
                    if (mw.hasMacroStates()) {
                        FinalResultsPanel.this.loops.add(new ArrayList());
                        ArrayList tmp = FinalResultsPanel.this.getExaminedVector(j);
                        int[] examinedVector = new int[tmp.size()];
                        int i = 0;
                        while (i < examinedVector.length) {
                            examinedVector[i] = (Integer)tmp.get(i);
                            ++i;
                        }
                        ILESSolution str = null;
                        if (mw.getCovering(examinedVector) == mw.getRoot()) {
                            int[] rightSide = new int[examinedVector.length];
                            int i2 = 0;
                            while (i2 < examinedVector.length) {
                                rightSide[i2] = examinedVector[i2] - mw.getCovering(examinedVector).getFirstNonOmegalizedVector()[i2];
                                ++i2;
                            }
                            int[][] matrix = mw.getLoopMatrix(mw.getCovering(examinedVector), (ArrayList)FinalResultsPanel.this.loops.get(FinalResultsPanel.this.loops.size() - 1), null);
                            str = entryPoint.solveLES(matrix, rightSide);
                            if (ExaminedVectorPanel.GPU) {
                                FinalResultsPanel.this.gpuresults = entryPoint.solveLESGPU(matrix, rightSide).toString();
                            }
                            if (ExaminedVectorPanel.GPUREAL) {
                                FinalResultsPanel finalResultsPanel = FinalResultsPanel.this;
                                finalResultsPanel.gpuresults = String.valueOf(finalResultsPanel.gpuresults) + entryPoint.solveLESGPUReal(matrix, rightSide).toString();
                            }
                        } else {
                            ArrayList<ArrayList<Vertex>> pathsToRoot = new ArrayList<ArrayList<Vertex>>();
                            System.out.println("Searching Paths To Root...");
                            mw.fillPathsToRoot(mw.getCovering(examinedVector), pathsToRoot, null);
                            System.out.println("Paths To Root:" + pathsToRoot.size());
                            for (ArrayList<Vertex> path : pathsToRoot) {
                                int[][] matrix = null;
                                int[] rightSide = new int[examinedVector.length];
                                System.arraycopy(examinedVector, 0, rightSide, 0, examinedVector.length);
                                int i3 = 0;
                                while (i3 < examinedVector.length) {
                                    rightSide[i3] = examinedVector[i3] - mw.getRoot().getFirstNonOmegalizedVector()[i3];
                                    ++i3;
                                }
                                int[] pathVector = mw.getPathVectorRepresentation(path);
                                int i4 = 0;
                                while (i4 < examinedVector.length) {
                                    rightSide[i4] = rightSide[i4] - pathVector[i4];
                                    ++i4;
                                }
                                ((ArrayList)FinalResultsPanel.this.loops.get(FinalResultsPanel.this.loops.size() - 1)).clear();
                                matrix = mw.getLoopMatrix(mw.getCovering(examinedVector), (ArrayList)FinalResultsPanel.this.loops.get(FinalResultsPanel.this.loops.size() - 1), path);
                                System.out.println(Arrays.toString(pathVector));
                                System.out.println(Arrays.deepToString((Object[])matrix));
                                System.out.println(Arrays.toString(rightSide));
                                str = entryPoint.solveLES(matrix, rightSide);
                                if (ExaminedVectorPanel.GPU) {
                                    FinalResultsPanel.this.gpuresults = entryPoint.solveLESGPU(matrix, rightSide).toString();
                                }
                                if (ExaminedVectorPanel.GPUREAL) {
                                    FinalResultsPanel finalResultsPanel = FinalResultsPanel.this;
                                    finalResultsPanel.gpuresults = String.valueOf(finalResultsPanel.gpuresults) + entryPoint.solveLESGPUReal(matrix, rightSide).toString();
                                }
                                if (FinalResultsPanel.this.evaluateResutls(str, false)) {
                                    System.out.println("Ma riesenie");
                                    break;
                                }
                                System.out.println("Pre tuto cestu nema riesenie");
                            }
                        }
                        System.out.println("SOLVELES finished\n");
                        System.out.println("Results:" + str.getTextualSolution());
                        FinalResultsPanel.this.jTextPane1.setText(str.toString());
                        if (str != null) {
                            FinalResultsPanel.this.results.add(str);
                        }
                    } else {
                        FinalResultsPanel.this.results.add(null);
                        FinalResultsPanel.this.loops.add(null);
                    }
                    ++j;
                    if (!FinalResultsPanel.this.evaluateResutls((ILESSolution)FinalResultsPanel.this.results.get(FinalResultsPanel.this.results.size() - 1))) break;
                }
                FinalResultsPanel.this.computed = true;
                pws.setVisible(false);
                Transition[] transitionArray = ((FinalResultsPanel)FinalResultsPanel.this).pn.transition;
                int n = ((FinalResultsPanel)FinalResultsPanel.this).pn.transition.length;
                int n2 = 0;
                while (n2 < n) {
                    Transition t = transitionArray[n2];
                    t.dek = 0;
                    ++n2;
                }
            }
        });
        thread.start();
        if (!this.computed) {
            pws.setLocation(this.getLocation().x + this.getWidth() / 2 - pws.getWidth() / 2, this.getLocation().y + this.getHeight() / 2 - pws.getHeight() / 2);
            pws.setVisible(true);
        }
    }

    public boolean evaluateResutls(ILESSolution solution) {
        return this.evaluateResutls(solution, true);
    }

    public boolean evaluateResutls(ILESSolution solution, boolean printResults) {
        StringBuffer str = new StringBuffer();
        boolean temp = true;
        if (solution.getSolution() == null) {
            if (printResults) {
                str.append("System of linear equations has <b>no</b> solution, thus configuration described by examined vector <b>IS NOT REACHABLE</b>.<br>");
            }
            temp = false;
        } else {
            boolean satis = true;
            for (Map.Entry<Integer, Integer> e : solution.getSolution()) {
                if (((Number)e.getValue()).intValue() == 1 && ((Number)e.getKey()).intValue() >= 0) continue;
                satis = false;
                break;
            }
            if (!satis) {
                if (printResults) {
                    str.append("System of linear equations solution <b>is not satisfactory</b>, thus configuration described by examined vector <b>IS NOT REACHABLE</b>.<br>");
                }
                temp = false;
            } else {
                if (printResults) {
                    str.append(solution.getTextualSolution().toString());
                }
                if (printResults) {
                    str.append("<br>System of linear equations has <b>satisfactory</b> solution, thus configuration described by examined vector <b>IS REACHABLE</b>.<br>");
                }
            }
        }
        if (printResults) {
            this.buffer.append(str.toString());
            this.buffer.append(this.gpuresults);
            this.jTextPane1.setText(this.buffer.toString());
        }
        return temp;
    }

    private ArrayList<Integer> getExaminedVector(int subnet) {
        if (this.pns == null) {
            return this.examinedVector;
        }
        ArrayList<Integer> temp = new ArrayList<Integer>();
        PetriNet dpn = null;
        try {
            dpn = this.pns.get(subnet);
            if (dpn != null) {
                for (String place : dpn.getPlaceOrderingAsStrings()) {
                    int j = 0;
                    for (String placeOrig : this.pn.getPlaceOrderingAsStrings()) {
                        if (place.compareTo(placeOrig) == 0) {
                            temp.add(this.examinedVector.get(j));
                        }
                        ++j;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jTextPane1.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 586, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 469, Short.MAX_VALUE).addContainerGap()));
    }
}

