/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import com.jogamp.opencl.CLContext;
import gui.wizard.WizardPanelDescriptor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pn.modules.pn.Impl.PetriNet;

public class ExaminedVectorPanel
extends JPanel {
    private PetriNet pn;
    private ArrayList<JSpinner> spinners;
    private ArrayList<JLabel> labels;
    private WizardPanelDescriptor pd;
    public static boolean GPU;
    public static boolean GPUREAL;
    private static boolean openCLEnabled;
    private ButtonGroup buttonGroup1;
    private JLabel expLabel;
    private JCheckBox gpgpu;
    private JCheckBox gpgpureal;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTextField jTextField1;

    public ExaminedVectorPanel(PetriNet pn) {
        int maxTextWidth = 5;
        this.pn = pn;
        GPU = false;
        GPUREAL = false;
        this.initComponents();
        this.spinners = new ArrayList();
        this.labels = new ArrayList();
        int j = 0;
        for (String s : pn.getPlaceOrderingAsStrings()) {
            JLabel label = new JLabel();
            JSpinner spinner = new JSpinner();
            spinner.setModel(new SpinnerNumberModel(pn.place[j].marking, 0, Integer.MAX_VALUE, 1));
            spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ExaminedVectorPanel.this.spinnerStateChanged();
                }
            });
            label.setText(s);
            this.labels.add(label);
            this.spinners.add(spinner);
            if (maxTextWidth < s.length()) {
                maxTextWidth = s.length();
            }
            ++j;
        }
        if (!this.labels.isEmpty()) {
            maxTextWidth *= this.labels.get(0).getFont().getSize();
        }
        maxTextWidth += 5;
        int i = 0;
        while (i < pn.getPlaceOrderingAsStrings().size()) {
            this.labels.get(i).setSize(maxTextWidth - 5, 20);
            this.labels.get(i).setLocation(10 + maxTextWidth * i, 10);
            this.spinners.get(i).setSize(maxTextWidth - 5, 20);
            this.spinners.get(i).setLocation(10 + maxTextWidth * i, 40);
            this.jPanel1.add(this.labels.get(i));
            this.jPanel1.add(this.spinners.get(i));
            ++i;
        }
        if (this.spinners.size() > 0) {
            this.jPanel1.setPreferredSize(new Dimension(this.spinners.get(this.spinners.size() - 1).getX() + this.spinners.get(this.spinners.size() - 1).getWidth() + 5, this.jPanel1.getHeight()));
            this.spinnerStateChanged();
        }
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExaminedVectorPanel.this.checkExaminedVector();
                if (ExaminedVectorPanel.this.pd != null && ExaminedVectorPanel.this.pd.getWizard() != null) {
                    ExaminedVectorPanel.this.pd.getWizard().resetButtons();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExaminedVectorPanel.this.checkExaminedVector();
                if (ExaminedVectorPanel.this.pd != null && ExaminedVectorPanel.this.pd.getWizard() != null) {
                    ExaminedVectorPanel.this.pd.getWizard().resetButtons();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExaminedVectorPanel.this.checkExaminedVector();
                if (ExaminedVectorPanel.this.pd != null && ExaminedVectorPanel.this.pd.getWizard() != null) {
                    ExaminedVectorPanel.this.pd.getWizard().resetButtons();
                }
            }
        });
        this.jRadioButton1ActionPerformed(null);
        try {
            CLContext cl = CLContext.create();
            openCLEnabled = true;
        }
        catch (Exception ex) {
            System.out.println(ex);
            openCLEnabled = false;
        }
    }

    public void setDescriptor(WizardPanelDescriptor pd) {
        this.pd = pd;
    }

    private boolean checkExaminedVector() {
        int x;
        String str = this.jTextField1.getText();
        if (str.matches("(((\\d)+)[,]){" + (x = this.labels.size() - 1) + "}(\\d)+")) {
            this.jTextField1.setForeground(Color.BLACK);
            return true;
        }
        this.jTextField1.setForeground(Color.RED);
        return false;
    }

    private void spinnerStateChanged() {
        StringBuffer str = new StringBuffer();
        for (JSpinner spinner : this.spinners) {
            str.append(spinner.getValue().toString());
            if (this.spinners.lastIndexOf(spinner) == this.spinners.size() - 1) continue;
            str.append(",");
        }
        this.jTextField1.setText(str.toString());
    }

    public boolean canProceed() {
        if (this.jRadioButton1.isSelected()) {
            return true;
        }
        return this.checkExaminedVector();
    }

    public boolean searchSpecificVector() {
        return !this.jRadioButton1.isSelected();
    }

    public ArrayList<Integer> getExaminedVector() {
        if (!this.searchSpecificVector()) {
            return null;
        }
        if (!this.canProceed()) {
            return null;
        }
        ArrayList<Integer> vector = new ArrayList<Integer>();
        String[] strs = this.jTextField1.getText().split(",");
        int i = 0;
        while (i < strs.length) {
            vector.add(Integer.parseInt(strs[i]));
            ++i;
        }
        return vector;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.gpgpu = new JCheckBox();
        this.gpgpureal = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.expLabel = new JLabel();
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Do NOT search for specific vector, analysis will only generate Mw automaton");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExaminedVectorPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Search for specific vector selected below");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExaminedVectorPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(32);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.jScrollPane1.setAutoscrolls(true);
        this.jPanel1.setAutoscrolls(true);
        this.jPanel1.setPreferredSize(new Dimension(10000, 100));
        this.jPanel1.setLayout(null);
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jTextField1.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ExaminedVectorPanel.this.jTextField1FocusLost(evt);
            }
        });
        this.jLabel1.setText("Examined vector:");
        this.gpgpu.setText("Use GP/GPU computation with Rational");
        this.gpgpu.setEnabled(false);
        this.gpgpu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExaminedVectorPanel.this.gpgpuActionPerformed(evt);
            }
        });
        this.gpgpureal.setText("Use GP/GPU computation with Real");
        this.gpgpureal.setEnabled(false);
        this.gpgpureal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExaminedVectorPanel.this.gpgpurealActionPerformed(evt);
            }
        });
        this.expLabel.setText("Experimental computations:");
        this.expLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addComponent(this.jScrollPane1, -1, 566, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.expLabel).addComponent(this.gpgpu).addComponent(this.gpgpureal)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expLabel).addGap(18, 18, 18).addComponent(this.gpgpu).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gpgpureal).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jLabel1.setEnabled(false);
        this.jScrollPane1.setEnabled(false);
        this.jPanel1.setEnabled(false);
        this.jTextField1.setEnabled(false);
        for (JLabel label : this.labels) {
            label.setEnabled(false);
        }
        for (JSpinner spinner : this.spinners) {
            spinner.setEnabled(false);
        }
        if (this.pd != null && this.pd.getWizard() != null) {
            this.pd.getWizard().resetButtons();
        }
        this.gpgpu.setEnabled(false);
        this.gpgpureal.setEnabled(false);
        this.expLabel.setEnabled(false);
    }

    private void jTextField1FocusLost(FocusEvent evt) {
        int x;
        String str = this.jTextField1.getText();
        if (str.matches("(((\\d)+)[,]){" + (x = this.labels.size() - 1) + "}(\\d)+")) {
            this.jTextField1.setForeground(Color.BLACK);
            String[] strs = str.split(",");
            int i = 0;
            while (i < strs.length) {
                this.spinners.get(i).getModel().setValue(new Integer(strs[i]));
                ++i;
            }
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jLabel1.setEnabled(true);
        this.jScrollPane1.setEnabled(true);
        this.jPanel1.setEnabled(true);
        this.jTextField1.setEnabled(true);
        for (JLabel label : this.labels) {
            label.setEnabled(true);
        }
        for (JSpinner spinner : this.spinners) {
            spinner.setEnabled(true);
        }
        if (this.pd != null && this.pd.getWizard() != null) {
            this.pd.getWizard().resetButtons();
        }
        if (openCLEnabled) {
            this.gpgpu.setEnabled(true);
            this.gpgpureal.setEnabled(true);
            this.expLabel.setEnabled(true);
        }
    }

    private void gpgpurealActionPerformed(ActionEvent evt) {
        GPUREAL = this.gpgpureal.isSelected();
        System.out.println(GPUREAL);
    }

    private void gpgpuActionPerformed(ActionEvent evt) {
        GPU = this.gpgpu.isSelected();
        System.out.println(GPU);
    }
}

