/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import gui.WizardStart;
import gui.descriptors.DecompositionResultsDescriptor;
import gui.utils.CustomDecomposition;
import gui.utils.ImagePanel;
import gui.utils.PleaseWaitScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import pn.modules.pn.Impl.PetriNet;
import pnmodulereachability.MwAutomaton;
import pnmodulereachability.TJuncSplitter;

public class DecompositionResultsPanel
extends JPanel {
    private int tabs = 0;
    private DecompositionResultsDescriptor drd;
    private boolean computed;
    private MwAutomaton mw;
    private JTabbedPane jTabbedPane1;

    public DecompositionResultsPanel() {
        this.initComponents();
        this.tabs = 0;
    }

    public void compute() {
        final PleaseWaitScreen pws = new PleaseWaitScreen(null, true);
        this.mw = null;
        if (((WizardStart)this.drd.getWizard()).getMws() != null && ((WizardStart)this.drd.getWizard()).getMws().size() == 1) {
            this.mw = ((WizardStart)this.drd.getWizard()).getMws().get(0);
        }
        this.computed = false;
        Thread thread = new Thread(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                DecompositionResultsPanel.this.jTabbedPane1.removeAll();
                DecompositionResultsPanel.this.tabs = 0;
                ArrayList<PetriNet> decomposedPns = null;
                if (DecompositionResultsPanel.this.mw != null) {
                    decomposedPns = TJuncSplitter.omegalizationDependantDecomposition(((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getPn(), DecompositionResultsPanel.this.mw);
                } else if (((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).isStructuralDecomposition()) {
                    decomposedPns = TJuncSplitter.structureDependantDecomposition(((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getPn(), ((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).isExactNumberSynTransitions(), ((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getNumberSynTransitions());
                } else if (((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).isCustomDecomposition()) {
                    CustomDecomposition cd = new CustomDecomposition(null, true, ((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getPn());
                    if (!cd.getCustomDecomposition()) {
                        DecompositionResultsPanel.this.drd.getWizard().setCurrentPanel("MW_AUTOMATON_CREATION");
                        DecompositionResultsPanel.this.computed = true;
                        pws.setVisible(false);
                        return;
                    }
                    decomposedPns = TJuncSplitter.customDecompostion(((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getPn());
                } else {
                    decomposedPns = TJuncSplitter.markingDependantDecomposition(((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getPn());
                }
                if (decomposedPns == null) {
                    if (DecompositionResultsPanel.this.mw != null) {
                        JOptionPane.showMessageDialog(null, "Omegalization Dependant decomposition is not applicable.", " T-Junc decomposition not applicable", 1);
                    } else if (((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).isStructuralDecomposition()) {
                        JOptionPane.showMessageDialog(null, "T-Junc decomposition of selected Petri Net with " + ((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getNumberSynTransitions() + " synchronic transitions is not possible.", " T-Junc decomposition not applicable", 1);
                    } else {
                        JOptionPane.showMessageDialog(null, "Initial marking Dependant decomposition is not applicable.", " T-Junc decomposition not applicable", 1);
                    }
                    DecompositionResultsPanel.this.drd.getWizard().setCurrentPanel("MW_AUTOMATON_CREATION");
                } else {
                    for (PetriNet pn : decomposedPns) {
                        DecompositionResultsPanel.this.addImage(((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).getEntryPoint().getPetriNetImage(pn));
                    }
                    if (decomposedPns.size() > 1) {
                        ((WizardStart)DecompositionResultsPanel.this.drd.getWizard()).setDecomposedPetriNets(decomposedPns);
                    }
                }
                DecompositionResultsPanel.this.computed = true;
                pws.setVisible(false);
            }
        });
        thread.start();
        if (!this.computed) {
            pws.setLocation(this.getLocation().x + this.getWidth() / 2 - pws.getWidth() / 2, this.getLocation().y + this.getHeight() / 2 - pws.getHeight() / 2);
            pws.setVisible(true);
        }
    }

    private void addImage(Image image) {
        this.jTabbedPane1.addTab("Decomposed Petri Net " + ++this.tabs, new ImagePanel(image));
    }

    public ArrayList<PetriNet> getPnsToSave() {
        ArrayList<PetriNet> tpns = new ArrayList<PetriNet>();
        int j = 0;
        boolean k = false;
        Component[] componentArray = this.jTabbedPane1.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            if (cmp instanceof ImagePanel) {
                if (((ImagePanel)cmp).isAddToProject()) {
                    tpns.add(((WizardStart)this.drd.getWizard()).getDecomposedPetriNets().get(j));
                }
                ++j;
            }
            ++n2;
        }
        return tpns;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTabbedPane1, "Center");
    }

    public void setDrd(DecompositionResultsDescriptor drd) {
        this.drd = drd;
    }
}

