/*
 * Decompiled with CFR 0.152.
 */
package gui.panels;

import gui.WizardStart;
import gui.descriptors.DecompositionChooserDescriptor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import pnmodulereachability.MwAutomaton;

public class DecompositionChooserPanel
extends JPanel {
    private DecompositionChooserDescriptor dcd;
    private ArrayList<MwAutomaton> mws;
    private ButtonGroup buttonGroup1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public DecompositionChooserPanel() {
        this.initComponents();
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet style = kit.getStyleSheet();
        WizardStart.addStyleSheetRules(style);
        this.jTextPane1.setEditorKit(kit);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jTextPane1.setBackground(UIManager.getDefaults().getColor("Button.background"));
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Do NOT use decomposition");
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecompositionChooserPanel.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("Use T-Junc decomposition (omegalization dependant decompositon)");
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecompositionChooserPanel.this.jRadioButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1).addComponent(this.jScrollPane1, -1, 548, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 158, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addContainerGap(16, Short.MAX_VALUE)));
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.resetButtons();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.resetButtons();
    }

    public boolean isUseDecomposition() {
        return this.jRadioButton2.isSelected();
    }

    private void resetButtons() {
        this.dcd.getWizard().resetButtons();
    }

    public void setDcd(DecompositionChooserDescriptor dcd) {
        this.dcd = dcd;
    }

    public ArrayList<MwAutomaton> getMws() {
        return this.mws;
    }

    public void setMws(ArrayList<MwAutomaton> mws) {
        this.mws = mws;
        DecimalFormat formatter = new DecimalFormat("###,###,###,###,###,###,###,###,###");
        StringBuffer str = new StringBuffer();
        int j = 1;
        for (MwAutomaton mw : mws) {
            long cycles = mw.getTeoreticalLoopNum();
            str.append("<b>MwAutomaton" + j + "</b><br>");
            str.append("Created Mw Automaton has " + mw.getStates().size() + " states and " + mw.getNumberOfTransitions() + " transitions.<br>");
            str.append("<b>Estimated</b> maximum number of simple-loops in this automaton is <b>" + formatter.format(cycles) + "</b>");
            str.append("<hr>");
            ++j;
        }
        if (mws.size() == 1) {
            str.append("<br><br><br>To reduce computation time for simple-loops search application module can employ T-junc decomposition.<br><br>");
            str.append("Would you like to use T-junc decomposition?");
            this.jRadioButton1.setEnabled(true);
            this.jRadioButton2.setEnabled(true);
        } else {
            this.jRadioButton1.setSelected(true);
            this.jRadioButton1.setEnabled(false);
            this.jRadioButton2.setEnabled(false);
        }
        this.jTextPane1.setText(str.toString());
    }
}

