/*
 * Decompiled with CFR 0.152.
 */
package gui.descriptors;

import gui.WizardStart;
import gui.descriptors.ExaminedVectorDescriptor;
import gui.panels.MwAutomatonPanel;
import gui.wizard.WizardPanelDescriptor;
import pn.modules.pn.Impl.PetriNet;
import pnmodulereachability.GraphicMw;

public class MwAutomatonDescriptor
extends WizardPanelDescriptor {
    public static final String IDENTIFIER = "MW_AUTOMATON";
    private MwAutomatonPanel mwap = (MwAutomatonPanel)this.getPanelComponent();
    private boolean finish;
    private boolean ready = false;
    private boolean next = false;

    public MwAutomatonDescriptor(PetriNet pn) {
        super(IDENTIFIER, new MwAutomatonPanel(pn));
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
        this.getWizard().resetButtons();
    }

    @Override
    public Object getNextPanelDescriptor() {
        this.next = true;
        if (!this.ready) {
            return null;
        }
        if (this.finish) {
            return ExaminedVectorDescriptor.FINISH;
        }
        return "DECOMPOSITION_CHOOSER";
    }

    @Override
    public Object getBackPanelDescriptor() {
        this.next = false;
        return "EXAMINED_VECTOR";
    }

    @Override
    public void aboutToDisplayPanel() {
        if (((WizardStart)this.getWizard()).getDecomposedPetriNets() != null) {
            ((MwAutomatonPanel)this.getPanelComponent()).setPns(((WizardStart)this.getWizard()).getDecomposedPetriNets());
        }
        this.mwap.setMad(this);
        this.mwap.setVisualize(((WizardStart)this.getWizard()).isVisualize());
        this.mwap.setEquicheck(((WizardStart)this.getWizard()).isEquicheck());
        this.mwap.setMaxNumStates(((WizardStart)this.getWizard()).getMaxNumStates());
        this.mwap.setSearchSpecificVector(((WizardStart)this.getWizard()).isSearchSpecificVector());
        this.mwap.setExaminedVector(((WizardStart)this.getWizard()).getExaminedVector());
        this.mwap.setBuildPartialMw(((WizardStart)this.getWizard()).isBuildPartialMw());
        this.mwap.setPns(((WizardStart)this.getWizard()).getDecomposedPetriNets());
        this.mwap.setMw(((WizardStart)this.getWizard()).getMws());
        this.mwap.compute();
    }

    @Override
    public void aboutToHidePanel() {
        this.mwap.stopComputation();
        if (this.next) {
            ((WizardStart)this.getWizard()).setMws(((MwAutomatonPanel)this.getPanelComponent()).getMws());
            for (GraphicMw g : ((MwAutomatonPanel)this.getPanelComponent()).getGraphicMws()) {
                PetriNet pn = g.getPnFromMw(null);
                if (pn == null) continue;
                ((WizardStart)this.getWizard()).getEntryPoint().addPetriNetToProject(pn);
            }
        }
    }

    public void setReady(boolean ready) {
        this.ready = ready;
        this.getWizard().resetButtons();
    }
}

