/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pnimport.pnml.PNMLFilter;
import pnimport.pnml.PNMLReader;

public class ModuleImpl
extends JPanel
implements IModule {
    private ArrayList<IPetriNet> petriNets;
    private ArrayList<IResponseListener> responseListeners;
    private JButton jButton1;

    public ModuleImpl() {
        this.initComponents();
        this.petriNets = new ArrayList();
        this.responseListeners = new ArrayList();
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PNML Import module</h1>Authors: Peter Antal, Stefan Korecko</html>";
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/pnimport_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/pnimport_eng.html";
    }

    @Override
    public String getTarget() {
        return "pnimport";
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNets.add(pn);
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new PNMLFilter("Standard, or Tina PNML file"));
        fc.setCurrentDirectory(new File("./"));
        int a = fc.showOpenDialog(null);
        if (a == 0) {
            String filePath = fc.getSelectedFile().getAbsolutePath();
            try {
                PNMLReader rf = new PNMLReader(filePath);
                ArrayList<IPetriNet> pns = rf.getPetriNets();
                int i = 0;
                while (i < pns.size()) {
                    int j = 0;
                    while (j < this.responseListeners.size()) {
                        this.responseListeners.get(j).respond(pns.get(i));
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("error onImportPetriNet: " + e.toString() + "; " + filePath);
            }
        }
    }

    @Override
    public void close() {
        this.petriNets.clear();
    }

    @Override
    public String getName() {
        return "PNML Import";
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Import z PNML";
        }
        if (prefix.equals("_eng")) {
            languageName = "Import from PNML";
        }
        return languageName;
    }

    @Override
    public JComponent getControlPanel() {
        return this;
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/pnimport/icon.png")));
        this.jButton1.setToolTipText("Import from PNML");
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 59, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 37, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.open();
    }
}

