/*
 * Decompiled with CFR 0.152.
 */
package pnopener;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IVertex;
import pn.modules.pn.impl.ArcImpl;
import pn.modules.pn.impl.PetriNetImpl;
import pn.modules.pn.impl.PlaceImpl;
import pn.modules.pn.impl.TransitionImpl;

public class PNMLReader {
    protected File file;
    protected Document doc;
    protected Element root;
    protected ArrayList<IPetriNet> petriNets;
    protected boolean isStandard;
    private String netName;
    private String netID;
    private String netType;

    public PNMLReader(String path) throws Exception {
        this.file = new File(path);
        if (this.file == null) {
            throw new Exception("File not found!");
        }
        this.reset();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.file);
            doc.getDocumentElement().normalize();
            Node main = doc.getElementsByTagName("pnml").item(0);
            this.isStandard = false;
            if (((Element)main).hasAttribute("xmlns") && ((Element)main).getAttribute("xmlns").equals("http://www.pnml.org/version-2009/grammar/pnml")) {
                this.isStandard = true;
            }
            NodeList nodeLst = ((Element)main).getElementsByTagName("net");
            if (this.isStandard) {
                this.netName = ((Element)main).getElementsByTagName("text").item(0).getTextContent();
                this.netID = ((Element)main).getAttribute("id");
                this.netType = ((Element)main).getElementsByTagName("type").item(0).getTextContent();
                NodeList nodeLst2 = ((Element)main).getElementsByTagName("page");
                for (int i = 0; i < nodeLst.getLength(); ++i) {
                    for (int j = 0; j < nodeLst2.getLength(); ++j) {
                        this.readNet(nodeLst2.item(j));
                    }
                }
            } else {
                for (int i = 0; i < nodeLst.getLength(); ++i) {
                    this.readNet(nodeLst.item(i));
                }
            }
        }
        catch (Exception e) {
            System.out.println("error onCreatePNMLReader: " + e.toString());
        }
    }

    public void reset() {
        this.petriNets = new ArrayList();
    }

    public ArrayList<IPetriNet> getPetriNets() {
        return this.petriNets;
    }

    private void readNet(Node node) {
        if (node.getNodeType() == 1) {
            int i;
            Element element = (Element)node;
            if (!this.isStandard) {
                this.netName = ((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("text").item(0).getTextContent();
                this.netID = element.getAttribute("id");
                this.netType = element.getAttribute("type");
            }
            PetriNetImpl pn = new PetriNetImpl(this.netName, this.netID, this.netType);
            NodeList nodes = element.getElementsByTagName("place");
            for (i = 0; i < nodes.getLength(); ++i) {
                this.readPlace(nodes.item(i), pn);
            }
            nodes = element.getElementsByTagName("transition");
            for (i = 0; i < nodes.getLength(); ++i) {
                this.readTransition(nodes.item(i), pn);
            }
            nodes = element.getElementsByTagName("arc");
            for (i = 0; i < nodes.getLength(); ++i) {
                this.readArc(nodes.item(i), pn);
            }
            Properties p = new Properties();
            nodes = element.getElementsByTagName("toolspecific");
            if (nodes.getLength() > 0 && ((Element)nodes.item(0)).getElementsByTagName("mwAutomaton").getLength() > 0) {
                Element e = (Element)((Element)nodes.item(0)).getElementsByTagName("mwAutomaton").item(0);
                p.put("mwAutomaton", e);
            }
            pn.setAdditionalData(p);
            this.petriNets.add(pn);
        }
    }

    private void readPlace(Node node, PetriNetImpl pn) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String id = element.getAttribute("id");
            String name = "";
            double namex = 0.0;
            double namey = 0.0;
            String color = "rgb(255,255,255);";
            try {
                name = ((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("text").item(0).getTextContent();
            }
            catch (Exception e) {
                // empty catch block
            }
            int imarking = 0;
            try {
                imarking = Integer.valueOf(((Element)element.getElementsByTagName("initialMarking").item(0)).getElementsByTagName("text").item(0).getTextContent());
            }
            catch (Exception e) {
                // empty catch block
            }
            double x = Double.valueOf(element.getElementsByTagName("position").item(0).getAttributes().getNamedItem("x").getTextContent());
            double y = Double.valueOf(element.getElementsByTagName("position").item(0).getAttributes().getNamedItem("y").getTextContent());
            try {
                namex = x + Double.valueOf(((Element)((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("x").getNodeValue());
                namey = y + Double.valueOf(((Element)((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("y").getNodeValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                color = element.getElementsByTagName("fill").item(0).getAttributes().getNamedItem("color").getTextContent();
            }
            catch (Exception e) {
                // empty catch block
            }
            Properties props = new Properties();
            try {
                Pattern pattern = Pattern.compile("(\\s*rgb\\s*\\(\\s*)|(\\s*[,]\\s*)|[\\s*)\\s*]");
                String[] rgb = pattern.split(color);
                int r = Integer.valueOf(rgb[1]);
                int g = Integer.valueOf(rgb[2]);
                int b = Integer.valueOf(rgb[3]);
                props.put("Color", new Color((r << 16) + (g << 8) + b));
            }
            catch (Exception e) {
                // empty catch block
            }
            PlaceImpl p = new PlaceImpl(id, name, namex, namey, x, y, imarking);
            String type = null;
            if (pn.getType().equals("EvPN") && element.getElementsByTagName("evpnPlace").item(0) != null) {
                type = ((Element)element.getElementsByTagName("evpnPlace").item(0)).getAttributes().getNamedItem("type").getNodeValue();
                p.setType(type);
                if (type.equals("pf")) {
                    props.put("EvPN Pf", ((Element)element.getElementsByTagName("evpnPlace").item(0)).getElementsByTagName("exp").item(0).getTextContent());
                }
                if (type.equals("pe")) {
                    props.put("EvPN Pe", ((Element)element.getElementsByTagName("evpnPlace").item(0)).getElementsByTagName("exp").item(0).getTextContent());
                }
            }
            if (pn.getType().equals("TB") && element.getElementsByTagName("tbPlace").getLength() > 0) {
                NodeList ns = element.getElementsByTagName("token");
                ArrayList<double[]> tokens = new ArrayList<double[]>();
                for (int i = 0; i < ns.getLength(); ++i) {
                    int min = Integer.valueOf(ns.item(i).getAttributes().getNamedItem("minValue").getTextContent());
                    int max = Integer.valueOf(ns.item(i).getAttributes().getNamedItem("maxValue").getTextContent());
                    tokens.add(new double[]{min, max});
                }
                props.put("TB Tokens", tokens);
            }
            p.setAdditionalData(props);
            pn.addPlace(p);
        }
    }

    private void readTransition(Node node, PetriNetImpl pn) {
        if (node.getNodeType() == 1) {
            NodeList ns;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            String name = "";
            double namex = 0.0;
            double namey = 0.0;
            String color = "rgb(255,255,255);";
            try {
                name = ((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("text").item(0).getTextContent();
            }
            catch (Exception e) {
                // empty catch block
            }
            double x = Double.valueOf(element.getElementsByTagName("position").item(0).getAttributes().getNamedItem("x").getTextContent());
            double y = Double.valueOf(element.getElementsByTagName("position").item(0).getAttributes().getNamedItem("y").getTextContent());
            try {
                namex = x + Double.valueOf(((Element)((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("x").getNodeValue());
                namey = y + Double.valueOf(((Element)((Element)element.getElementsByTagName("name").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("y").getNodeValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                color = element.getElementsByTagName("fill").item(0).getAttributes().getNamedItem("color").getTextContent();
            }
            catch (Exception e) {
                // empty catch block
            }
            Properties props = new Properties();
            try {
                Pattern pattern = Pattern.compile("(\\s*rgb\\s*\\(\\s*)|(\\s*[,]\\s*)|[\\s*)\\s*]");
                String[] rgb = pattern.split(color);
                int r = Integer.valueOf(rgb[1]);
                int g = Integer.valueOf(rgb[2]);
                int b = Integer.valueOf(rgb[3]);
                props.put("Color", new Color((r << 16) + (g << 8) + b));
            }
            catch (Exception e) {
                // empty catch block
            }
            TransitionImpl t = new TransitionImpl(id, name, namex, namey, x, y);
            if (pn.getType().equals("TB") && element.getElementsByTagName("tbTransition").getLength() > 0 && (ns = element.getElementsByTagName("tbFunction")).getLength() > 0) {
                String f = ns.item(0).getTextContent();
                props.put("TB Function", f);
            }
            t.setAdditionalData(props);
            pn.addTransition(t);
        }
    }

    private void readArc(Node node, PetriNetImpl pn) {
        if (node.getNodeType() == 1) {
            IVertex v1;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            String source = element.getAttribute("source");
            String target = element.getAttribute("target");
            int count = 1;
            int countx = 0;
            int county = 0;
            try {
                count = Integer.valueOf(((Element)element.getElementsByTagName("inscription").item(0)).getElementsByTagName("text").item(0).getTextContent());
                countx = Integer.valueOf(((Element)((Element)element.getElementsByTagName("inscription").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("x").getTextContent());
                county = Integer.valueOf(((Element)((Element)element.getElementsByTagName("inscription").item(0)).getElementsByTagName("graphics").item(0)).getElementsByTagName("offset").item(0).getAttributes().getNamedItem("y").getTextContent());
            }
            catch (Exception e) {
                // empty catch block
            }
            NodeList ns = element.getElementsByTagName("position");
            ArrayList<double[]> knots = new ArrayList<double[]>();
            for (int i = 0; i < ns.getLength(); ++i) {
                double x = Double.valueOf(ns.item(i).getAttributes().getNamedItem("x").getTextContent());
                double y = Double.valueOf(ns.item(i).getAttributes().getNamedItem("y").getTextContent());
                knots.add(new double[]{x, y});
            }
            Properties p = new Properties();
            if (element.getElementsByTagName("evpnArc").getLength() > 0) {
                NodeList nodes;
                String type = ((Element)element.getElementsByTagName("evpnArc").item(0)).getAttributes().getNamedItem("type").getTextContent();
                if (type.equals("d")) {
                    p.put("EvPN d", Boolean.TRUE);
                }
                if (type.equals("omega")) {
                    p.put("EvPN w", (Object)-1);
                }
                if (type.equals("c")) {
                    p.put("EvPN w", Integer.valueOf(((Element)element.getElementsByTagName("evpnArc").item(0)).getElementsByTagName("capacity").item(0).getTextContent()));
                }
                if ((nodes = element.getElementsByTagName("relPlace")).getLength() > 0) {
                    Element relPlace = (Element)nodes.item(0);
                    p.put("EvPN Function", relPlace.getTextContent());
                }
            }
            if ((v1 = this.findVertex(source, pn)) == null) {
                System.out.println("error onImportPetriNet: cannot find vertex with id " + source);
                return;
            }
            IVertex v2 = this.findVertex(target, pn);
            if (v2 == null) {
                System.out.println("error onImportPetriNet: cannot find vertex with id " + target);
                return;
            }
            ArcImpl a = new ArcImpl(knots, v1, v2, id, count, countx, county);
            a.setAdditionalData(p);
            pn.addArc(a);
        }
    }

    private IVertex findVertex(String id, PetriNetImpl pn) {
        int i;
        for (i = 0; i < pn.getPlaces().size(); ++i) {
            if (!pn.getPlaces().get(i).getId().equals(id)) continue;
            return pn.getPlaces().get(i);
        }
        for (i = 0; i < pn.getTransitions().size(); ++i) {
            if (!pn.getTransitions().get(i).getId().equals(id)) continue;
            return pn.getTransitions().get(i);
        }
        return null;
    }
}

