/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.util.ArrayList;
import javax.swing.JComponent;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;
import pnopener.PNMLReader;

public class ModuleImpl
implements IModule {
    private String dirPath;
    private String filePath;
    private ArrayList<IPetriNet> petriNets = new ArrayList();
    private ArrayList<IResponseListener> responseListeners = new ArrayList();

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PN module that opens Petri Nets</h1>This module is hidden, but it is essential for PNTool2.1.<BR><BR>Author: Peter Antal</html>";
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
        this.petriNets.add(pn);
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
        String rgx = "set fname ";
        if (command.startsWith(rgx)) {
            this.filePath = command.substring(rgx.length());
        }
    }

    @Override
    public void open() {
        try {
            PNMLReader rf = new PNMLReader(this.filePath);
            ArrayList<IPetriNet> pns = rf.getPetriNets();
            for (int i = 0; i < pns.size(); ++i) {
                for (int j = 0; j < this.responseListeners.size(); ++j) {
                    this.responseListeners.get(j).respond(pns.get(i));
                }
            }
        }
        catch (Exception e) {
            System.out.println("error onOpenPetriNet: " + e.toString() + "; " + this.filePath);
        }
    }

    @Override
    public void close() {
        this.petriNets.clear();
    }

    @Override
    public String getName() {
        return "PNML Opener";
    }

    @Override
    public JComponent getControlPanel() {
        return null;
    }

    @Override
    public String getHTMLHelpSK() {
        return null;
    }

    @Override
    public String getHTMLHelpENG() {
        return null;
    }

    @Override
    public String getTarget() {
        return null;
    }

    @Override
    public String getName(String prefix) {
        return null;
    }
}

