/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import pn.BFrame;
import pn.SelectDialog;
import pn.modules.IModule;
import pn.modules.IResponseListener;
import pn.modules.pn.IPetriNet;

public class ModuleImpl
extends JPanel
implements IModule {
    private ArrayList<IResponseListener> responseListeners;
    BFrame mainFrame;
    SelectDialog selectDialog;
    private JButton button;

    public ModuleImpl() {
        this.initComponents();
    }

    @Override
    public void addPetriNet(IPetriNet pn) {
    }

    @Override
    public String getHTMLDescription() {
        return "<html><h1>PN to B-AMN conversion module</h1><p>&nbsp;</p><p>This module provides functionality for converting Generalized Petri Nets (GPN) and Evaluative Petri Nets (EvPN) to B-Abstract Machines (B-AMN).</p><p>&nbsp;</p><p>&nbsp;</p><p>Author: Peter Kostov\u010d\u00edk</p>";
    }

    @Override
    public void addResponseListener(IResponseListener r) {
        if (this.responseListeners == null) {
            this.responseListeners = new ArrayList();
        }
        this.responseListeners.add(r);
    }

    @Override
    public void executeCommand(String command) {
    }

    @Override
    public void open() {
        if (this.responseListeners.get(0).requestPetriNets() == null) {
            JOptionPane.showMessageDialog(this.getParent().getParent(), "No Petri Net selected. Please select or create a net.", "No net selected", 2);
        } else if (!this.responseListeners.get(0).requestPetriNets().get(0).getType().equals("TB")) {
            this.selectDialog = new SelectDialog((Frame)this.mainFrame, true);
            this.selectDialog.setLocationRelativeTo(this.mainFrame);
            if (this.responseListeners.get(0).requestPetriNets().get(0).getType().equals("GPN")) {
                this.selectDialog.setGPNstuff();
            }
            this.selectDialog.setVisible(true);
            if (!this.selectDialog.canceled) {
                this.mainFrame = new BFrame(this.responseListeners.get(0).requestPetriNets().get(0), this.selectDialog.func, this.selectDialog.deadlock);
                this.mainFrame.setVisible(true);
                this.mainFrame.setDefaultCloseOperation(2);
            }
            this.selectDialog.dispose();
        } else {
            JOptionPane.showMessageDialog(this.getParent().getParent(), "The selected Petri Net is not an EvPN or GPN", "Wrong Petri Net", 2);
        }
    }

    @Override
    public void close() {
        this.mainFrame.setVisible(false);
    }

    @Override
    public String getName() {
        return "PN to B-AMN conversion";
    }

    @Override
    public JComponent getControlPanel() {
        return this;
    }

    private void initComponents() {
        this.button = new JButton();
        this.button.setFont(new Font("Tahoma", 1, 12));
        this.button.setIcon(new ImageIcon(this.getClass().getResource("/pn/img/button.png")));
        this.button.setToolTipText("PN to B-AMN conversion");
        this.button.setMargin(new Insets(2, 5, 2, 5));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ModuleImpl.this.buttonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.button, -2, 63, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.button, -2, 29, Short.MAX_VALUE));
    }

    private void buttonActionPerformed(ActionEvent evt) {
        this.open();
    }

    @Override
    public String getName(String prefix) {
        String languageName = null;
        if (prefix.equals("_sk")) {
            languageName = "Konverzia z PN do B-AMN";
        }
        if (prefix.equals("_eng")) {
            languageName = "PN to B-AMN conversion";
        }
        return languageName;
    }

    @Override
    public String getHTMLHelpSK() {
        return "modules/modulesHelp/bamn_sk.html";
    }

    @Override
    public String getHTMLHelpENG() {
        return "modules/modulesHelp/bamn_eng.html";
    }

    @Override
    public String getTarget() {
        return "bamn";
    }
}

