/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import pn.Definition;
import pn.Operation;
import pn.modules.pn.IArc;
import pn.modules.pn.IPetriNet;
import pn.modules.pn.IPlace;
import pn.modules.pn.ITransition;
import pn.modules.pn.IVertex;
import pn.modules.pn.impl.PlaceImpl;

public class BMachine {
    private IPetriNet net;
    String header;
    ArrayList<String> variables = new ArrayList();
    ArrayList<String> invariant = new ArrayList();
    ArrayList<Definition> definitions = new ArrayList();
    ArrayList<String> initialisation = new ArrayList();
    ArrayList<Operation> operations = new ArrayList();
    boolean func;
    boolean deadlock;

    public BMachine(boolean func, boolean deadlock) {
        this.func = func;
        this.deadlock = deadlock;
    }

    public void buildFromPN(IPetriNet net) {
        this.net = net;
        this.generateHeader();
        this.generateVariables();
        this.generateInvariant();
        if (net.getType().equals("EvPN") && this.func) {
            this.generateDefinitions();
        }
        this.generateInitialisation();
        this.generateOperations();
    }

    private void generateHeader() {
        this.header = this.net.getName();
    }

    private void generateVariables() {
        if (!this.net.getType().equals("EvPN")) {
            for (IPlace place : this.net.getPlaces()) {
                this.variables.add(this.getPlaceName(place));
            }
        } else {
            for (IPlace place : this.net.getPlaces()) {
                String type = place.getType();
                if (!type.equals("pe") && !type.equals("pf")) {
                    this.variables.add(this.getPlaceName(place));
                    continue;
                }
                if (this.func) continue;
                this.variables.add("@" + this.getPlaceName(place));
            }
        }
    }

    private void generateInvariant() {
        for (IPlace place : this.net.getPlaces()) {
            Boolean dArc = false;
            Boolean wArc = true;
            int capacity = 0;
            int newCapacity = 0;
            ArrayList<IArc> arcs = this.findAllPostArcs(this.net, place);
            if (this.net.getType().equals("EvPN")) {
                Properties props;
                Iterator<IArc> i$;
                if (!arcs.isEmpty()) {
                    IArc postArc;
                    i$ = arcs.iterator();
                    while (i$.hasNext() && !(dArc = (Boolean)(props = (Properties)(postArc = i$.next()).getAdditionalData()).get("EvPN d")).booleanValue()) {
                    }
                }
                arcs = this.findAllPreArcs(this.net, place);
                if (!dArc.booleanValue() && !arcs.isEmpty()) {
                    IArc preArc;
                    i$ = arcs.iterator();
                    while (i$.hasNext() && !(dArc = (Boolean)(props = (Properties)(preArc = i$.next()).getAdditionalData()).get("EvPN d")).booleanValue()) {
                    }
                }
                if (!arcs.isEmpty()) {
                    for (IArc preArc : arcs) {
                        props = (Properties)preArc.getAdditionalData();
                        newCapacity = (Integer)props.get("EvPN w");
                        if (newCapacity > capacity) {
                            capacity = newCapacity;
                        }
                        if (capacity > 0) {
                            wArc = false;
                        }
                        if (newCapacity != -1) continue;
                        wArc = true;
                        break;
                    }
                }
            }
            String newInvariant = dArc != false ? this.getPlaceName(place) + ":INT " : this.getPlaceName(place) + ":NAT ";
            if (!wArc.booleanValue()) {
                newInvariant = newInvariant.concat(" & " + this.getPlaceName(place) + " &lt= " + capacity);
            }
            if (this.net.getType().equals("EvPN") && this.func) {
                if (place.getType().equals("pe") || place.getType().equals("pf")) continue;
                this.invariant.add(newInvariant);
                continue;
            }
            this.invariant.add(newInvariant);
        }
    }

    private void generateDefinitions() {
        int fncs = 0;
        int grds = 0;
        for (IPlace place : this.net.getPlaces()) {
            String type = place.getType();
            String peFnc = null;
            Properties prop = (Properties)place.getAdditionalData();
            if (type.equals("pe")) {
                peFnc = prop.get("EvPN Pe").toString();
            } else if (type.equals("pf")) {
                peFnc = prop.get("EvPN Pf").toString();
            }
            if (peFnc == null) continue;
            if (this.isGrd(peFnc)) {
                this.definitions.add(new Definition("grd_" + ++grds, peFnc, true, place));
                continue;
            }
            this.definitions.add(new Definition("fnc_" + ++fncs, peFnc, false, place));
        }
    }

    private void generateInitialisation() {
        for (IPlace place : this.net.getPlaces()) {
            place = (PlaceImpl)place;
            if (this.net.getType().equals("EvPN") && this.func) {
                if (place.getType().equals("pe") || place.getType().equals("pf")) continue;
                this.initialisation.add(this.getPlaceName(place) + " := " + place.getTokens());
                continue;
            }
            this.initialisation.add(this.getPlaceName(place) + " := " + place.getTokens());
        }
    }

    private void generateOperations() {
        for (ITransition trans : this.net.getTransitions()) {
            Object obj;
            Operation operation = new Operation();
            if (trans.getName().equals("")) {
                if (trans.getId().startsWith("T")) {
                    operation.setName("op_" + trans.getId().substring(1));
                } else {
                    operation.setName(trans.getId());
                }
            } else if (trans.getName().startsWith("T")) {
                operation.setName("op_" + trans.getId().substring(1));
            } else {
                operation.setName(trans.getName());
            }
            ArrayList<IArc> preArcList = this.findAllPreArcs(this.net, trans);
            for (IArc arc : preArcList) {
                PlaceImpl placeImpl = (PlaceImpl)arc.getStartingVertex();
                Boolean dArc = false;
                String fncName = null;
                Properties props = null;
                String arcF = "1";
                if (this.net.getType().equals("EvPN")) {
                    props = (Properties)arc.getAdditionalData();
                    dArc = (Boolean)props.get("EvPN d");
                    if (this.func) {
                        fncName = this.findFncOrGnd(placeImpl);
                    }
                }
                if (dArc.booleanValue()) continue;
                if (this.net.getType().equals("EvPN")) {
                    obj = null;
                    obj = props.get("EvPN Function");
                    if (obj != null) {
                        arcF = props.get("EvPN Function").toString();
                    }
                }
                String count = arcF.equals("1") ? String.valueOf(arc.getCount()) : (arc.getCount() == 1 ? arcF : arc.getCount() + "*" + arcF);
                if (fncName == null) {
                    operation.addSelect(this.getPlaceName(placeImpl) + " >= " + count);
                    continue;
                }
                if (fncName.contains("grd")) {
                    operation.addSelect(fncName);
                    continue;
                }
                operation.addSelect(fncName + " >= " + count);
            }
            ArrayList<IArc> postArcList = this.findAllPostArcs(this.net, trans);
            if (this.net.getType().equals("EvPN")) {
                for (IArc iArc : postArcList) {
                    Properties props = (Properties)iArc.getAdditionalData();
                    int capacity = (Integer)props.get("EvPN w");
                    if (capacity <= 0) continue;
                    IPlace postPlace = (IPlace)iArc.getEndingVertex();
                    operation.addSelect(this.getPlaceName(postPlace) + " &lt " + capacity);
                }
            }
            for (IPlace iPlace : this.net.getPlaces()) {
                String arcF;
                Properties props;
                Boolean isPrePlace = this.isPrePlace(preArcList, iPlace);
                Boolean isPostPlace = this.isPostPlace(postArcList, iPlace);
                if (this.findFncOrGnd(iPlace) != null || !isPostPlace.booleanValue() && !isPrePlace.booleanValue()) continue;
                String then = this.getPlaceName(iPlace) + " := " + this.getPlaceName(iPlace);
                if (isPrePlace.booleanValue()) {
                    props = null;
                    arcF = "1";
                    ArrayList<IArc> arcs = this.findAllPostArcs(this.net, iPlace);
                    IArc arc = null;
                    for (IArc newArc : arcs) {
                        if (!newArc.getEndingVertex().equals(trans)) continue;
                        arc = newArc;
                        break;
                    }
                    if (this.net.getType().equals("EvPN")) {
                        props = (Properties)arc.getAdditionalData();
                        Object obj2 = null;
                        obj2 = props.get("EvPN Function");
                        if (obj2 != null) {
                            arcF = props.get("EvPN Function").toString();
                        }
                    }
                    String count = arcF.equals("1") ? String.valueOf(arc.getCount()) : (arc.getCount() == 1 ? arcF : arc.getCount() + "*" + arcF);
                    then = then.concat(" - " + count);
                }
                if (isPostPlace.booleanValue()) {
                    props = null;
                    arcF = "1";
                    obj = null;
                    ArrayList<IArc> arcs = this.findAllPreArcs(this.net, iPlace);
                    IArc arc = null;
                    for (IArc newArc : arcs) {
                        if (!newArc.getStartingVertex().equals(trans)) continue;
                        arc = newArc;
                        break;
                    }
                    if (this.net.getType().equals("EvPN")) {
                        props = (Properties)arc.getAdditionalData();
                        obj = props.get("EvPN Function");
                    }
                    if (obj != null) {
                        arcF = props.get("EvPN Function").toString();
                    }
                    String count = arcF.equals("1") ? String.valueOf(arc.getCount()) : (arc.getCount() == 1 ? arcF : arc.getCount() + "*" + arcF);
                    then = then.concat(" + " + count);
                }
                operation.addThen(then);
            }
            if (operation == null) continue;
            this.operations.add(operation);
        }
    }

    public boolean isGrd(String value) {
        if (value != null) {
            return value.contains("<") || value.contains(">") || value.contains("=");
        }
        return false;
    }

    private ArrayList<IArc> findAllPreArcs(IPetriNet net, IVertex vertex) {
        ArrayList<IArc> arcList = new ArrayList<IArc>();
        for (IArc arc : net.getArcs()) {
            if (!arc.getEndingVertex().equals(vertex)) continue;
            arcList.add(arc);
        }
        return arcList;
    }

    private ArrayList<IArc> findAllPostArcs(IPetriNet net, IVertex vertex) {
        ArrayList<IArc> arcList = new ArrayList<IArc>();
        for (IArc arc : net.getArcs()) {
            if (!arc.getStartingVertex().equals(vertex)) continue;
            arcList.add(arc);
        }
        return arcList;
    }

    private String findFncOrGnd(IPlace place) {
        for (Definition def : this.definitions) {
            if (!def.getPlace().equals(place)) continue;
            return def.getName();
        }
        return null;
    }

    private boolean isPrePlace(ArrayList<IArc> preArcs, IPlace place) {
        for (IArc arc : preArcs) {
            if (!arc.getStartingVertex().equals(place)) continue;
            return true;
        }
        return false;
    }

    private boolean isPostPlace(ArrayList<IArc> postArcs, IPlace place) {
        for (IArc arc : postArcs) {
            if (!arc.getEndingVertex().equals(place)) continue;
            return true;
        }
        return false;
    }

    private String getPlaceName(IPlace place) {
        if (!place.getName().equals("")) {
            String name = place.getName();
            name = name.replaceAll("[^a-zA-Z0-9_]", "");
            return name;
        }
        String name = place.getId();
        name = name.replaceAll("[^a-zA-Z0-9_]", "");
        return name;
    }
}

