/*
 * Decompiled with CFR 0.152.
 */
package pn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import pn.BMachine;
import pn.Definition;
import pn.Operation;
import pn.modules.pn.IPetriNet;

public class BFrame
extends JFrame {
    int x;
    int y;
    IPetriNet pNet;
    BMachine machine;
    boolean deadlock;
    private JButton closeButton;
    private JScrollPane jScrollPane1;
    private JButton saveButton;
    private JLabel textLable;
    private JTextPane textPane;

    public BFrame(IPetriNet net, boolean func, boolean deadlock) {
        this.pNet = net;
        this.deadlock = deadlock;
        this.initComponents();
        this.setTitle("B-AMN for " + net.getType() + ": " + net.getName());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        this.x = (dim.width - w) / 2;
        this.y = (dim.height - h) / 2;
        this.setLocation(this.x, this.y);
        this.machine = new BMachine(func, deadlock);
        this.machine.buildFromPN(net);
        this.textPane.setText(this.buildOutput(this.machine));
        this.textPane.setCaretPosition(0);
    }

    private String buildOutput(BMachine machine) {
        String output = "<html><dl>";
        output = output.concat("<dt>MACHINE " + machine.header + "</dt><dd>&nbsp;</dd>");
        output = output.concat("<dt>VARIABLES</dt><dd>");
        String last = machine.variables.get(machine.variables.size() - 1);
        for (String var : machine.variables) {
            if (var.startsWith("@")) continue;
            if (!var.equals(last)) {
                output = output.concat(var + ", ");
                continue;
            }
            if (this.getFuncVariables() == null) {
                output = output.concat(var + "</dd><dt>&nbsp;</dt>");
                continue;
            }
            output = output.concat(var + ",</dd><dd>");
            output = output.concat(this.getFuncVariables());
        }
        output = output.concat("<dt>INVARIANT</dt><dd>");
        last = machine.invariant.get(machine.invariant.size() - 1);
        for (String inv : machine.invariant) {
            if (!this.deadlock) {
                if (!inv.equals(last)) {
                    output = output.concat(inv + "& ");
                    continue;
                }
                output = output.concat(inv + "</dd><dt>&nbsp;</dt>");
                continue;
            }
            if (!inv.equals(last)) {
                output = output.concat(inv + "& ");
                continue;
            }
            output = output.concat(inv + "& </dd><dd>( ");
            Operation lastOp = machine.operations.get(machine.operations.size() - 1);
            for (Operation op : machine.operations) {
                if (op.getSelectList().isEmpty()) continue;
                output = output.concat("(");
                last = op.getSelectList().get(op.getSelectList().size() - 1);
                for (String select : op.getSelectList()) {
                    if (!select.equals(last)) {
                        output = output.concat(select + " & ");
                        continue;
                    }
                    if (this.hasMoreSelects(op)) {
                        output = output.concat(select + ") or ");
                        continue;
                    }
                    output = output.concat(select + ") ");
                }
            }
            output = output.concat(")</dd><dt>&nbsp;</dt>");
        }
        if (machine.definitions.size() != 0) {
            output = output.concat("<dt>DEFINITIONS</dt>");
            Definition lastDef = machine.definitions.get(machine.definitions.size() - 1);
            for (Definition def : machine.definitions) {
                if (!def.equals(lastDef)) {
                    output = output.concat("<dd>" + def.getName() + " == " + def.getBody() + ";</dd>");
                    continue;
                }
                output = output.concat("<dd>" + def.getName() + " == " + def.getBody() + "</dd>");
            }
            output = output.concat("<dt>&nbsp;</dt>");
        }
        output = output.concat("<dt>INITIALISATION</dt><dd>");
        last = machine.initialisation.get(machine.initialisation.size() - 1);
        for (String init : machine.initialisation) {
            if (!init.equals(last)) {
                output = output.concat(init + " || ");
                continue;
            }
            output = output.concat(init + "</dd><dt>&nbsp;</dt>");
        }
        output = output.concat("<dt>OPERATIONS</dt>");
        Operation lastOp = machine.operations.get(machine.operations.size() - 1);
        for (Operation op : machine.operations) {
            output = output.concat("<dd>" + op.getName() + " =</dd>");
            if (!op.getSelectList().isEmpty()) {
                output = output.concat("<dd>SELECT ");
                last = op.getSelectList().get(op.getSelectList().size() - 1);
                for (String select : op.getSelectList()) {
                    if (!select.equals(last)) {
                        output = output.concat(select + " & ");
                        continue;
                    }
                    output = output.concat(select + " THEN</dd>");
                }
            } else {
                output = output.concat("<dd>BEGIN</dd> ");
            }
            if (op.getThenList().isEmpty()) continue;
            last = op.getThenList().get(op.getThenList().size() - 1);
            output = output.concat("<dd>");
            for (String then : op.getThenList()) {
                if (!then.equals(last)) {
                    output = output.concat(then + " || ");
                    continue;
                }
                output = output.concat(then + "</dd>");
                if (!op.equals(lastOp)) {
                    output = output.concat("<dd>END;</dd>");
                    output = output.concat("<dt>&nbsp;</dt>");
                    continue;
                }
                output = output.concat("<dd>END</dd>");
            }
        }
        output = output.concat("<dt>END</dt></dl></html>");
        return output;
    }

    private boolean hasMoreSelects(Operation op) {
        boolean moreSelects = false;
        boolean wasThisOper = false;
        for (Operation oper : this.machine.operations) {
            if (wasThisOper && !oper.getSelectList().isEmpty()) {
                moreSelects = true;
            }
            if (!oper.equals(op)) continue;
            wasThisOper = true;
        }
        return moreSelects;
    }

    private String getFuncVariables() {
        String variables = "";
        ArrayList<String> funcVars = new ArrayList<String>(){};
        for (String var : this.machine.variables) {
            if (!var.startsWith("@")) continue;
            funcVars.add(var.substring(1));
        }
        if (!funcVars.isEmpty()) {
            String last = (String)funcVars.get(funcVars.size() - 1);
            for (String var : funcVars) {
                if (!var.equals(last)) {
                    variables = variables.concat(var + ", ");
                    continue;
                }
                variables = variables.concat(var + "</dd><dt>&nbsp;</dt>");
            }
        } else {
            return null;
        }
        return variables;
    }

    private void save() {
        FileWriter writer = null;
        try {
            JFileChooser fc = new JFileChooser();
            File file = new File(this.pNet.getName() + ".mch");
            fc.setCurrentDirectory(new File("./"));
            fc.setSelectedFile(file);
            int a = fc.showSaveDialog(null);
            if (a != 0) {
                return;
            }
            String fname = fc.getSelectedFile().getAbsolutePath();
            writer = new FileWriter(fname);
            PrintWriter printWriter = new PrintWriter(writer);
            printWriter.println("/* This B-Machine was generated from PNTool2 by the PNtoBAMN plugin */");
            printWriter.println();
            printWriter.println("MACHINE " + this.machine.header);
            printWriter.println();
            printWriter.println("VARIABLES");
            String last = this.machine.variables.get(this.machine.variables.size() - 1);
            String output = "";
            for (String var : this.machine.variables) {
                if (!var.equals(last)) {
                    if (var.startsWith("@")) {
                        var = var.substring(1);
                    }
                    output = output.concat(var + ", ");
                    continue;
                }
                if (var.startsWith("@")) {
                    var = var.substring(1);
                }
                output = output.concat(var);
            }
            printWriter.println(output);
            printWriter.println();
            printWriter.println("INVARIANT");
            last = this.machine.invariant.get(this.machine.invariant.size() - 1);
            output = "";
            for (String inv : this.machine.invariant) {
                if (!this.deadlock) {
                    if (!inv.equals(last)) {
                        inv = inv.replace("&lt", "<");
                        output = output.concat(inv + " & ");
                        continue;
                    }
                    inv = inv.replace("&lt", "<");
                    output = output.concat(inv);
                    continue;
                }
                if (!inv.equals(last)) {
                    inv = inv.replace("&lt", "<");
                    output = output.concat(inv + "& ");
                    continue;
                }
                inv = inv.replace("&lt", "<");
                output = output.concat(inv + "&");
                printWriter.println(output);
                output = "( ";
                Operation lastOp = this.machine.operations.get(this.machine.operations.size() - 1);
                for (Operation op : this.machine.operations) {
                    if (op.getSelectList().isEmpty()) continue;
                    output = output.concat("(");
                    last = op.getSelectList().get(op.getSelectList().size() - 1);
                    for (String select : op.getSelectList()) {
                        if (!select.equals(last)) {
                            output = output.concat(select + " & ");
                            continue;
                        }
                        if (this.hasMoreSelects(op)) {
                            output = output.concat(select + ") or ");
                            continue;
                        }
                        output = output.concat(select + ") ");
                    }
                }
                output = output.concat(")");
            }
            printWriter.println(output);
            printWriter.println();
            if (this.machine.definitions.size() != 0) {
                Definition lastDef = this.machine.definitions.get(this.machine.definitions.size() - 1);
                printWriter.println("DEFINITIONS");
                for (Definition def : this.machine.definitions) {
                    if (!def.equals(lastDef)) {
                        printWriter.println(def.getName() + " == " + def.getBody() + ";");
                        continue;
                    }
                    printWriter.println(def.getName() + " == " + def.getBody());
                }
                printWriter.println();
            }
            printWriter.println("INITIALISATION");
            output = "";
            last = this.machine.initialisation.get(this.machine.initialisation.size() - 1);
            for (String init : this.machine.initialisation) {
                if (!init.equals(last)) {
                    output = output.concat(init + " || ");
                    continue;
                }
                output = output.concat(init);
            }
            printWriter.println(output);
            printWriter.println();
            printWriter.println("OPERATIONS");
            Operation lastOp = this.machine.operations.get(this.machine.operations.size() - 1);
            for (Operation op : this.machine.operations) {
                printWriter.println(op.getName() + " =");
                if (!op.getSelectList().isEmpty()) {
                    printWriter.print("SELECT ");
                    last = op.getSelectList().get(op.getSelectList().size() - 1);
                    output = "";
                    for (String select : op.getSelectList()) {
                        if (!select.equals(last)) {
                            select = select.replace("&lt", "<");
                            output = output.concat(select + " & ");
                            continue;
                        }
                        select = select.replace("&lt", "<");
                        output = output.concat(select + " THEN");
                    }
                    printWriter.println(output);
                } else {
                    printWriter.println("BEGIN");
                }
                if (op.getThenList().isEmpty()) continue;
                last = op.getThenList().get(op.getThenList().size() - 1);
                for (String then : op.getThenList()) {
                    if (!then.equals(last)) {
                        printWriter.print(then + " || ");
                        continue;
                    }
                    printWriter.println(then);
                    if (!op.equals(lastOp)) {
                        printWriter.println("END;");
                        printWriter.println();
                        continue;
                    }
                    printWriter.println("END");
                }
            }
            printWriter.println("END");
            printWriter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(BFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.textLable.setHorizontalTextPosition(0);
        this.textLable.setText("Saved successfully!");
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textPane = new JTextPane();
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.textLable = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(280, 420));
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        this.textPane.setForeground(new Color(0, 51, 204));
        this.textPane.setAutoscrolls(false);
        this.jScrollPane1.setViewportView(this.textPane);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BFrame.this.closeButtonActionPerformed(evt);
            }
        });
        this.textLable.setHorizontalAlignment(0);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.saveButton, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textLable, -1, 197, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton, -2, 70, -2).addContainerGap()).addComponent(this.jScrollPane1, -1, 363, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 486, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.saveButton, -1, -1, Short.MAX_VALUE).addComponent(this.closeButton).addComponent(this.textLable, -2, 19, -2)).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this.save();
    }
}

