// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.domain.village;

import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.domain.village.VillageDataOnDemand;
import sk.tuke.fei.tukevian.domain.village.VillageIntegrationTest;

privileged aspect VillageIntegrationTest_Roo_IntegrationTest {
    
    declare @type: VillageIntegrationTest: @RunWith(SpringJUnit4ClassRunner.class);
    
    declare @type: VillageIntegrationTest: @ContextConfiguration(locations = "classpath*:/META-INF/spring/applicationContext*.xml");
    
    declare @type: VillageIntegrationTest: @Transactional;
    
    @Autowired
    VillageDataOnDemand VillageIntegrationTest.dod;
    
    @Test
    public void VillageIntegrationTest.testCountVillages() {
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", dod.getRandomVillage());
        long count = Village.countVillages();
        Assert.assertTrue("Counter for 'Village' incorrectly reported there were no entries", count > 0);
    }
    
    @Test
    public void VillageIntegrationTest.testFindVillage() {
        Village obj = dod.getRandomVillage();
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Village' failed to provide an identifier", id);
        obj = Village.findVillage(id);
        Assert.assertNotNull("Find method for 'Village' illegally returned null for id '" + id + "'", obj);
        Assert.assertEquals("Find method for 'Village' returned the incorrect identifier", id, obj.getId());
    }
    
    @Test
    public void VillageIntegrationTest.testFindAllVillages() {
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", dod.getRandomVillage());
        long count = Village.countVillages();
        Assert.assertTrue("Too expensive to perform a find all test for 'Village', as there are " + count + " entries; set the findAllMaximum to exceed this value or set findAll=false on the integration test annotation to disable the test", count < 250);
        List<Village> result = Village.findAllVillages();
        Assert.assertNotNull("Find all method for 'Village' illegally returned null", result);
        Assert.assertTrue("Find all method for 'Village' failed to return any data", result.size() > 0);
    }
    
    @Test
    public void VillageIntegrationTest.testFindVillageEntries() {
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", dod.getRandomVillage());
        long count = Village.countVillages();
        if (count > 20) count = 20;
        int firstResult = 0;
        int maxResults = (int) count;
        List<Village> result = Village.findVillageEntries(firstResult, maxResults);
        Assert.assertNotNull("Find entries method for 'Village' illegally returned null", result);
        Assert.assertEquals("Find entries method for 'Village' returned an incorrect number of entries", count, result.size());
    }
    
    @Test
    public void VillageIntegrationTest.testFlush() {
        Village obj = dod.getRandomVillage();
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Village' failed to provide an identifier", id);
        obj = Village.findVillage(id);
        Assert.assertNotNull("Find method for 'Village' illegally returned null for id '" + id + "'", obj);
        boolean modified =  dod.modifyVillage(obj);
        Integer currentVersion = obj.getVersion();
        obj.flush();
        Assert.assertTrue("Version for 'Village' failed to increment on flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void VillageIntegrationTest.testMergeUpdate() {
        Village obj = dod.getRandomVillage();
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Village' failed to provide an identifier", id);
        obj = Village.findVillage(id);
        boolean modified =  dod.modifyVillage(obj);
        Integer currentVersion = obj.getVersion();
        Village merged = obj.merge();
        obj.flush();
        Assert.assertEquals("Identifier of merged object not the same as identifier of original object", merged.getId(), id);
        Assert.assertTrue("Version for 'Village' failed to increment on merge and flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void VillageIntegrationTest.testPersist() {
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", dod.getRandomVillage());
        Village obj = dod.getNewTransientVillage(Integer.MAX_VALUE);
        Assert.assertNotNull("Data on demand for 'Village' failed to provide a new transient entity", obj);
        Assert.assertNull("Expected 'Village' identifier to be null", obj.getId());
        try {
            obj.persist();
        } catch (final ConstraintViolationException e) {
            final StringBuilder msg = new StringBuilder();
            for (Iterator<ConstraintViolation<?>> iter = e.getConstraintViolations().iterator(); iter.hasNext();) {
                final ConstraintViolation<?> cv = iter.next();
                msg.append("[").append(cv.getRootBean().getClass().getName()).append(".").append(cv.getPropertyPath()).append(": ").append(cv.getMessage()).append(" (invalid value = ").append(cv.getInvalidValue()).append(")").append("]");
            }
            throw new IllegalStateException(msg.toString(), e);
        }
        obj.flush();
        Assert.assertNotNull("Expected 'Village' identifier to no longer be null", obj.getId());
    }
    
    @Test
    public void VillageIntegrationTest.testRemove() {
        Village obj = dod.getRandomVillage();
        Assert.assertNotNull("Data on demand for 'Village' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Village' failed to provide an identifier", id);
        obj = Village.findVillage(id);
        obj.remove();
        obj.flush();
        Assert.assertNull("Failed to remove 'Village' with identifier '" + id + "'", Village.findVillage(id));
    }
    
}
