// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.domain.forms;

import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import sk.tuke.fei.tukevian.domain.forms.Train;
import sk.tuke.fei.tukevian.domain.forms.TrainDataOnDemand;
import sk.tuke.fei.tukevian.domain.forms.TrainIntegrationTest;

privileged aspect TrainIntegrationTest_Roo_IntegrationTest {
    
    declare @type: TrainIntegrationTest: @RunWith(SpringJUnit4ClassRunner.class);
    
    declare @type: TrainIntegrationTest: @ContextConfiguration(locations = "classpath*:/META-INF/spring/applicationContext*.xml");
    
    declare @type: TrainIntegrationTest: @Transactional;
    
    @Autowired
    TrainDataOnDemand TrainIntegrationTest.dod;
    
    @Test
    public void TrainIntegrationTest.testCountTrains() {
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", dod.getRandomTrain());
        long count = Train.countTrains();
        Assert.assertTrue("Counter for 'Train' incorrectly reported there were no entries", count > 0);
    }
    
    @Test
    public void TrainIntegrationTest.testFindTrain() {
        Train obj = dod.getRandomTrain();
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Train' failed to provide an identifier", id);
        obj = Train.findTrain(id);
        Assert.assertNotNull("Find method for 'Train' illegally returned null for id '" + id + "'", obj);
        Assert.assertEquals("Find method for 'Train' returned the incorrect identifier", id, obj.getId());
    }
    
    @Test
    public void TrainIntegrationTest.testFindAllTrains() {
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", dod.getRandomTrain());
        long count = Train.countTrains();
        Assert.assertTrue("Too expensive to perform a find all test for 'Train', as there are " + count + " entries; set the findAllMaximum to exceed this value or set findAll=false on the integration test annotation to disable the test", count < 250);
        List<Train> result = Train.findAllTrains();
        Assert.assertNotNull("Find all method for 'Train' illegally returned null", result);
        Assert.assertTrue("Find all method for 'Train' failed to return any data", result.size() > 0);
    }
    
    @Test
    public void TrainIntegrationTest.testFindTrainEntries() {
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", dod.getRandomTrain());
        long count = Train.countTrains();
        if (count > 20) count = 20;
        int firstResult = 0;
        int maxResults = (int) count;
        List<Train> result = Train.findTrainEntries(firstResult, maxResults);
        Assert.assertNotNull("Find entries method for 'Train' illegally returned null", result);
        Assert.assertEquals("Find entries method for 'Train' returned an incorrect number of entries", count, result.size());
    }
    
    @Test
    public void TrainIntegrationTest.testFlush() {
        Train obj = dod.getRandomTrain();
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Train' failed to provide an identifier", id);
        obj = Train.findTrain(id);
        Assert.assertNotNull("Find method for 'Train' illegally returned null for id '" + id + "'", obj);
        boolean modified =  dod.modifyTrain(obj);
        Integer currentVersion = obj.getVersion();
        obj.flush();
        Assert.assertTrue("Version for 'Train' failed to increment on flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void TrainIntegrationTest.testMergeUpdate() {
        Train obj = dod.getRandomTrain();
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Train' failed to provide an identifier", id);
        obj = Train.findTrain(id);
        boolean modified =  dod.modifyTrain(obj);
        Integer currentVersion = obj.getVersion();
        Train merged = obj.merge();
        obj.flush();
        Assert.assertEquals("Identifier of merged object not the same as identifier of original object", merged.getId(), id);
        Assert.assertTrue("Version for 'Train' failed to increment on merge and flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void TrainIntegrationTest.testPersist() {
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", dod.getRandomTrain());
        Train obj = dod.getNewTransientTrain(Integer.MAX_VALUE);
        Assert.assertNotNull("Data on demand for 'Train' failed to provide a new transient entity", obj);
        Assert.assertNull("Expected 'Train' identifier to be null", obj.getId());
        try {
            obj.persist();
        } catch (final ConstraintViolationException e) {
            final StringBuilder msg = new StringBuilder();
            for (Iterator<ConstraintViolation<?>> iter = e.getConstraintViolations().iterator(); iter.hasNext();) {
                final ConstraintViolation<?> cv = iter.next();
                msg.append("[").append(cv.getRootBean().getClass().getName()).append(".").append(cv.getPropertyPath()).append(": ").append(cv.getMessage()).append(" (invalid value = ").append(cv.getInvalidValue()).append(")").append("]");
            }
            throw new IllegalStateException(msg.toString(), e);
        }
        obj.flush();
        Assert.assertNotNull("Expected 'Train' identifier to no longer be null", obj.getId());
    }
    
    @Test
    public void TrainIntegrationTest.testRemove() {
        Train obj = dod.getRandomTrain();
        Assert.assertNotNull("Data on demand for 'Train' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Train' failed to provide an identifier", id);
        obj = Train.findTrain(id);
        obj.remove();
        obj.flush();
        Assert.assertNull("Failed to remove 'Train' with identifier '" + id + "'", Train.findTrain(id));
    }
    
}
