// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.domain.forms;

import java.util.Iterator;
import java.util.List;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.annotation.Transactional;
import sk.tuke.fei.tukevian.domain.forms.Build;
import sk.tuke.fei.tukevian.domain.forms.BuildDataOnDemand;
import sk.tuke.fei.tukevian.domain.forms.BuildIntegrationTest;

privileged aspect BuildIntegrationTest_Roo_IntegrationTest {
    
    declare @type: BuildIntegrationTest: @RunWith(SpringJUnit4ClassRunner.class);
    
    declare @type: BuildIntegrationTest: @ContextConfiguration(locations = "classpath*:/META-INF/spring/applicationContext*.xml");
    
    declare @type: BuildIntegrationTest: @Transactional;
    
    @Autowired
    BuildDataOnDemand BuildIntegrationTest.dod;
    
    @Test
    public void BuildIntegrationTest.testCountBuilds() {
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", dod.getRandomBuild());
        long count = Build.countBuilds();
        Assert.assertTrue("Counter for 'Build' incorrectly reported there were no entries", count > 0);
    }
    
    @Test
    public void BuildIntegrationTest.testFindBuild() {
        Build obj = dod.getRandomBuild();
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Build' failed to provide an identifier", id);
        obj = Build.findBuild(id);
        Assert.assertNotNull("Find method for 'Build' illegally returned null for id '" + id + "'", obj);
        Assert.assertEquals("Find method for 'Build' returned the incorrect identifier", id, obj.getId());
    }
    
    @Test
    public void BuildIntegrationTest.testFindAllBuilds() {
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", dod.getRandomBuild());
        long count = Build.countBuilds();
        Assert.assertTrue("Too expensive to perform a find all test for 'Build', as there are " + count + " entries; set the findAllMaximum to exceed this value or set findAll=false on the integration test annotation to disable the test", count < 250);
        List<Build> result = Build.findAllBuilds();
        Assert.assertNotNull("Find all method for 'Build' illegally returned null", result);
        Assert.assertTrue("Find all method for 'Build' failed to return any data", result.size() > 0);
    }
    
    @Test
    public void BuildIntegrationTest.testFindBuildEntries() {
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", dod.getRandomBuild());
        long count = Build.countBuilds();
        if (count > 20) count = 20;
        int firstResult = 0;
        int maxResults = (int) count;
        List<Build> result = Build.findBuildEntries(firstResult, maxResults);
        Assert.assertNotNull("Find entries method for 'Build' illegally returned null", result);
        Assert.assertEquals("Find entries method for 'Build' returned an incorrect number of entries", count, result.size());
    }
    
    @Test
    public void BuildIntegrationTest.testFlush() {
        Build obj = dod.getRandomBuild();
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Build' failed to provide an identifier", id);
        obj = Build.findBuild(id);
        Assert.assertNotNull("Find method for 'Build' illegally returned null for id '" + id + "'", obj);
        boolean modified =  dod.modifyBuild(obj);
        Integer currentVersion = obj.getVersion();
        obj.flush();
        Assert.assertTrue("Version for 'Build' failed to increment on flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void BuildIntegrationTest.testMergeUpdate() {
        Build obj = dod.getRandomBuild();
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Build' failed to provide an identifier", id);
        obj = Build.findBuild(id);
        boolean modified =  dod.modifyBuild(obj);
        Integer currentVersion = obj.getVersion();
        Build merged = obj.merge();
        obj.flush();
        Assert.assertEquals("Identifier of merged object not the same as identifier of original object", merged.getId(), id);
        Assert.assertTrue("Version for 'Build' failed to increment on merge and flush directive", (currentVersion != null && obj.getVersion() > currentVersion) || !modified);
    }
    
    @Test
    public void BuildIntegrationTest.testPersist() {
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", dod.getRandomBuild());
        Build obj = dod.getNewTransientBuild(Integer.MAX_VALUE);
        Assert.assertNotNull("Data on demand for 'Build' failed to provide a new transient entity", obj);
        Assert.assertNull("Expected 'Build' identifier to be null", obj.getId());
        try {
            obj.persist();
        } catch (final ConstraintViolationException e) {
            final StringBuilder msg = new StringBuilder();
            for (Iterator<ConstraintViolation<?>> iter = e.getConstraintViolations().iterator(); iter.hasNext();) {
                final ConstraintViolation<?> cv = iter.next();
                msg.append("[").append(cv.getRootBean().getClass().getName()).append(".").append(cv.getPropertyPath()).append(": ").append(cv.getMessage()).append(" (invalid value = ").append(cv.getInvalidValue()).append(")").append("]");
            }
            throw new IllegalStateException(msg.toString(), e);
        }
        obj.flush();
        Assert.assertNotNull("Expected 'Build' identifier to no longer be null", obj.getId());
    }
    
    @Test
    public void BuildIntegrationTest.testRemove() {
        Build obj = dod.getRandomBuild();
        Assert.assertNotNull("Data on demand for 'Build' failed to initialize correctly", obj);
        Long id = obj.getId();
        Assert.assertNotNull("Data on demand for 'Build' failed to provide an identifier", id);
        obj = Build.findBuild(id);
        obj.remove();
        obj.flush();
        Assert.assertNull("Failed to remove 'Build' with identifier '" + id + "'", Build.findBuild(id));
    }
    
}
