// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.player.Player;
import sk.tuke.fei.tukevian.domain.village.Buildings;
import sk.tuke.fei.tukevian.domain.village.Resources;
import sk.tuke.fei.tukevian.domain.village.Troops;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.web.game.VillageController;

privileged aspect VillageController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String VillageController.create(@Valid Village village, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, village);
            return "villages/create";
        }
        uiModel.asMap().clear();
        village.persist();
        return "redirect:/villages/" + encodeUrlPathSegment(village.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String VillageController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Village());
        return "villages/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String VillageController.show(@PathVariable("id") Long id, Model uiModel) {
        uiModel.addAttribute("village", Village.findVillage(id));
        uiModel.addAttribute("itemId", id);
        return "villages/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String VillageController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("villages", Village.findVillageEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Village.countVillages() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("villages", Village.findAllVillages(sortFieldName, sortOrder));
        }
        return "villages/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String VillageController.update(@Valid Village village, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, village);
            return "villages/update";
        }
        uiModel.asMap().clear();
        village.merge();
        return "redirect:/villages/" + encodeUrlPathSegment(village.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String VillageController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Village.findVillage(id));
        return "villages/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String VillageController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Village village = Village.findVillage(id);
        village.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/villages";
    }
    
    void VillageController.populateEditForm(Model uiModel, Village village) {
        uiModel.addAttribute("village", village);
        uiModel.addAttribute("players", Player.findAllPlayers());
        uiModel.addAttribute("buildingses", Buildings.findAllBuildingses());
        uiModel.addAttribute("resourceses", Resources.findAllResourceses());
        uiModel.addAttribute("troopses", Troops.findAllTroopses());
    }
    
    String VillageController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
