// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.actions.SoldierType;
import sk.tuke.fei.tukevian.domain.forms.Train;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.web.game.TrainController;

privileged aspect TrainController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String TrainController.create(@Valid Train train, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, train);
            return "trains/create";
        }
        uiModel.asMap().clear();
        train.persist();
        return "redirect:/trains/" + encodeUrlPathSegment(train.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String TrainController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Train());
        return "trains/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String TrainController.show(@PathVariable("id") Long id, Model uiModel) {
        uiModel.addAttribute("train", Train.findTrain(id));
        uiModel.addAttribute("itemId", id);
        return "trains/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String TrainController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("trains", Train.findTrainEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Train.countTrains() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("trains", Train.findAllTrains(sortFieldName, sortOrder));
        }
        return "trains/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String TrainController.update(@Valid Train train, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, train);
            return "trains/update";
        }
        uiModel.asMap().clear();
        train.merge();
        return "redirect:/trains/" + encodeUrlPathSegment(train.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String TrainController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Train.findTrain(id));
        return "trains/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String TrainController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Train train = Train.findTrain(id);
        train.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/trains";
    }
    
    void TrainController.populateEditForm(Model uiModel, Train train) {
        uiModel.addAttribute("train", train);
        uiModel.addAttribute("soldiertypes", Arrays.asList(SoldierType.values()));
        uiModel.addAttribute("villages", Village.findAllVillages());
    }
    
    String TrainController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
